/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import me.desht.pneumaticcraft.common.NBTUtil;
import me.desht.pneumaticcraft.common.tileentity.TileEntityChargingStation;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryPneumaticInventoryItem
extends InventoryBasic {
    protected String field_70483_a;
    private ItemStack armorStack;
    private final TileEntityChargingStation te;
    private boolean reading = false;

    public InventoryPneumaticInventoryItem(TileEntityChargingStation te) {
        super("", false, InventoryPneumaticInventoryItem.getInventorySize(te.getPrimaryInventory().getStackInSlot(0)));
        this.te = te;
        this.armorStack = te.getPrimaryInventory().getStackInSlot(0);
        if (!this.hasInventory()) {
            this.createInventory();
        }
        this.loadInventory();
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.reading) {
            this.saveInventory();
        }
    }

    public void func_174889_b(EntityPlayer player) {
        this.loadInventory();
    }

    public void func_174886_c(EntityPlayer player) {
        this.saveInventory();
    }

    public String func_70005_c_() {
        return "Pneumatic Helmet";
    }

    protected static int getInventorySize(ItemStack is) {
        return 9;
    }

    protected boolean hasInventory() {
        return NBTUtil.hasTag(this.armorStack, "UpgradeInventory");
    }

    protected void createInventory() {
        this.writeToNBT();
    }

    public void loadInventory() {
        this.readFromNBT();
    }

    public void saveInventory() {
        this.writeToNBT();
    }

    private void updateToChargingStation() {
        this.te.getPrimaryInventory().setStackInSlot(0, this.armorStack);
    }

    public void writeToNBT() {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            NBTTagCompound slotEntry = new NBTTagCompound();
            slotEntry.func_74774_a("Slot", (byte)i);
            this.func_70301_a(i).func_77955_b(slotEntry);
            itemList.func_74742_a((NBTBase)slotEntry);
        }
        NBTTagCompound inventory = new NBTTagCompound();
        inventory.func_74782_a("Items", (NBTBase)itemList);
        NBTUtil.setCompoundTag(this.armorStack, "UpgradeInventory", (NBTBase)inventory);
        NBTUtil.removeTag(this.armorStack, "Inventory");
    }

    protected void readFromNBT() {
        this.reading = true;
        if (NBTUtil.hasTag(this.armorStack, "Inventory") && this.armorStack.func_77978_p().func_74781_a("Inventory") instanceof NBTTagCompound) {
            Log.info("Converting 'Inventory' tag to 'UpgradeInventory' in Pneumatic items");
            this.armorStack.func_77978_p().func_74782_a("UpgradeInventory", this.armorStack.func_77978_p().func_74781_a("Inventory"));
            this.armorStack.func_77978_p().func_82580_o("Inventory");
        }
        NBTTagList itemList = NBTUtil.getCompoundTag(this.armorStack, "UpgradeInventory").func_150295_c("Items", 10);
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound slotEntry = itemList.func_150305_b(i);
            byte j = slotEntry.func_74771_c("Slot");
            if (j < 0 || j >= this.func_70302_i_()) continue;
            this.func_70299_a(j, new ItemStack(slotEntry));
        }
        this.reading = false;
    }
}

