/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import me.desht.pneumaticcraft.api.item.IUpgradeAcceptor;
import me.desht.pneumaticcraft.common.NBTUtil;
import me.desht.pneumaticcraft.common.tileentity.FilteredItemStackHandler;
import me.desht.pneumaticcraft.common.tileentity.TileEntityChargingStation;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;

public class ChargeableItemHandler
extends FilteredItemStackHandler {
    private static final int INVENTORY_SIZE = 9;
    public static final String NBT_UPGRADE_TAG = "UpgradeInventory";
    private final ItemStack chargingItem;
    private final TileEntityChargingStation te;

    public ChargeableItemHandler(TileEntityChargingStation te) {
        super(9);
        this.chargingItem = te.getChargingItem();
        this.te = te;
        if (!this.hasInventory()) {
            this.createInventory();
        }
        this.loadInventory();
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.saveInventory();
        this.te.func_70296_d();
    }

    private boolean hasInventory() {
        return NBTUtil.hasTag(this.chargingItem, NBT_UPGRADE_TAG);
    }

    private void createInventory() {
        this.writeToNBT();
    }

    private void loadInventory() {
        this.readFromNBT();
    }

    public void saveInventory() {
        this.writeToNBT();
    }

    public void writeToNBT() {
        NBTUtil.setCompoundTag(this.chargingItem, NBT_UPGRADE_TAG, (NBTBase)this.serializeNBT());
    }

    private void readFromNBT() {
        this.deserializeNBT(NBTUtil.getCompoundTag(this.chargingItem, NBT_UPGRADE_TAG));
    }

    @Override
    public boolean test(Integer integer, ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return true;
        }
        if (this.chargingItem.func_77973_b() instanceof IUpgradeAcceptor) {
            return ((IUpgradeAcceptor)this.chargingItem.func_77973_b()).getApplicableUpgrades().contains(itemStack.func_77973_b());
        }
        return false;
    }
}

