/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat.behaviour;

import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.heat.HeatExchangerManager;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourLiquid;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;

public abstract class HeatBehaviourTransition
extends HeatBehaviourLiquid {
    private double extractedHeat;
    private double maxExchangedHeat;
    private double blockTemp = -1.0;
    private IHeatExchangerLogic logic;

    @Override
    public boolean isApplicable() {
        this.logic = HeatExchangerManager.getInstance().getLogic(this.getWorld(), this.getPos(), null);
        return this.logic != null;
    }

    protected abstract int getMaxExchangedHeat();

    protected abstract boolean transitionOnTooMuchExtraction();

    @Override
    public void update() {
        if (this.blockTemp == -1.0) {
            this.blockTemp = this.logic.getTemperature();
            this.maxExchangedHeat = (double)this.getMaxExchangedHeat() * (this.logic.getThermalResistance() + this.getHeatExchanger().getThermalResistance());
        }
        this.extractedHeat += this.blockTemp - this.getHeatExchanger().getTemperature();
        if (this.transitionOnTooMuchExtraction() ? this.extractedHeat > this.maxExchangedHeat : this.extractedHeat < -this.maxExchangedHeat) {
            this.transformBlock();
            this.extractedHeat -= this.maxExchangedHeat;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74780_a("extractedHeat", this.extractedHeat);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.extractedHeat = tag.func_74769_h("extractedHeat");
    }

    protected abstract void transformBlock();

    protected void onTransition(BlockPos pos) {
        NetworkHandler.sendToAllAround(new PacketPlaySound(SoundEvents.field_187541_bC, SoundCategory.AMBIENT, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.5f, 2.6f + (this.getWorld().field_73012_v.nextFloat() - this.getWorld().field_73012_v.nextFloat()) * 0.8f, true), this.getWorld());
        for (int i = 0; i < 8; ++i) {
            double randX = (double)pos.func_177958_n() + this.getWorld().field_73012_v.nextDouble();
            double randZ = (double)pos.func_177952_p() + this.getWorld().field_73012_v.nextDouble();
            NetworkHandler.sendToAllAround(new PacketSpawnParticle(EnumParticleTypes.SMOKE_LARGE, randX, pos.func_177956_o() + 1, randZ, 0.0, 0.0, 0.0), this.getWorld());
        }
    }
}

