/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.heat.HeatBehaviour;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.heat.HeatExchangerManager;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourManager;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HeatExchangerLogic
implements IHeatExchangerLogic {
    private final Set<IHeatExchangerLogic> hullExchangers = new HashSet<IHeatExchangerLogic>();
    private final Set<IHeatExchangerLogic> connectedExchangers = new HashSet<IHeatExchangerLogic>();
    private List<HeatBehaviour> behaviours = new ArrayList<HeatBehaviour>();
    private List<HeatBehaviour> newBehaviours;
    @GuiSynced
    private double temperature = 295.0;
    private double thermalResistance = 1.0;
    private double thermalCapacity = 1.0;
    private static boolean isAddingOrRemovingLogic;

    @Override
    public void initializeAsHull(World world, BlockPos pos, EnumFacing ... validSides) {
        if (world.field_72995_K) {
            return;
        }
        for (IHeatExchangerLogic logic : this.hullExchangers) {
            this.removeConnectedExchanger(logic);
        }
        this.hullExchangers.clear();
        this.newBehaviours = new ArrayList<HeatBehaviour>();
        for (EnumFacing d : EnumFacing.field_82609_l) {
            if (!this.isSideValid(validSides, d)) continue;
            HeatBehaviourManager.getInstance().addHeatBehaviours(world, pos.func_177972_a(d), this, this.newBehaviours);
            IHeatExchangerLogic logic = HeatExchangerManager.getInstance().getLogic(world, pos.func_177972_a(d), d.func_176734_d());
            if (logic == null) continue;
            this.hullExchangers.add(logic);
            this.addConnectedExchanger(logic);
        }
    }

    private boolean isSideValid(EnumFacing[] validSides, EnumFacing side) {
        if (validSides.length == 0) {
            return true;
        }
        for (EnumFacing d : validSides) {
            if (d != side) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addConnectedExchanger(IHeatExchangerLogic exchanger) {
        this.connectedExchangers.add(exchanger);
        if (!isAddingOrRemovingLogic) {
            isAddingOrRemovingLogic = true;
            exchanger.addConnectedExchanger(this);
            isAddingOrRemovingLogic = false;
        }
    }

    @Override
    public void removeConnectedExchanger(IHeatExchangerLogic exchanger) {
        this.connectedExchangers.remove(exchanger);
        if (!isAddingOrRemovingLogic) {
            isAddingOrRemovingLogic = true;
            exchanger.removeConnectedExchanger(this);
            isAddingOrRemovingLogic = false;
        }
    }

    @Override
    public double getTemperature() {
        return this.temperature;
    }

    @Override
    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    @Override
    public void setThermalResistance(double thermalResistance) {
        this.thermalResistance = thermalResistance;
    }

    @Override
    public double getThermalResistance() {
        return this.thermalResistance;
    }

    @Override
    public void setThermalCapacity(double capacity) {
        this.thermalCapacity = capacity;
    }

    @Override
    public double getThermalCapacity() {
        return this.thermalCapacity;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74780_a("temperature", this.temperature);
        NBTTagList tagList = new NBTTagList();
        for (HeatBehaviour behaviour : this.behaviours) {
            NBTTagCompound t = new NBTTagCompound();
            t.func_74778_a("id", behaviour.getId());
            behaviour.writeToNBT(t);
            tagList.func_74742_a((NBTBase)t);
        }
        tag.func_74782_a("behaviours", (NBTBase)tagList);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.temperature = tag.func_74769_h("temperature");
        this.behaviours.clear();
        NBTTagList tagList = tag.func_150295_c("behaviours", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound t = tagList.func_150305_b(i);
            HeatBehaviour behaviour = HeatBehaviourManager.getInstance().getBehaviourForId(t.func_74779_i("id"));
            if (behaviour == null) continue;
            behaviour.readFromNBT(t);
            this.behaviours.add(behaviour);
        }
    }

    @Override
    public void update() {
        if (this.getThermalCapacity() < 0.1) {
            this.temperature = 295.0;
            return;
        }
        if (this.newBehaviours != null) {
            List<HeatBehaviour> oldBehaviours = this.behaviours;
            this.behaviours = this.newBehaviours;
            this.newBehaviours = null;
            for (HeatBehaviour oldBehaviour : oldBehaviours) {
                int equalBehaviourIndex = this.behaviours.indexOf(oldBehaviour);
                if (equalBehaviourIndex < 0) continue;
                NBTTagCompound tag = new NBTTagCompound();
                oldBehaviour.writeToNBT(tag);
                this.behaviours.get(equalBehaviourIndex).readFromNBT(tag);
            }
        }
        Iterator<HeatBehaviour> iterator = this.behaviours.iterator();
        while (iterator.hasNext()) {
            HeatBehaviour behaviour = iterator.next();
            if (behaviour.getWorld() == null) continue;
            if (behaviour.isApplicable()) {
                behaviour.update();
                continue;
            }
            iterator.remove();
        }
        for (IHeatExchangerLogic logic : this.connectedExchangers) {
            HeatExchangerLogic.exchange(logic, this, this.getTickingHeatExchangers());
        }
    }

    public static void exchange(IHeatExchangerLogic logic, IHeatExchangerLogic logic2) {
        HeatExchangerLogic.exchange(logic, logic2, 1.0);
    }

    public static void exchange(IHeatExchangerLogic logic, IHeatExchangerLogic logic2, double dispersionDivider) {
        if (logic.getThermalCapacity() < 0.1) {
            logic.setTemperature(295.0);
            return;
        }
        double deltaTemp = logic.getTemperature() - logic2.getTemperature();
        double totalResistance = logic2.getThermalResistance() + logic.getThermalResistance();
        deltaTemp /= dispersionDivider;
        deltaTemp /= totalResistance;
        double maxDeltaTemp = (logic.getTemperature() * logic.getThermalCapacity() - logic2.getTemperature() * logic2.getThermalCapacity()) / 2.0;
        if (maxDeltaTemp >= 0.0 && deltaTemp > maxDeltaTemp || maxDeltaTemp <= 0.0 && deltaTemp < maxDeltaTemp) {
            deltaTemp = maxDeltaTemp;
        }
        logic2.addHeat(deltaTemp);
        logic.addHeat(-deltaTemp);
    }

    private int getTickingHeatExchangers() {
        int tickingHeatExchangers = 1;
        for (IHeatExchangerLogic logic : this.connectedExchangers) {
            if (!(logic instanceof HeatExchangerLogic)) continue;
            ++tickingHeatExchangers;
        }
        return tickingHeatExchangers;
    }

    @Override
    public void addHeat(double amount) {
        this.temperature += amount / this.getThermalCapacity();
        this.temperature = Math.max(0.0, Math.min(2273.0, this.temperature));
    }
}

