/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.config;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Set;
import me.desht.pneumaticcraft.common.config.JsonConfig;

public class HelmetWidgetDefaults
extends JsonConfig {
    private final Set<String> keyBinds = Sets.newHashSet();
    public static HelmetWidgetDefaults INSTANCE = new HelmetWidgetDefaults();

    private HelmetWidgetDefaults() {
        super(true);
    }

    @Override
    public String getConfigFilename() {
        return "HelmetWidgetDefaults";
    }

    @Override
    protected void writeToJson(JsonObject json) {
        json.addProperty("description", "Tracks the active upgrades for the Pneumatic Helmet");
        JsonArray array = new JsonArray();
        for (String s : this.keyBinds) {
            array.add(s);
        }
        json.add("active", (JsonElement)array);
    }

    @Override
    protected void readFromJson(JsonObject json) {
        JsonArray array = json.get("active").getAsJsonArray();
        this.keyBinds.clear();
        for (JsonElement element : array) {
            this.keyBinds.add(element.getAsString());
        }
    }

    public void setKey(String keyBindName, boolean checked) {
        if (checked) {
            this.keyBinds.add(keyBindName);
        } else {
            this.keyBinds.remove(keyBindName);
        }
    }

    public boolean getKey(String keyBindingName) {
        return this.keyBinds.contains(keyBindingName);
    }
}

