/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.semiblock.IProvidingInventoryListener;
import me.desht.pneumaticcraft.common.semiblock.ISpecificProvider;
import me.desht.pneumaticcraft.common.semiblock.ISpecificRequester;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockLogistics;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class LogisticsManager {
    private final List<SemiBlockLogistics>[] logistics = new List[4];

    public LogisticsManager() {
        for (int i = 0; i < this.logistics.length; ++i) {
            this.logistics[i] = new ArrayList<SemiBlockLogistics>();
        }
    }

    void clearLogistics() {
        for (List<SemiBlockLogistics> list : this.logistics) {
            list.clear();
        }
    }

    public void addLogisticFrame(SemiBlockLogistics frame) {
        this.logistics[frame.getPriority()].add(frame);
    }

    public PriorityQueue<LogisticsTask> getTasks(Object holdingStack) {
        ItemStack item = holdingStack instanceof ItemStack ? (ItemStack)holdingStack : null;
        FluidStack fluid = holdingStack instanceof FluidStack ? (FluidStack)holdingStack : null;
        PriorityQueue<LogisticsTask> tasks = new PriorityQueue<LogisticsTask>();
        for (int priority = this.logistics.length - 1; priority >= 0; --priority) {
            for (SemiBlockLogistics requester : this.logistics[priority]) {
                for (int i = 0; i < priority; ++i) {
                    for (SemiBlockLogistics provider : this.logistics[i]) {
                        int requestedAmount;
                        if (!provider.shouldProvideTo(priority)) continue;
                        if (item != null) {
                            requestedAmount = LogisticsManager.getRequestedAmount(requester, item);
                            if (requestedAmount <= 0) continue;
                            ItemStack stack = item.func_77946_l();
                            stack.func_190920_e(requestedAmount);
                            tasks.add(new LogisticsTask(provider, requester, stack));
                            return tasks;
                        }
                        if (fluid != null) {
                            requestedAmount = LogisticsManager.getRequestedAmount(requester, fluid);
                            if (requestedAmount <= 0) continue;
                            fluid = fluid.copy();
                            fluid.amount = requestedAmount;
                            tasks.add(new LogisticsTask(provider, requester, new SemiBlockLogistics.FluidStackWrapper(fluid)));
                            return tasks;
                        }
                        this.tryProvide(provider, requester, tasks);
                    }
                }
            }
        }
        return tasks;
    }

    private void tryProvide(SemiBlockLogistics provider, SemiBlockLogistics requester, PriorityQueue<LogisticsTask> tasks) {
        IItemHandler providingInventory = IOHelper.getInventoryForTE(provider.getTileEntity());
        if (providingInventory != null) {
            if (requester instanceof IProvidingInventoryListener) {
                ((IProvidingInventoryListener)((Object)requester)).notify((TileEntity)provider.getTileEntity());
            }
            for (int i = 0; i < providingInventory.getSlots(); ++i) {
                int requestedAmount;
                ItemStack providingStack = providingInventory.getStackInSlot(i);
                if (providingStack.func_190926_b() || provider instanceof ISpecificProvider && !((ISpecificProvider)((Object)provider)).canProvide(providingStack) || (requestedAmount = LogisticsManager.getRequestedAmount(requester, providingStack)) <= 0) continue;
                ItemStack stack = providingStack.func_77946_l();
                stack.func_190920_e(requestedAmount);
                tasks.add(new LogisticsTask(provider, requester, stack));
            }
        }
        for (EnumFacing d : EnumFacing.field_82609_l) {
            int requestedAmount;
            if (provider.getTileEntity() == null || !provider.getTileEntity().hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, d)) continue;
            IFluidHandler handler = (IFluidHandler)provider.getTileEntity().getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, d);
            FluidStack providingStack = handler.drain(16000, false);
            boolean canDrain = Arrays.stream(handler.getTankProperties()).anyMatch(p -> p.canDrainFluidType(providingStack));
            if (providingStack == null || provider instanceof ISpecificProvider && !((ISpecificProvider)((Object)provider)).canProvide(providingStack) || !canDrain || (requestedAmount = LogisticsManager.getRequestedAmount(requester, providingStack)) <= 0) continue;
            FluidStack stack = providingStack.copy();
            stack.amount = requestedAmount;
            tasks.add(new LogisticsTask(provider, requester, new SemiBlockLogistics.FluidStackWrapper(stack)));
        }
    }

    public static int getRequestedAmount(SemiBlockLogistics requester, ItemStack providingStack) {
        EnumFacing d;
        int requestedAmount;
        Object te = requester.getTileEntity();
        if (te == null) {
            return 0;
        }
        int n = requestedAmount = requester instanceof ISpecificRequester ? ((ISpecificRequester)((Object)requester)).amountRequested(providingStack) : providingStack.func_77976_d();
        if (requestedAmount == 0) {
            return 0;
        }
        providingStack = providingStack.func_77946_l();
        providingStack.func_190920_e(requestedAmount);
        ItemStack remainder = providingStack.func_77946_l();
        remainder.func_190917_f(requester.getIncomingItems(providingStack));
        EnumFacing[] enumFacingArray = EnumFacing.field_82609_l;
        int n2 = enumFacingArray.length;
        for (int i = 0; i < n2 && !(remainder = IOHelper.insert(te, remainder, d = enumFacingArray[i], true)).func_190926_b(); ++i) {
        }
        providingStack.func_190918_g(remainder.func_190916_E());
        if (providingStack.func_190916_E() <= 0) {
            return 0;
        }
        return providingStack.func_190916_E();
    }

    public static int getRequestedAmount(SemiBlockLogistics requester, FluidStack providingStack) {
        int requestedAmount;
        int n = requestedAmount = requester instanceof ISpecificRequester ? ((ISpecificRequester)((Object)requester)).amountRequested(providingStack) : providingStack.amount;
        if (requestedAmount == 0) {
            return 0;
        }
        providingStack = providingStack.copy();
        providingStack.amount = requestedAmount;
        FluidStack remainder = providingStack.copy();
        remainder.amount += requester.getIncomingFluid(remainder.getFluid());
        Object te = requester.getTileEntity();
        if (te == null) {
            return 0;
        }
        for (EnumFacing d : EnumFacing.field_82609_l) {
            IFluidHandler handler;
            int fluidFilled;
            if (!te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, d) || (fluidFilled = (handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, d)).fill(remainder, false)) <= 0) continue;
            remainder.amount -= fluidFilled;
            break;
        }
        providingStack.amount -= remainder.amount;
        if (providingStack.amount <= 0) {
            return 0;
        }
        return providingStack.amount;
    }

    public static class LogisticsTask
    implements Comparable<LogisticsTask> {
        public final SemiBlockLogistics provider;
        public final SemiBlockLogistics requester;
        @Nonnull
        public final ItemStack transportingItem;
        public final SemiBlockLogistics.FluidStackWrapper transportingFluid;

        LogisticsTask(SemiBlockLogistics provider, SemiBlockLogistics requester, ItemStack transportingItem) {
            this.provider = provider;
            this.requester = requester;
            this.transportingItem = transportingItem;
            this.transportingFluid = null;
        }

        LogisticsTask(SemiBlockLogistics provider, SemiBlockLogistics requester, SemiBlockLogistics.FluidStackWrapper transportingFluid) {
            this.provider = provider;
            this.requester = requester;
            this.transportingFluid = transportingFluid;
            this.transportingItem = ItemStack.field_190927_a;
        }

        void informRequester() {
            if (!this.transportingItem.func_190926_b()) {
                this.requester.informIncomingStack(this.transportingItem);
            } else {
                this.requester.informIncomingStack(this.transportingFluid);
            }
        }

        public boolean isStillValid(Object stack) {
            if (!this.transportingItem.func_190926_b() && stack instanceof ItemStack) {
                int requestedAmount = LogisticsManager.getRequestedAmount(this.requester, (ItemStack)stack);
                return requestedAmount == ((ItemStack)stack).func_190916_E();
            }
            if (this.transportingFluid != null && stack instanceof FluidStack) {
                int requestedAmount = LogisticsManager.getRequestedAmount(this.requester, (FluidStack)stack);
                return requestedAmount == ((FluidStack)stack).amount;
            }
            return false;
        }

        @Override
        public int compareTo(LogisticsTask task) {
            int value = !this.transportingItem.func_190926_b() ? this.transportingItem.func_190916_E() * 100 : this.transportingFluid.stack.amount;
            int otherValue = !task.transportingItem.func_190926_b() ? task.transportingItem.func_190916_E() * 100 : task.transportingFluid.stack.amount;
            return otherValue - value;
        }
    }
}

