/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import me.desht.pneumaticcraft.api.drone.IBlockInteractHandler;
import me.desht.pneumaticcraft.api.drone.ICustomBlockInteract;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class DroneInteractRFExport
implements ICustomBlockInteract {
    @Override
    public String getName() {
        return "rfExport";
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_RF_EX;
    }

    @Override
    public boolean doInteract(BlockPos pos, IDrone drone, IBlockInteractHandler interactHandler, boolean simulate) {
        if (!drone.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return false;
        }
        IEnergyStorage droneStorage = (IEnergyStorage)drone.getCapability(CapabilityEnergy.ENERGY, null);
        if (droneStorage.getEnergyStored() == 0) {
            interactHandler.abort();
            return false;
        }
        TileEntity te = drone.world().func_175625_s(pos);
        if (te == null) {
            return false;
        }
        for (EnumFacing face : EnumFacing.field_82609_l) {
            IEnergyStorage teStorage;
            int transferredEnergy;
            if (!te.hasCapability(CapabilityEnergy.ENERGY, face) || (transferredEnergy = droneStorage.extractEnergy((teStorage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, face)).receiveEnergy(interactHandler.useCount() ? interactHandler.getRemainingCount() : Integer.MAX_VALUE, true), true)) <= 0) continue;
            if (!simulate) {
                interactHandler.decreaseCount(transferredEnergy);
                droneStorage.extractEnergy(transferredEnergy, false);
                teStorage.receiveEnergy(transferredEnergy, false);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getCraftingColorIndex() {
        return 14;
    }
}

