/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IHackableBlock;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IHackableEntity;
import me.desht.pneumaticcraft.api.hacking.IHacking;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.PneumaticHelmetRegistry;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.hacking.CapabilityHackingProvider;
import me.desht.pneumaticcraft.common.util.WorldAndCoord;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class HackTickHandler {
    private final Map<WorldAndCoord, IHackableBlock> hackedBlocks = new HashMap<WorldAndCoord, IHackableBlock>();

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Iterator<Map.Entry<WorldAndCoord, IHackableBlock>> blockIterator = this.hackedBlocks.entrySet().iterator();
            while (blockIterator.hasNext()) {
                Map.Entry<WorldAndCoord, IHackableBlock> entry = blockIterator.next();
                IHackableBlock hackableBlock = entry.getValue();
                WorldAndCoord hackedBlock = entry.getKey();
                boolean found = false;
                for (Map.Entry<Block, Class<? extends IHackableBlock>> registeredEntry : PneumaticHelmetRegistry.getInstance().hackableBlocks.entrySet()) {
                    if (hackableBlock.getClass() != registeredEntry.getValue() || hackedBlock.getBlock() != registeredEntry.getKey()) continue;
                    if (!hackableBlock.afterHackTick((World)hackedBlock.world, hackedBlock.pos)) {
                        blockIterator.remove();
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                blockIterator.remove();
            }
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            try {
                for (Entity entity : event.world.field_72996_f) {
                    IHacking hack;
                    if (!entity.hasCapability(CapabilityHackingProvider.HACKING_CAPABILITY, null) || (hack = (IHacking)entity.getCapability(CapabilityHackingProvider.HACKING_CAPABILITY, null)).getCurrentHacks().isEmpty()) continue;
                    hack.update(entity);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void trackBlock(WorldAndCoord coord, IHackableBlock iHackable) {
        this.hackedBlocks.put(coord, iHackable);
    }

    public void trackEntity(Entity entity, IHackableEntity iHackable) {
        if (iHackable.getId() != null && entity.hasCapability(CapabilityHackingProvider.HACKING_CAPABILITY, null)) {
            IHacking hack = (IHacking)entity.getCapability(CapabilityHackingProvider.HACKING_CAPABILITY, null);
            hack.addHackable(iHackable);
        }
    }
}

