/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.semiblock;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.client.semiblock.ISemiBlockRenderer;
import me.desht.pneumaticcraft.client.semiblock.SemiBlockRendererCropSupport;
import me.desht.pneumaticcraft.client.semiblock.SemiBlockRendererHeatFrame;
import me.desht.pneumaticcraft.client.semiblock.SemiBlockRendererLogistics;
import me.desht.pneumaticcraft.client.semiblock.SemiBlockRendererSpawnerAgitator;
import me.desht.pneumaticcraft.client.semiblock.SemiBlockRendererTransferGadget;
import me.desht.pneumaticcraft.common.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockCropSupport;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockHeatFrame;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockLogistics;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockManager;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockSpawnerAgitator;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockTransferGadget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientSemiBlockManager {
    private static final Map<Class<? extends ISemiBlock>, ISemiBlockRenderer<?>> renderers = new HashMap();

    public static <T extends ISemiBlock> void registerRenderer(Class<T> semiBlock, ISemiBlockRenderer<T> renderer) {
        renderers.put(semiBlock, renderer);
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = mc.field_71439_g;
        double playerX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)event.getPartialTicks();
        double playerY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)event.getPartialTicks();
        double playerZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)event.getPartialTicks();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-playerX), (double)(-playerY), (double)(-playerZ));
        RenderHelper.func_74519_b();
        for (Map<BlockPos, List<ISemiBlock>> map : SemiBlockManager.getInstance(player.field_70170_p).getSemiBlocks().values()) {
            for (List<ISemiBlock> semiBlocks : map.values()) {
                for (ISemiBlock semiBlock : semiBlocks) {
                    ISemiBlockRenderer<?> renderer = ClientSemiBlockManager.getRenderer(semiBlock);
                    if (renderer == null) continue;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)semiBlock.getPos().func_177958_n(), (float)semiBlock.getPos().func_177956_o(), (float)semiBlock.getPos().func_177952_p());
                    renderer.render(semiBlock, event.getPartialTicks());
                    GlStateManager.func_179121_F();
                }
            }
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
    }

    public static ISemiBlockRenderer<?> getRenderer(ISemiBlock semiBlock) {
        Class<?> clazz;
        for (clazz = semiBlock.getClass(); clazz != Object.class && !renderers.containsKey(clazz); clazz = clazz.getSuperclass()) {
        }
        return renderers.get(clazz);
    }

    static {
        ClientSemiBlockManager.registerRenderer(SemiBlockLogistics.class, new SemiBlockRendererLogistics());
        ClientSemiBlockManager.registerRenderer(SemiBlockHeatFrame.class, new SemiBlockRendererHeatFrame());
        ClientSemiBlockManager.registerRenderer(SemiBlockSpawnerAgitator.class, new SemiBlockRendererSpawnerAgitator());
        ClientSemiBlockManager.registerRenderer(SemiBlockCropSupport.class, new SemiBlockRendererCropSupport());
        ClientSemiBlockManager.registerRenderer(SemiBlockTransferGadget.class, new SemiBlockRendererTransferGadget());
    }
}

