/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumaticArmor;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.BlockTrackEvent;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.client.gui.pneumaticHelmet.GuiBlockTrackOptions;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.ArmorMessage;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.RenderBlockTarget;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.SearchUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.blockTracker.BlockTrackEntryList;
import me.desht.pneumaticcraft.common.CommonHUDHandler;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketDescriptionPacketRequest;
import me.desht.pneumaticcraft.common.recipes.CraftingRegistrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;

public class BlockTrackUpgradeHandler
implements IUpgradeRenderHandler {
    private static final int BLOCK_TRACKING_RANGE = 30;
    private final List<RenderBlockTarget> blockTargets = new ArrayList<RenderBlockTarget>();
    private GuiAnimatedStat blockTrackInfo;
    private int statX;
    private int statY;
    private boolean statLeftSided;
    private int[] blockTypeCount;
    private int ticksExisted;
    private int updateInterval = 20;
    private static final int MAX_TIME = 10;
    private long accTime;

    @Override
    public String getUpgradeName() {
        return "blockTracker";
    }

    @Override
    public void initConfig() {
        this.statX = ConfigHandler.helmetOptions.blockTrackerX;
        this.statY = ConfigHandler.helmetOptions.blockTrackerY;
        this.statLeftSided = ConfigHandler.helmetOptions.blockTrackerLeft;
    }

    @Override
    public void saveToConfig() {
        ConfigHandler.helmetOptions.blockTrackerX = this.statX = this.blockTrackInfo.getBaseX();
        ConfigHandler.helmetOptions.blockTrackerY = this.statY = this.blockTrackInfo.getBaseY();
        ConfigHandler.helmetOptions.blockTrackerLeft = this.statLeftSided = this.blockTrackInfo.isLeftSided();
        ConfigHandler.sync();
    }

    @Override
    public void update(EntityPlayer player, int rangeUpgrades) {
        int i;
        ++this.ticksExisted;
        SearchUpgradeHandler searchHandler = HUDHandler.instance().getSpecificRenderer(SearchUpgradeHandler.class);
        if (this.ticksExisted % this.updateInterval == 0) {
            int timeTaken = (int)this.accTime / this.updateInterval;
            this.updateInterval = this.updateInterval * timeTaken / 10;
            if (this.updateInterval <= 1) {
                this.updateInterval = 2;
            }
            this.accTime = 0L;
            this.ticksExisted = 0;
        }
        this.accTime -= System.currentTimeMillis();
        int blockTrackRange = 30 + Math.min(rangeUpgrades, 5) * 5;
        int baseX = (int)Math.floor(player.field_70165_t) - blockTrackRange;
        int baseY = (int)Math.floor(player.field_70163_u) - blockTrackRange + blockTrackRange * (this.ticksExisted % this.updateInterval) / (this.updateInterval / 2);
        int maxY = (int)Math.floor(player.field_70163_u) - blockTrackRange + blockTrackRange * (this.ticksExisted % this.updateInterval + 1) / (this.updateInterval / 2);
        baseY = MathHelper.func_76125_a((int)baseY, (int)0, (int)255);
        maxY = MathHelper.func_76125_a((int)maxY, (int)0, (int)255);
        int baseZ = (int)Math.floor(player.field_70161_v) - blockTrackRange;
        ChunkCache chunkCache = new ChunkCache(player.field_70170_p, new BlockPos(baseX, baseY, baseZ), new BlockPos(baseX + 2 * blockTrackRange, maxY, baseZ + 2 * blockTrackRange), 0);
        for (i = baseX; i <= baseX + 2 * blockTrackRange; ++i) {
            for (int j = baseY; j < maxY; ++j) {
                for (int k = baseZ; k <= baseZ + 2 * blockTrackRange; ++k) {
                    List<IBlockTrackEntry> entries;
                    TileEntity te;
                    BlockPos pos;
                    if (player.func_70011_f((double)i, (double)j, (double)k) > (double)blockTrackRange || MinecraftForge.EVENT_BUS.post((Event)new BlockTrackEvent(player.field_70170_p, pos = new BlockPos(i, j, k), te = chunkCache.func_175625_s(pos)))) continue;
                    if (searchHandler != null && te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                        searchHandler.checkInventoryForItems(te);
                    }
                    if ((entries = BlockTrackEntryList.instance.getEntriesForCoordinate((IBlockAccess)chunkCache, pos, te)).isEmpty()) continue;
                    boolean inList = false;
                    for (RenderBlockTarget blockTarget : this.blockTargets) {
                        if (!blockTarget.isSameTarget(player.field_70170_p, pos)) continue;
                        inList = true;
                        blockTarget.ticksExisted = Math.abs(blockTarget.ticksExisted);
                        blockTarget.setTileEntity(te);
                        break;
                    }
                    if (inList) continue;
                    boolean sentUpdate = false;
                    for (IBlockTrackEntry entry : entries) {
                        if (!entry.shouldBeUpdatedFromServer(te) || sentUpdate) continue;
                        NetworkHandler.sendToServer(new PacketDescriptionPacketRequest(pos));
                        sentUpdate = true;
                    }
                    this.addBlockTarget(new RenderBlockTarget(player.field_70170_p, player, pos, te, this));
                    for (IBlockTrackEntry entry : entries) {
                        if (this.countBlockTrackersOfType(entry) != entry.spamThreshold() + 1) continue;
                        HUDHandler.instance().addMessage(new ArmorMessage(I18n.func_135052_a((String)"blockTracker.message.stopSpam", (Object[])new Object[]{I18n.func_135052_a((String)entry.getEntryName(), (Object[])new Object[0])}), new ArrayList<String>(), 60, 0x7700AA00));
                    }
                }
            }
        }
        this.accTime += System.currentTimeMillis();
        for (i = 0; i < this.blockTargets.size(); ++i) {
            RenderBlockTarget blockTarget = this.blockTargets.get(i);
            boolean wasNegative = blockTarget.ticksExisted < 0;
            blockTarget.ticksExisted += CommonHUDHandler.getHandlerForPlayer(player).getSpeedFromUpgrades();
            if (blockTarget.ticksExisted >= 0 && wasNegative) {
                blockTarget.ticksExisted = -1;
            }
            blockTarget.update();
            if (!(blockTarget.getDistanceToEntity((Entity)player) > (double)(blockTrackRange + 5)) && blockTarget.isTargetStillValid()) continue;
            if (blockTarget.ticksExisted > 0) {
                blockTarget.ticksExisted = -60;
                continue;
            }
            if (blockTarget.ticksExisted != -1) continue;
            this.removeBlockTarget(i);
            --i;
        }
        ArrayList<String> textList = new ArrayList<String>();
        RenderBlockTarget focusedTarget = null;
        for (RenderBlockTarget blockTarget : this.blockTargets) {
            if (!blockTarget.isInitialized() || !blockTarget.isPlayerLooking()) continue;
            focusedTarget = blockTarget;
            break;
        }
        if (focusedTarget != null) {
            this.blockTrackInfo.setTitle(focusedTarget.stat.getTitle());
            textList.addAll(focusedTarget.textList);
        } else {
            this.blockTrackInfo.setTitle("Current tracked blocks:");
            if (this.blockTypeCount == null || this.ticksExisted % 40 == 0) {
                this.blockTypeCount = new int[BlockTrackEntryList.instance.trackList.size()];
                for (RenderBlockTarget target : this.blockTargets) {
                    for (IBlockTrackEntry validEntry : target.getApplicableEntries()) {
                        int n = BlockTrackEntryList.instance.trackList.indexOf((Object)validEntry);
                        this.blockTypeCount[n] = this.blockTypeCount[n] + 1;
                    }
                }
            }
            for (int i2 = 0; i2 < this.blockTypeCount.length; ++i2) {
                if (this.blockTypeCount[i2] <= 0) continue;
                textList.add(this.blockTypeCount[i2] + " " + I18n.func_135052_a((String)((IBlockTrackEntry)BlockTrackEntryList.instance.trackList.get(i2)).getEntryName(), (Object[])new Object[0]));
            }
            if (textList.size() == 0) {
                textList.add("Tracking no blocks currently.");
            }
        }
        this.blockTrackInfo.setText(textList);
    }

    private void addBlockTarget(RenderBlockTarget blockTarget) {
        this.blockTargets.add(blockTarget);
    }

    private void removeBlockTarget(int index) {
        this.blockTargets.remove(index);
    }

    public int countBlockTrackersOfType(IBlockTrackEntry type) {
        int typeIndex = BlockTrackEntryList.instance.trackList.indexOf((Object)type);
        if (this.blockTypeCount == null || typeIndex >= this.blockTypeCount.length) {
            return 0;
        }
        return this.blockTypeCount[typeIndex];
    }

    @Override
    public void render3D(float partialTicks) {
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        for (RenderBlockTarget blockTarget : this.blockTargets) {
            blockTarget.render(partialTicks);
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
    }

    @Override
    public void render2D(float partialTicks, boolean helmetEnabled) {
    }

    @Override
    public Item[] getRequiredUpgrades() {
        return new Item[]{Itemss.upgrades.get(IItemRegistry.EnumUpgrade.BLOCK_TRACKER)};
    }

    @Override
    public void reset() {
        this.blockTypeCount = null;
        this.ticksExisted = 0;
        this.blockTrackInfo = null;
    }

    @Override
    public float getEnergyUsage(int rangeUpgrades, EntityPlayer player) {
        return 1.0f * (1.0f + (float)Math.min(5, rangeUpgrades) * 5.0f / 30.0f) * (float)CommonHUDHandler.getHandlerForPlayer(player).getSpeedFromUpgrades();
    }

    @Override
    public IOptionPage getGuiOptionsPage() {
        return new GuiBlockTrackOptions(this);
    }

    @Override
    public EntityEquipmentSlot getEquipmentSlot() {
        return EntityEquipmentSlot.HEAD;
    }

    @Override
    public GuiAnimatedStat getAnimatedStat() {
        if (this.blockTrackInfo == null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            ScaledResolution sr = new ScaledResolution(minecraft);
            this.blockTrackInfo = new GuiAnimatedStat(null, "Current tracked blocks:", CraftingRegistrator.getUpgrade(IItemRegistry.EnumUpgrade.BLOCK_TRACKER), this.statX != -1 ? this.statX : sr.func_78326_a() - 2, this.statY, 0x3000AA00, null, this.statLeftSided);
            this.blockTrackInfo.setMinDimensionsAndReset(0, 0);
        }
        return this.blockTrackInfo;
    }

    public void hack() {
        for (RenderBlockTarget target : this.blockTargets) {
            target.hack();
        }
    }

    public RenderBlockTarget getTargetForCoord(BlockPos pos) {
        for (RenderBlockTarget target : this.blockTargets) {
            if (!target.isSameTarget(null, pos)) continue;
            return target;
        }
        return null;
    }

    public boolean scroll(MouseEvent event) {
        for (RenderBlockTarget target : this.blockTargets) {
            if (!target.scroll(event)) continue;
            this.getAnimatedStat().handleMouseWheel(event.getDwheel());
            return true;
        }
        return false;
    }
}

