/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumaticHelmet;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IOptionPage;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.gui.GuiUnitProgrammer;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.DroneDebugUpgradeHandler;
import me.desht.pneumaticcraft.common.NBTUtil;
import me.desht.pneumaticcraft.common.entity.living.DebugEntry;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetStart;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;

public class GuiDroneDebuggerOptions
extends Gui
implements IOptionPage {
    private final DroneDebugUpgradeHandler upgradeHandler;
    private EntityDrone selectedDrone;
    private GuiUnitProgrammer programmerUnit;
    private static final int PROGRAMMING_START_Y = 40;
    private int programmingStartX;
    private int programmingWidth;
    private int programmingHeight;
    private IProgWidget areaShowingWidget;
    private int screenWidth;
    private int screenHeight;

    public GuiDroneDebuggerOptions(DroneDebugUpgradeHandler upgradeHandler) {
        this.upgradeHandler = upgradeHandler;
    }

    @Override
    public String getPageName() {
        return "Drone Debugging";
    }

    @Override
    public void initGui(IGuiScreen gui) {
        int spacing;
        ItemStack helmet;
        GuiScreen guiScreen = (GuiScreen)gui;
        this.screenWidth = guiScreen.field_146294_l;
        this.screenHeight = guiScreen.field_146295_m;
        if (PneumaticCraftRepressurized.proxy.getClientPlayer() != null && (helmet = PneumaticCraftRepressurized.proxy.getClientPlayer().func_184582_a(EntityEquipmentSlot.HEAD)) != null) {
            int entityId = NBTUtil.getInteger(helmet, "debuggingDrone");
            Entity entity = PneumaticCraftRepressurized.proxy.getClientWorld().func_73045_a(entityId);
            if (entity instanceof EntityDrone) {
                this.selectedDrone = (EntityDrone)entity;
            }
        }
        this.programmingStartX = spacing = 20;
        this.programmingWidth = guiScreen.field_146294_l - spacing * 2;
        this.programmingHeight = guiScreen.field_146295_m - spacing - 40;
        this.programmerUnit = new DebugInfoProgrammerUnit(this.selectedDrone != null ? this.selectedDrone.getProgWidgets() : new ArrayList(), gui.getFontRenderer(), 0, 0, guiScreen.field_146294_l, guiScreen.field_146295_m, 100, this.programmingStartX, 40, this.programmingWidth, this.programmingHeight, 0, 0, 0);
        if (this.selectedDrone != null) {
            for (IProgWidget widget : this.selectedDrone.getProgWidgets()) {
                if (!(widget instanceof ProgWidgetStart)) continue;
                this.programmerUnit.gotoPiece(widget);
                break;
            }
        }
    }

    @Override
    public void actionPerformed(GuiButton button) {
    }

    @Override
    public void drawPreButtons(int x, int y, float partialTicks) {
        GuiDroneDebuggerOptions.func_73734_a((int)this.programmingStartX, (int)40, (int)(this.programmingStartX + this.programmingWidth), (int)(40 + this.programmingHeight), (int)0x55000000);
    }

    @Override
    public void drawScreen(int x, int y, float partialTicks) {
        IProgWidget widget;
        if (this.selectedDrone != null) {
            Minecraft.func_71410_x().field_71466_p.func_175065_a("Drone name: " + this.selectedDrone.func_70005_c_(), 20.0f, (float)(this.screenHeight - 15), -1, true);
            Minecraft.func_71410_x().field_71466_p.func_175065_a("Routine: " + this.selectedDrone.getLabel(), (float)(this.screenWidth / 2), (float)(this.screenHeight - 15), -1, true);
        }
        this.programmerUnit.render(x, y, true, true, true);
        this.programmerUnit.renderForeground(x, y, null);
        if (this.selectedDrone == null) {
            this.func_73732_a(Minecraft.func_71410_x().field_71466_p, "Press '" + Keyboard.getKeyName((int)KeyHandler.getInstance().keybindDebuggingDrone.func_151463_i()) + "' on a Drone when tracked by an Entity Tracker to debug the Drone.", this.screenWidth / 2, this.screenHeight / 2, -65536);
        }
        if ((widget = this.programmerUnit.getHoveredWidget(x, y)) == null) {
            widget = this.areaShowingWidget;
        }
        this.upgradeHandler.getShowingPositions().clear();
        if (widget != null) {
            int widgetId = this.selectedDrone.getProgWidgets().indexOf(widget);
            for (DebugEntry entry : this.selectedDrone.getDebugEntries()) {
                if (entry.getProgWidgetId() != widgetId || entry.getPos().equals((Object)new BlockPos(0, 0, 0))) continue;
                this.upgradeHandler.getShowingPositions().add(entry.getPos());
            }
        }
    }

    @Override
    public void keyTyped(char ch, int key) {
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        if (button == 0) {
            this.areaShowingWidget = this.programmerUnit.getHoveredWidget(x, y);
        }
    }

    @Override
    public void handleMouseInput() {
        this.programmerUnit.getScrollBar().handleMouseInput();
    }

    @Override
    public boolean canBeTurnedOff() {
        return false;
    }

    @Override
    public boolean displaySettingsText() {
        return false;
    }

    private class DebugInfoProgrammerUnit
    extends GuiUnitProgrammer {
        public DebugInfoProgrammerUnit(List<IProgWidget> progWidgets, FontRenderer fontRenderer, int guiLeft, int guiTop, int width, int height, int xSize, int startX, int startY, int areaWidth, int areaHeight, int translatedX, int translatedY, int lastZoom) {
            super(progWidgets, fontRenderer, guiLeft, guiTop, width, height, xSize, startX, startY, areaWidth, areaHeight, translatedX, translatedY, lastZoom);
        }

        @Override
        protected void addAdditionalInfoToTooltip(IProgWidget widget, List<String> tooltip) {
            int widgetId = GuiDroneDebuggerOptions.this.selectedDrone.getProgWidgets().indexOf(widget);
            LinkedHashMap<String, Integer> messageTimesMap = new LinkedHashMap<String, Integer>();
            boolean hasCoords = false;
            for (DebugEntry debugEntry : GuiDroneDebuggerOptions.this.selectedDrone.getDebugEntries()) {
                if (debugEntry.getProgWidgetId() != widgetId) continue;
                Integer oldTimes = (Integer)messageTimesMap.get(debugEntry.getMessage());
                if (oldTimes == null) {
                    oldTimes = 0;
                }
                messageTimesMap.put(debugEntry.getMessage(), oldTimes + 1);
                if (debugEntry.getPos().equals((Object)new BlockPos(0, 0, 0))) continue;
                hasCoords = true;
            }
            for (Map.Entry entry : messageTimesMap.entrySet()) {
                tooltip.add(entry.getValue() + "x " + I18n.func_135052_a((String)((String)entry.getKey()), (Object[])new Object[0]));
            }
            if (hasCoords) {
                tooltip.add(TextFormatting.GREEN + I18n.func_135052_a((String)"gui.progWidget.debug.hasPositions", (Object[])new Object[0]));
                if (widget != GuiDroneDebuggerOptions.this.areaShowingWidget) {
                    tooltip.add(TextFormatting.GREEN + I18n.func_135052_a((String)"gui.progWidget.debug.clickToShow", (Object[])new Object[0]));
                }
            }
        }

        @Override
        protected void renderAdditionally() {
            IProgWidget widget;
            IProgWidget iProgWidget = widget = GuiDroneDebuggerOptions.this.selectedDrone != null ? GuiDroneDebuggerOptions.this.selectedDrone.getActiveWidget() : null;
            if (widget != null) {
                this.drawBorder(widget, -16711936);
            }
        }
    }
}

