/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.item.IPressurizable;
import me.desht.pneumaticcraft.api.item.IUpgradeAcceptor;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticInventoryItem;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.UpgradeRenderHandlerList;
import me.desht.pneumaticcraft.common.CommonHUDHandler;
import me.desht.pneumaticcraft.common.inventory.ContainerChargingStationItemInventory;
import me.desht.pneumaticcraft.common.item.ItemMachineUpgrade;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.recipes.CraftingRegistrator;
import me.desht.pneumaticcraft.common.tileentity.TileEntityChargingStation;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.FMLClientHandler;

public class GuiPneumaticArmor
extends GuiPneumaticInventoryItem {
    private final String registryName;
    private GuiAnimatedStat statusStat;
    private final EntityEquipmentSlot equipmentSlot;

    public GuiPneumaticArmor(ContainerChargingStationItemInventory container, TileEntityChargingStation te) {
        super(container, te);
        this.registryName = this.itemStack.func_77973_b().getRegistryName().func_110623_a();
        this.equipmentSlot = ((ItemArmor)this.itemStack.func_77973_b()).field_77881_a;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addAnimatedStat("gui.tab.info", "pneumaticcraft:textures/gui/gui_info.png", -7829249, true).setText("gui.tab.info.item." + this.registryName);
        this.statusStat = this.addAnimatedStat("Status", this.itemStack, -22016, false);
        Set<Item> upgrades = ((IUpgradeAcceptor)this.itemStack.func_77973_b()).getApplicableUpgrades();
        List upgrades1 = upgrades.stream().sorted(Comparator.comparing(Item::func_77658_a)).collect(Collectors.toList());
        for (int i = 0; i < upgrades1.size(); ++i) {
            Item upgrade = (Item)upgrades1.get(i);
            if (!(upgrade instanceof ItemMachineUpgrade)) continue;
            this.addUpgradeStat(((ItemMachineUpgrade)upgrade).getUpgradeType(), i <= upgrades1.size() / 2);
        }
    }

    private void addUpgradeStat(IItemRegistry.EnumUpgrade upgrade, boolean leftSided) {
        ItemStack stack = CraftingRegistrator.getUpgrade(upgrade);
        String key = this.getTranslationKey(upgrade, this.equipmentSlot);
        if (!I18n.func_188566_a((String)key)) {
            key = this.getTranslationKey(upgrade, null);
        }
        this.addAnimatedStat(stack.func_82833_r(), stack, -12566273, leftSided).setText(key);
    }

    private String getTranslationKey(IItemRegistry.EnumUpgrade upgrade, EntityEquipmentSlot equipmentSlot) {
        String s = equipmentSlot == null ? "generic" : equipmentSlot.toString().toLowerCase();
        return "gui.tab.info.item.armor." + s + "." + upgrade.getName() + "Upgrade";
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        CommonHUDHandler.getHandlerForPlayer().checkArmorInventory((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.equipmentSlot);
        this.statusStat.setText(this.getStatusText());
    }

    private List<String> getStatusText() {
        ArrayList<String> text = new ArrayList<String>();
        text.add("\u00a77Air Usage:");
        float totalUsage = UpgradeRenderHandlerList.instance().getAirUsage((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g, this.equipmentSlot, true);
        if (totalUsage > 0.0f) {
            EntityPlayerSP player = FMLClientHandler.instance().getClient().field_71439_g;
            List<IUpgradeRenderHandler> renderHandlers = UpgradeRenderHandlerList.instance().getHandlersForSlot(this.equipmentSlot);
            for (int i = 0; i < renderHandlers.size(); ++i) {
                IUpgradeRenderHandler handler;
                float upgradeUsage;
                if (!CommonHUDHandler.getHandlerForPlayer((EntityPlayer)player).isUpgradeRendererInserted(this.equipmentSlot, i) || !((upgradeUsage = (handler = renderHandlers.get(i)).getEnergyUsage(CommonHUDHandler.getHandlerForPlayer((EntityPlayer)player).getUpgradeCount(this.equipmentSlot, IItemRegistry.EnumUpgrade.RANGE), (EntityPlayer)player)) > 0.0f)) continue;
                text.add(TextFormatting.BLACK.toString() + PneumaticCraftUtils.roundNumberTo(upgradeUsage, 1) + " mL/tick (" + handler.getUpgradeName() + ")");
            }
            text.add("\u00a70--------+");
            text.add("\u00a70" + PneumaticCraftUtils.roundNumberTo(totalUsage, 1) + " mL/tick");
        } else {
            text.add(TextFormatting.BLACK + "0.0 mL/tick");
        }
        text.add("\u00a77Estimated time remaining:");
        int volume = UpgradableItemUtils.getUpgrades(IItemRegistry.EnumUpgrade.VOLUME, this.itemStack) * 5000 + this.getDefaultVolume();
        int airLeft = (int)(((IPressurizable)this.itemStack.func_77973_b()).getPressure(this.itemStack) * (float)volume);
        if (totalUsage == 0.0f) {
            if (airLeft > 0) {
                text.add("\u00a70infinite");
            } else {
                text.add("\u00a700s");
            }
        } else {
            text.add("\u00a70" + PneumaticCraftUtils.convertTicksToMinutesAndSeconds((int)((float)airLeft / totalUsage), false));
        }
        return text;
    }

    @Override
    protected int getDefaultVolume() {
        return ((ItemPneumaticArmor)this.itemStack.func_77973_b()).getBaseVolume();
    }
}

