/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.HashSet;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.common.TickHandlerPneumaticCraft;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.inventory.Container4UpgradeSlots;
import me.desht.pneumaticcraft.common.tileentity.TileEntityElectrostaticCompressor;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiElectrostaticCompressor
extends GuiPneumaticContainerBase<TileEntityElectrostaticCompressor> {
    private int connectedCompressors = 1;
    private int ticksExisted;

    public GuiElectrostaticCompressor(InventoryPlayer player, TileEntityElectrostaticCompressor te) {
        super(new Container4UpgradeSlots<TileEntityElectrostaticCompressor>(player, te), te, "pneumaticcraft:textures/gui/gui_pressure_chamber.png");
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.field_146289_q.func_78276_b("Upgr.", 53, 19, 0x404040);
    }

    @Override
    protected void addPressureStatInfo(List<String> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        pressureStatText.add(TextFormatting.GRAY + "Energy production:");
        pressureStatText.add(TextFormatting.BLACK + PneumaticCraftUtils.roundNumberTo(200000 / this.connectedCompressors, 1) + " mL/lightning strike");
        pressureStatText.add(TextFormatting.GRAY + "Maximum air redirection:");
        pressureStatText.add(TextFormatting.BLACK + PneumaticCraftUtils.roundNumberTo(10000 * ((TileEntityElectrostaticCompressor)this.te).ironBarsBeneath, 1) + " mL/lightning strike");
    }

    @Override
    protected void addProblems(List<String> textList) {
        super.addProblems(textList);
        if (10000 * ((TileEntityElectrostaticCompressor)this.te).ironBarsBeneath < 200000 / this.connectedCompressors) {
            textList.add(TextFormatting.GRAY + "When lightning strikes with a full air tank not all the energy can be redirected!");
            textList.add(TextFormatting.BLACK + "Connect up more Iron Bars to the underside of the Electrostatic Compressor.");
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.ticksExisted % 20 == 0) {
            HashSet<BlockPos> positions = new HashSet<BlockPos>();
            positions.add(((TileEntityElectrostaticCompressor)this.te).func_174877_v());
            TickHandlerPneumaticCraft.getElectrostaticGrid(positions, ((TileEntityElectrostaticCompressor)this.te).func_145831_w(), ((TileEntityElectrostaticCompressor)this.te).func_174877_v());
            this.connectedCompressors = 0;
            for (BlockPos coord : positions) {
                if (((TileEntityElectrostaticCompressor)this.te).func_145831_w().func_180495_p(coord).func_177230_c() != Blockss.ELECTROSTATIC_COMPRESSOR) continue;
                ++this.connectedCompressors;
            }
        }
        ++this.ticksExisted;
    }
}

