/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.item;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakery.CCBakeryModel;
import codechicken.lib.model.bakery.IBakeryProvider;
import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.model.bakery.generation.IBakery;
import cofh.core.init.CoreProps;
import cofh.core.item.ItemMulti;
import cofh.core.render.IModelRegister;
import cofh.core.util.ConfigHandler;
import cofh.core.util.CoreUtils;
import cofh.core.util.DefaultedHashMap;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.entity.projectile.EntityFlorb;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.render.item.ModelFlorb;
import cofh.thermalexpansion.util.BehaviorFlorbDispense;
import cofh.thermalexpansion.util.managers.machine.TransposerManager;
import cofh.thermalfoundation.init.TFProps;
import cofh.thermalfoundation.item.ItemMaterial;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFlorb
extends ItemMulti
implements IInitializer,
IBakeryProvider {
    public static final ConfigHandler CONFIG_FLORBS = new ConfigHandler("5.5.0");
    public static ArrayList<ItemStack> florbList = new ArrayList();
    public static Map<String, ItemStack> florbMap = new DefaultedHashMap((Object)ItemStack.field_190927_a);
    public static String[] blacklist = new String[0];
    public static boolean enable = true;
    public static ItemStack florbStandard;
    public static ItemStack florbMagmatic;

    public static ItemStack setTag(ItemStack container, Fluid fluid) {
        if (fluid != null && fluid.canBePlacedInWorld()) {
            container.func_77982_d(new NBTTagCompound());
            container.func_77978_p().func_74778_a("Fluid", fluid.getName());
        }
        return container;
    }

    public ItemFlorb() {
        super("thermalexpansion");
        this.func_77655_b("florb");
        this.func_77637_a(ThermalExpansion.tabFlorbs);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        Fluid fluid;
        if (stack.func_77978_p() != null && ((fluid = FluidRegistry.getFluid((String)stack.func_77978_p().func_74779_i("Fluid"))) == null || fluid.getDensity() >= 0)) {
            return;
        }
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (stack.func_77978_p() == null) {
            if (ItemHelper.getItemDamage((ItemStack)stack) == 0) {
                tooltip.add(StringHelper.localize((String)"info.thermalexpansion.florb.a.0"));
            } else {
                tooltip.add(StringHelper.localize((String)"info.thermalexpansion.florb.b.0"));
            }
            tooltip.add(StringHelper.localize((String)"info.thermalexpansion.florb.c.0"));
            tooltip.add(StringHelper.localize((String)"info.thermalexpansion.florb.c.1"));
        } else {
            tooltip.add(StringHelper.localize((String)"info.thermalexpansion.florb.d.0"));
            tooltip.add(StringHelper.localize((String)"info.thermalexpansion.florb.d.1"));
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (TEProps.creativeTabHideFlorbs) {
            return;
        }
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this, 1, 0));
            items.add((Object)new ItemStack((Item)this, 1, 1));
            items.addAll(florbList);
        }
    }

    public String func_77653_i(ItemStack stack) {
        Fluid fluid;
        String fluidName = "info.cofh.empty";
        String openParen = " (";
        String closeParen = "\u00a7r)";
        if (stack.func_77978_p() != null && (fluid = FluidRegistry.getFluid((String)stack.func_77978_p().func_74779_i("Fluid"))) != null) {
            fluidName = fluid.getUnlocalizedName();
            if (fluid.getRarity() == EnumRarity.UNCOMMON) {
                openParen = openParen + "\u00a7e";
            } else if (fluid.getRarity() == EnumRarity.RARE) {
                openParen = openParen + "\u00a7b";
            } else if (fluid.getRarity() == EnumRarity.EPIC) {
                openParen = openParen + "\u00a7d";
            }
        }
        return super.func_77653_i(stack) + openParen + StringHelper.localize((String)fluidName) + closeParen;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_77942_o()) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        Fluid fluid = FluidRegistry.getFluid((String)stack.func_77978_p().func_74779_i("Fluid"));
        if (fluid == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        stack.func_190918_g(1);
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (ServerHelper.isServerWorld((World)world)) {
            EntityFlorb florb = new EntityFlorb(world, (EntityLivingBase)player, fluid);
            florb.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
            world.func_72838_d((Entity)florb);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public static void addFlorb(ItemStack florb, Fluid fluid) {
        ItemFlorb.setTag(florb, fluid);
        florbList.add(florb);
        florbMap.put(fluid.getName(), florb);
    }

    public static void dropFlorb(Fluid fluid, World world, BlockPos pos) {
        CoreUtils.dropItemStackIntoWorldWithVelocity((ItemStack)ItemFlorb.getFlorb(fluid), (World)world, (BlockPos)pos);
    }

    @Nonnull
    public static ItemStack getFlorb(Fluid fluid) {
        if (!florbMap.containsKey(fluid.getName())) {
            return florbStandard.func_77946_l();
        }
        return florbMap.get(fluid.getName());
    }

    public static void parseFlorbs() {
        List<String> list = Arrays.asList(blacklist);
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            if (!fluid.canBePlacedInWorld() || list.contains(fluid.getName())) continue;
            if (fluid.getTemperature() < 1000) {
                ItemFlorb.addFlorb(ItemHelper.cloneStack((ItemStack)florbStandard), fluid);
                TransposerManager.addFillRecipe(1600, florbStandard, florbList.get(florbList.size() - 1), new FluidStack(fluid, 1000), false);
                continue;
            }
            ItemFlorb.addFlorb(ItemHelper.cloneStack((ItemStack)florbMagmatic), fluid);
            TransposerManager.addFillRecipe(1600, florbMagmatic, florbList.get(florbList.size() - 1), new FluidStack(fluid, 1000), false);
        }
        if (TFProps.useUnifiedTabs) {
            TFProps.miscList.addAll(florbList);
        }
        CONFIG_FLORBS.cleanUp(false, true);
    }

    @SideOnly(value=Side.CLIENT)
    public IBakery getBakery() {
        return ModelFlorb.INSTANCE;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelResourceLocation location = new ModelResourceLocation("thermalexpansion:florb", "type=florb");
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> location);
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)location);
        ModelRegistryHelper.register((ModelResourceLocation)location, (IBakedModel)new CCBakeryModel());
        ModelBakery.registerItemKeyGenerator((Item)this, stack -> {
            String fluid = "";
            if (stack.func_77978_p() != null) {
                fluid = "," + stack.func_77978_p().func_74779_i("Fluid");
            }
            return ModelBakery.defaultItemKeyGenerator.generateKey(stack) + fluid;
        });
    }

    public boolean preInit() {
        ForgeRegistries.ITEMS.register(this.setRegistryName("florb"));
        ThermalExpansion.proxy.addIModelRegister((IModelRegister)this);
        ItemFlorb.config();
        florbStandard = this.addItem(0, "standard");
        florbMagmatic = this.addItem(1, "magmatic");
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new BehaviorFlorbDispense());
        return true;
    }

    public boolean initialize() {
        if (!enable) {
            return false;
        }
        ItemStack florbStack = ItemHelper.cloneStack((ItemStack)florbStandard, (int)4);
        ItemStack florbMagmaticStack = ItemHelper.cloneStack((ItemStack)florbMagmatic, (int)4);
        RecipeHelper.addShapelessRecipe((ItemStack)florbStack, (Object[])new Object[]{"dustWood", "crystalSlag", "slimeball"});
        RecipeHelper.addShapelessRecipe((ItemStack)florbMagmaticStack, (Object[])new Object[]{"dustWood", "crystalSlag", "slimeball", Items.field_151065_br});
        RecipeHelper.addShapelessRecipe((ItemStack)florbMagmaticStack, (Object[])new Object[]{"dustWood", "crystalSlag", Items.field_151064_bs});
        RecipeHelper.addShapelessRecipe((ItemStack)florbStack, (Object[])new Object[]{"dustWood", "crystalSlag", ItemMaterial.globRosin});
        RecipeHelper.addShapelessRecipe((ItemStack)florbMagmaticStack, (Object[])new Object[]{"dustWood", "crystalSlag", ItemMaterial.globRosin, Items.field_151065_br});
        return true;
    }

    private static void config() {
        CONFIG_FLORBS.setConfiguration(new Configuration(new File(CoreProps.configDir, "cofh/thermalexpansion/florbs.cfg"), true));
        String category = "General";
        String comment = "If TRUE, the recipes for Florbs are enabled. Setting this to FALSE means that you actively dislike fun things.";
        enable = CONFIG_FLORBS.getConfiguration().getBoolean("EnableRecipe", category, enable, comment);
        category = "Blacklist";
        comment = "List of fluids that are not allowed to be placed in Florbs.";
        blacklist = CONFIG_FLORBS.getConfiguration().getStringList("Blacklist", category, blacklist, comment);
    }
}

