/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.api.block.IVariableContainer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkEventListener;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.event.INetworkEvent;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.capability.variablecontainer.VariableContainerConfig;
import org.cyclops.integrateddynamics.capability.variablecontainer.VariableContainerDefault;
import org.cyclops.integrateddynamics.capability.variablefacade.VariableFacadeHolderConfig;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.core.tileentity.TileCableConnectableInventory;
import org.cyclops.integrateddynamics.item.ItemVariable;
import org.cyclops.integrateddynamics.network.VariablestoreNetworkElement;

public class TileVariablestore
extends TileCableConnectableInventory
implements IDirtyMarkListener,
INetworkEventListener<VariablestoreNetworkElement> {
    public static final int ROWS = 5;
    public static final int COLS = 9;
    private final IVariableContainer variableContainer;
    private boolean shouldSendUpdateEvent = false;

    public TileVariablestore() {
        super(45, "variables", 1);
        this.inventory.addDirtyMarkListener((IDirtyMarkListener)this);
        ArrayList slots = Lists.newArrayListWithCapacity((int)this.getInventory().func_70302_i_());
        for (int i = 0; i < this.getInventory().func_70302_i_(); ++i) {
            slots.add(i);
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.addSlotsToSide(side, slots);
        }
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, new NetworkElementProviderSingleton(){

            @Override
            public INetworkElement createNetworkElement(World world, BlockPos blockPos) {
                return new VariablestoreNetworkElement(DimPos.of((World)world, (BlockPos)blockPos));
            }
        });
        this.variableContainer = new VariableContainerDefault();
        this.addCapabilityInternal(VariableContainerConfig.CAPABILITY, this.variableContainer);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return super.func_94041_b(index, stack) && (stack.func_190926_b() || stack.hasCapability(VariableFacadeHolderConfig.CAPABILITY, null));
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.shouldSendUpdateEvent = true;
    }

    protected void refreshVariables(IInventory inventory, boolean sendVariablesUpdateEvent) {
        INetwork network;
        IPartNetwork partNetwork = NetworkHelpers.getPartNetwork(this.getNetwork());
        if (partNetwork != null) {
            for (IVariableFacade variableFacade : this.variableContainer.getVariableCache().values()) {
                IVariable variable = variableFacade.getVariable(partNetwork);
                if (variable == null || !variable.canInvalidate()) continue;
                variable.invalidate();
            }
        }
        this.variableContainer.getVariableCache().clear();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            IVariableFacade variableFacade;
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack.func_190926_b() || (variableFacade = ItemVariable.getInstance().getVariableFacade(itemStack)) == null || !variableFacade.isValid()) continue;
            this.variableContainer.getVariableCache().put(variableFacade.getId(), variableFacade);
        }
        if (sendVariablesUpdateEvent && (network = this.getNetwork()) != null) {
            network.getEventBus().post(new VariableContentsUpdatedEvent(network));
        }
    }

    public void onDirty() {
        if (!this.field_145850_b.field_72995_K) {
            this.refreshVariables((IInventory)this.inventory, true);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (!MinecraftHelpers.isClientSide()) {
            this.shouldSendUpdateEvent = true;
        }
    }

    @Override
    protected void updateTileEntity() {
        super.updateTileEntity();
        if (this.shouldSendUpdateEvent && this.getNetwork() != null) {
            this.shouldSendUpdateEvent = false;
            this.refreshVariables((IInventory)this.inventory, true);
        }
    }

    @Override
    public boolean hasEventSubscriptions() {
        return true;
    }

    @Override
    public Set<Class<? extends INetworkEvent>> getSubscribedEvents() {
        return Sets.newHashSet((Object[])new Class[]{VariableContentsUpdatedEvent.class});
    }

    @Override
    public void onEvent(INetworkEvent event, VariablestoreNetworkElement networkElement) {
        if (event instanceof VariableContentsUpdatedEvent) {
            this.refreshVariables((IInventory)this.inventory, false);
        }
    }
}

