/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.compiler;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import stanhebben.zenscript.IZenCompileEnvironment;
import stanhebben.zenscript.TypeExpansion;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.util.ZenPosition;

public class EnvironmentScript
implements IEnvironmentGlobal {
    private final IEnvironmentGlobal parent;
    private final Map<String, IZenSymbol> imports;

    public EnvironmentScript(IEnvironmentGlobal parent) {
        this.parent = parent;
        this.imports = new HashMap<String, IZenSymbol>();
    }

    @Override
    public IZenCompileEnvironment getEnvironment() {
        return this.parent.getEnvironment();
    }

    @Override
    public TypeExpansion getExpansion(String name) {
        return this.parent.getExpansion(name);
    }

    @Override
    public String makeClassName() {
        return this.parent.makeClassName();
    }

    @Override
    public boolean containsClass(String name) {
        return this.parent.containsClass(name);
    }

    @Override
    public void putClass(String name, byte[] data) {
        this.parent.putClass(name, data);
    }

    @Override
    public IPartialExpression getValue(String name, ZenPosition position) {
        if (this.imports.containsKey(name)) {
            IZenSymbol imprt = this.imports.get(name);
            if (imprt == null) {
                throw new RuntimeException("How could this happen?");
            }
            return imprt.instance(position);
        }
        return this.parent.getValue(name, position);
    }

    @Override
    public void putValue(String name, IZenSymbol value, ZenPosition position) {
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        if (this.imports.containsKey(name)) {
            this.error(position, "Value already defined in this scope: " + name);
        } else {
            this.imports.put(name, value);
        }
    }

    @Override
    public ZenType getType(Type type) {
        return this.parent.getType(type);
    }

    @Override
    public void error(ZenPosition position, String message) {
        this.parent.error(position, message);
    }

    @Override
    public void warning(ZenPosition position, String message) {
        this.parent.warning(position, message);
    }

    @Override
    public void info(ZenPosition position, String message) {
        this.parent.info(position, message);
    }

    @Override
    public Set<String> getClassNames() {
        return this.parent.getClassNames();
    }

    @Override
    public byte[] getClass(String name) {
        return this.parent.getClass(name);
    }

    @Override
    public void error(String message) {
        this.parent.error(message);
    }

    @Override
    public void error(String message, Throwable e) {
        this.parent.error(message, e);
    }

    @Override
    public void warning(String message) {
        this.parent.warning(message);
    }

    @Override
    public void info(String message) {
        this.parent.info(message);
    }

    public IEnvironmentGlobal getParent() {
        return this.parent;
    }
}

