/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.runtime;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.network.NetworkSide;
import crafttweaker.preprocessor.CrTScriptLoadEvent;
import crafttweaker.preprocessor.PreprocessorManager;
import crafttweaker.runtime.IScriptIterator;
import crafttweaker.runtime.IScriptProvider;
import crafttweaker.runtime.ITweaker;
import crafttweaker.runtime.ScriptFile;
import crafttweaker.runtime.events.CrTLoadingScriptEventPost;
import crafttweaker.runtime.events.CrTLoadingScriptEventPre;
import crafttweaker.runtime.events.CrTLoadingStartedEvent;
import crafttweaker.socket.SingleError;
import crafttweaker.util.EventList;
import crafttweaker.util.IEventHandler;
import crafttweaker.zenscript.CrTGlobalEnvironment;
import crafttweaker.zenscript.CrtStoringErrorLogger;
import crafttweaker.zenscript.GlobalRegistry;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import stanhebben.zenscript.ZenModule;
import stanhebben.zenscript.ZenParsedFile;
import stanhebben.zenscript.ZenTokener;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.parser.ParseException;
import stanhebben.zenscript.parser.TokenStream;

public class CrTTweaker
implements ITweaker {
    private static String defaultLoaderName = "crafttweaker";
    private static boolean DEBUG = false;
    private final List<IAction> actions = new ArrayList<IAction>();
    private final EventList<CrTLoadingStartedEvent> CRT_LOADING_STARTED_EVENT_EVENT_LIST = new EventList();
    private final EventList<CrTLoadingScriptEventPre> CRT_LOADING_SCRIPT_PRE_EVENT_LIST = new EventList();
    private final EventList<CrTLoadingScriptEventPost> CRT_LOADING_SCRIPT_POST_EVENT_LIST = new EventList();
    private NetworkSide networkSide = NetworkSide.INVALID_SIDE;
    private PreprocessorManager preprocessorManager = new PreprocessorManager();
    private IScriptProvider scriptProvider;

    public CrTTweaker() {
        PreprocessorManager.registerOwnPreprocessors(this.preprocessorManager);
    }

    @Override
    public void apply(IAction action) {
        String describe = action.describe();
        if (describe != null && !describe.isEmpty()) {
            CraftTweakerAPI.logInfo(describe);
        }
        action.apply();
        this.actions.add(action);
    }

    @Override
    public void setScriptProvider(IScriptProvider provider) {
        this.scriptProvider = provider;
    }

    @Override
    public void load() {
        this.loadScript(false, defaultLoaderName);
    }

    @Override
    public boolean loadScript(boolean isSyntaxCommand, String loaderName) {
        return this.loadScript(isSyntaxCommand, loaderName, null, false);
    }

    private List<ScriptFile> loadPreprocessor(boolean isSyntaxCommand) {
        List<ScriptFile> scriptFiles = this.collectScriptFiles(isSyntaxCommand);
        for (ScriptFile scriptFile : scriptFiles) {
            scriptFile.addAll(this.preprocessorManager.checkFileForPreprocessors(scriptFile));
        }
        scriptFiles.sort(PreprocessorManager.SCRIPT_FILE_COMPARATOR);
        return scriptFiles;
    }

    public boolean loadScript(boolean isSyntaxCommand, String loaderName, List<SingleError> parseExceptions, boolean isLinter) {
        CraftTweakerAPI.logInfo("Loading scripts");
        if (!isLinter) {
            this.CRT_LOADING_STARTED_EVENT_EVENT_LIST.publish(new CrTLoadingStartedEvent(loaderName, isSyntaxCommand, this.networkSide));
        }
        this.preprocessorManager.clean();
        HashSet<String> executed = new HashSet<String>();
        boolean loadSuccessful = true;
        List<ScriptFile> scriptFiles = this.loadPreprocessor(isSyntaxCommand);
        ((CrtStoringErrorLogger)GlobalRegistry.getErrors()).clear();
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        IEnvironmentGlobal environmentGlobal = GlobalRegistry.makeGlobalEnvironment(classes);
        long totalTime = System.currentTimeMillis();
        for (ScriptFile scriptFile : scriptFiles) {
            if (!scriptFile.getLoaderName().equals(loaderName) && !isSyntaxCommand) {
                CraftTweakerAPI.logInfo(this.getTweakerDescriptor(loaderName) + ": Skipping file " + scriptFile + " as we are currently loading with a different loader");
                continue;
            }
            if (!scriptFile.shouldBeLoadedOn(this.networkSide)) {
                CraftTweakerAPI.logInfo(this.getTweakerDescriptor(loaderName) + ": Skipping file " + scriptFile + " as we are on the wrong side of the Network");
                continue;
            }
            if (executed.contains(scriptFile.getEffectiveName())) continue;
            executed.add(scriptFile.getEffectiveName());
            CraftTweakerAPI.logInfo(this.getTweakerDescriptor(loaderName) + ": Loading Script: " + scriptFile);
            ZenParsedFile zenParsedFile = null;
            String filename = scriptFile.getEffectiveName();
            String className = ZenModule.extractClassName(filename);
            if (!isLinter) {
                this.CRT_LOADING_SCRIPT_PRE_EVENT_LIST.publish(new CrTLoadingScriptEventPre(filename));
            }
            TokenStream parser = null;
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(scriptFile.open()), "UTF-8");
                Throwable throwable = null;
                try {
                    this.preprocessorManager.postLoadEvent(new CrTScriptLoadEvent(scriptFile));
                    if (scriptFile.isParsingBlocked()) continue;
                    parser = new ZenTokener(reader, environmentGlobal.getEnvironment(), filename, scriptFile.areBracketErrorsIgnored());
                    zenParsedFile = new ZenParsedFile(filename, className, (ZenTokener)parser, environmentGlobal);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                    continue;
                }
            }
            catch (IOException ex) {
                CraftTweakerAPI.logError(this.getTweakerDescriptor(loaderName) + ": Could not load script " + scriptFile + ": " + ex.getMessage());
                loadSuccessful = false;
            }
            catch (ParseException ex) {
                CraftTweakerAPI.logError(this.getTweakerDescriptor(loaderName) + ": Error parsing " + ex.getFile().getFileName() + ":" + ex.getLine() + " -- " + ex.getExplanation());
                loadSuccessful = false;
                if (parseExceptions != null) {
                    parseExceptions.add(new SingleError(ex.getFile().getFileName(), ex.getLine(), ex.getLineOffset(), ex.getExplanation(), SingleError.Level.ERROR));
                }
            }
            catch (Exception ex) {
                CraftTweakerAPI.logError(this.getTweakerDescriptor(loaderName) + ": Error loading " + scriptFile + ": " + ex.toString(), ex);
                if (parser != null && parseExceptions != null) {
                    parseExceptions.add(new SingleError(parser.getFile().getFileName(), parser.getLine(), parser.getLineOffset(), "Generic ERROR", SingleError.Level.ERROR));
                }
                loadSuccessful = false;
            }
            try {
                if (zenParsedFile == null || scriptFile.isCompileBlocked() || !loadSuccessful) continue;
                ZenModule.compileScripts(className, Collections.singletonList(zenParsedFile), environmentGlobal, scriptFile.isDebugEnabled() || DEBUG);
                if (scriptFile.isExecutionBlocked() || isSyntaxCommand || isLinter) continue;
                ZenModule module = new ZenModule(classes, CraftTweakerAPI.class.getClassLoader());
                Runnable runnable = module.getMain();
                if (runnable != null) {
                    runnable.run();
                }
            }
            catch (Throwable ex) {
                CraftTweakerAPI.logError("[" + loaderName + "]: Error executing " + scriptFile + ": " + ex.getMessage(), ex);
            }
            this.CRT_LOADING_SCRIPT_POST_EVENT_LIST.publish(new CrTLoadingScriptEventPost(filename));
        }
        if (parseExceptions != null) {
            CrtStoringErrorLogger logger = (CrtStoringErrorLogger)GlobalRegistry.getErrors();
            parseExceptions.addAll(logger.getErrors());
            CrTGlobalEnvironment global = (CrTGlobalEnvironment)environmentGlobal;
            parseExceptions.addAll(global.getErrors());
        }
        CraftTweakerAPI.logInfo("Completed script loading in: " + (System.currentTimeMillis() - totalTime) + "ms");
        return loadSuccessful;
    }

    protected List<ScriptFile> collectScriptFiles(boolean isSyntaxCommand) {
        ArrayList<ScriptFile> fileList = new ArrayList<ScriptFile>();
        HashSet<String> collected = new HashSet<String>();
        Iterator<IScriptIterator> scripts = this.scriptProvider.getScripts();
        while (scripts.hasNext()) {
            IScriptIterator script = scripts.next();
            if (collected.contains(script.getGroupName())) continue;
            collected.add(script.getGroupName());
            while (script.next()) {
                fileList.add(new ScriptFile(this, script.copyCurrent(), isSyntaxCommand));
            }
        }
        return fileList;
    }

    private String getTweakerDescriptor(String loaderName) {
        return "[" + loaderName + " | " + (Object)((Object)this.networkSide) + "]";
    }

    @Override
    public List<IAction> getActions() {
        return this.actions;
    }

    @Override
    public void enableDebug() {
        DEBUG = true;
    }

    @Override
    public PreprocessorManager getPreprocessorManager() {
        return this.preprocessorManager;
    }

    @Override
    public NetworkSide getNetworkSide() {
        return this.networkSide;
    }

    @Override
    public void setNetworkSide(NetworkSide networkSide) {
        this.networkSide = networkSide;
    }

    @Override
    public void registerLoadStartedEvent(IEventHandler<CrTLoadingStartedEvent> eventHandler) {
        this.CRT_LOADING_STARTED_EVENT_EVENT_LIST.add(eventHandler);
    }

    @Override
    public void registerScriptLoadPreEvent(IEventHandler<CrTLoadingScriptEventPre> eventHandler) {
        this.CRT_LOADING_SCRIPT_PRE_EVENT_LIST.add(eventHandler);
    }

    @Override
    public void registerScriptLoadPostEvent(IEventHandler<CrTLoadingScriptEventPost> eventHandler) {
        this.CRT_LOADING_SCRIPT_POST_EVENT_LIST.add(eventHandler);
    }
}

