/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.commands;

import crafttweaker.mc1120.commands.CTChatCommand;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import crafttweaker.mc1120.commands.SpecialMessagesChat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class HelpCommand
extends CraftTweakerCommand {
    private final List<SizedList<CraftTweakerCommand>> pages = new ArrayList<SizedList<CraftTweakerCommand>>();
    public static final int lineLimit = 19;
    public static final int windowWidth = 64;

    public HelpCommand() {
        super("help");
    }

    @Override
    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        int page = 0;
        if (args.length > 0) {
            try {
                page = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                sender.func_145747_a(SpecialMessagesChat.getNormalMessage("Page number provided was invalid!"));
            }
        }
        this.sendUsage(sender, page);
    }

    @Override
    protected void init() {
        this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct help", "/ct help", true), SpecialMessagesChat.getNormalMessage(" \u00a73Prints out the this help page"));
    }

    public void sendUsage(ICommandSender sender, int pageNum) {
        this.calculatePages();
        SizedList<CraftTweakerCommand> page = this.pages.get(pageNum);
        sender.func_145747_a(SpecialMessagesChat.getNormalMessage("Tex: " + page.getTextSize()));
        sender.func_145747_a(SpecialMessagesChat.getNormalMessage(TextFormatting.DARK_BLUE + "-----------------------------"));
        int textSize = 19 - page.getTextSize();
        for (int i = 0; i < textSize; ++i) {
            sender.func_145747_a(SpecialMessagesChat.EMPTY_TEXTMESSAGE);
        }
        for (CraftTweakerCommand craftTweakerCommand : page.getList()) {
            for (ITextComponent s : craftTweakerCommand.getDescription()) {
                sender.func_145747_a(s);
            }
            sender.func_145747_a(SpecialMessagesChat.EMPTY_TEXTMESSAGE);
        }
        ITextComponent back = pageNum == 0 ? SpecialMessagesChat.getClickableCommandText(TextFormatting.YELLOW + "##", "/ct help " + pageNum, true) : SpecialMessagesChat.getClickableCommandText(TextFormatting.GREEN + "<<", "/ct help " + (pageNum - 1), true);
        ITextComponent forth = pageNum == this.pages.size() - 1 ? SpecialMessagesChat.getClickableCommandText(TextFormatting.YELLOW + "##", "/ct help " + pageNum, true) : SpecialMessagesChat.getClickableCommandText(TextFormatting.GREEN + ">>", "/ct help " + (pageNum + 1), true);
        back.func_150257_a(SpecialMessagesChat.getClickableCommandText(TextFormatting.DARK_BLUE + " ----  " + TextFormatting.GOLD + (pageNum + 1) + "/" + this.pages.size() + TextFormatting.DARK_BLUE + "  ----- ", "/ct help " + pageNum, true));
        back.func_150257_a(forth);
        sender.func_145747_a(back);
    }

    private void calculatePages() {
        this.pages.clear();
        SizedList<CraftTweakerCommand> currentList = new SizedList<CraftTweakerCommand>();
        this.pages.add(currentList);
        int currentCount = 1;
        for (CraftTweakerCommand entry : CTChatCommand.getCraftTweakerCommands().values()) {
            int currentEntry = 1;
            for (ITextComponent iTextComponent : entry.getDescription()) {
                int width = iTextComponent.func_150260_c().length() / 64 + 1;
                currentEntry += width;
                System.out.println("[" + this.pages.size() + "]" + iTextComponent.func_150260_c() + " : " + width);
            }
            if ((currentCount += currentEntry) >= 19) {
                currentList.setTextSize(currentCount - currentEntry);
                currentList = new SizedList();
                this.pages.add(currentList);
                currentCount = 1 + currentEntry;
            }
            currentList.add(entry);
        }
        currentList.setTextSize(currentCount);
    }

    private static class SizedList<T> {
        private int textSize = 0;
        private List<T> list = new ArrayList<T>();

        private SizedList() {
        }

        public int getTextSize() {
            return this.textSize;
        }

        public void setTextSize(int textSize) {
            this.textSize = textSize;
        }

        public List<T> getList() {
            return this.list;
        }

        public boolean add(T t) {
            return this.list.add(t);
        }
    }
}

