/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.api.entity;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlockDefinition;
import crafttweaker.api.block.IMaterial;
import crafttweaker.api.command.ICommandSender;
import crafttweaker.api.damage.IDamageSource;
import crafttweaker.api.data.IData;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.api.entity.IEntityItem;
import crafttweaker.api.game.ITeam;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.util.Position3f;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IVector3d;
import crafttweaker.api.world.IWorld;
import java.util.List;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenClass(value="crafttweaker.entity.IEntity")
@ZenRegister
public interface IEntity
extends ICommandSender {
    @ZenGetter(value="definition")
    public IEntityDefinition getDefinition();

    @ZenSetter(value="world")
    public void setWorld(IWorld var1);

    @ZenGetter(value="dimension")
    @ZenMethod
    public int getDimension();

    @ZenSetter(value="dimension")
    public void setDimension(int var1);

    @ZenMethod
    @ZenGetter(value="x")
    public double getX();

    @ZenMethod
    @ZenGetter(value="y")
    public double getY();

    @ZenMethod
    @ZenGetter(value="z")
    public double getZ();

    @ZenMethod
    @ZenGetter(value="position3f")
    public Position3f getPosition3f();

    @ZenMethod
    @ZenSetter(value="position")
    public void setPosition(IBlockPos var1);

    @ZenMethod
    public void setDead();

    @ZenMethod
    @ZenSetter(value="fire")
    public void setFire(int var1);

    @ZenMethod
    public void extinguish();

    @ZenMethod
    @ZenGetter(value="wet")
    public boolean isWet();

    @ZenMethod
    @ZenGetter(value="passengers")
    public List<IEntity> getPassengers();

    @ZenMethod
    public double getDistanceSqToEntity(IEntity var1);

    @ZenMethod
    @ZenGetter(value="alive")
    public boolean isAlive();

    @ZenMethod
    @ZenGetter(value="ridingEntity")
    public IEntity getRidingEntity();

    @ZenMethod
    public IItemStack getPickedResult();

    @ZenMethod
    @ZenGetter(value="customName")
    public String getCustomName();

    @ZenMethod
    @ZenSetter(value="customName")
    public void setCustomName(String var1);

    @ZenMethod
    @ZenGetter(value="immuneToFire")
    public boolean isImmuneToFire();

    @ZenMethod
    @ZenGetter(value="air")
    public int getAir();

    @ZenMethod
    @ZenSetter(value="air")
    public void setAir(int var1);

    @Override
    public Object getInternal();

    @ZenMethod
    public boolean canTrample(IWorld var1, IBlockDefinition var2, IBlockPos var3, float var4);

    @ZenMethod
    public void onEntityUpdate();

    @ZenMethod
    public void onUpdate();

    @ZenGetter
    public boolean isSprinting();

    @ZenSetter(value="isSprinting")
    public void setSprinting(boolean var1);

    @ZenGetter
    public boolean isGlowing();

    @ZenSetter(value="isGlowing")
    public void setGlowing(boolean var1);

    @ZenGetter(value="id")
    public int getID();

    @ZenSetter(value="id")
    public void setID(int var1);

    @ZenGetter(value="tags")
    public List<String> getTags();

    @ZenMethod
    public void addTag(String var1);

    @ZenMethod
    public void removeTag(String var1);

    @ZenMethod
    public void onKillCommand();

    @ZenGetter(value="maxInPortalTime")
    public int getMaxInPortalTime();

    @ZenGetter(value="portalCooldown")
    public int getPortalCooldown();

    @ZenGetter
    public boolean isSilent();

    @ZenSetter(value="isSilent")
    public void setSilent(boolean var1);

    @ZenGetter
    public boolean hasNoGravity();

    @ZenSetter(value="hasNoGravity")
    public void setNoGravity(boolean var1);

    @ZenGetter
    public boolean isInWater();

    @ZenGetter
    public boolean isOverWater();

    @ZenMethod
    public void spawnRunningParticles();

    @ZenMethod
    public boolean isInsideOfMaterial(IMaterial var1);

    @ZenGetter
    public boolean isInLava();

    @ZenMethod
    public boolean attackEntityFrom(IDamageSource var1, float var2);

    @ZenGetter
    public boolean canBeCollidedWith();

    @ZenGetter
    public boolean canBePushed();

    @ZenMethod
    public IData getNBT();

    @ZenMethod
    public IEntityItem dropItem(IItemStack var1, @Optional float var2);

    @ZenGetter
    public boolean isInsideOpaqueBlock();

    @ZenMethod
    public void removePassengers();

    @ZenMethod
    public void dismountRidingEntity();

    @ZenGetter(value="heldEquipment")
    public List<IItemStack> getHeldEquipment();

    @ZenGetter(value="armorInventory")
    public List<IItemStack> getArmorInventoryList();

    @ZenGetter(value="equipmentAndArmor")
    public List<IItemStack> getEquipmentAndArmor();

    @ZenGetter
    public boolean isBurning();

    @ZenGetter
    public boolean isRiding();

    @ZenGetter
    public boolean isBeingRidden();

    @ZenGetter
    public boolean isSneaking();

    @ZenSetter(value="isSneaking")
    public void setSneaking(boolean var1);

    @ZenGetter
    public boolean isInvisible();

    @ZenGetter(value="team")
    public ITeam getTeam();

    @ZenSetter(value="isInvisible")
    public void setInvisible(boolean var1);

    @ZenMethod
    public boolean isOnSameTeam(IEntity var1);

    @ZenMethod
    public void setInWeb();

    @ZenMethod(value="parts")
    public IEntity[] getParts();

    @ZenMethod
    public boolean isEntityEqual(IEntity var1);

    @ZenGetter
    public boolean canBeAttackedWithItem();

    @ZenMethod
    public boolean isInvulnerableTo(IDamageSource var1);

    @ZenGetter
    public boolean isInvulnerable();

    @ZenSetter(value="isInvulnerable")
    public void setInvulnerable(boolean var1);

    @ZenMethod
    public void setToLocationFrom(IEntity var1);

    @ZenGetter
    public boolean isBoss();

    @ZenGetter(value="maxFallHeight")
    public int getMaxFallHeight();

    @ZenGetter
    public boolean doesTriggerPressurePlate();

    @ZenGetter
    public boolean isPushedByWater();

    @ZenGetter
    public boolean hasCustomName();

    @ZenGetter(value="alwaysRenderNameTag")
    public boolean alwaysRenderNameTag();

    @ZenSetter(value="alwaysRenderNameTag")
    public void setAlwaysRenderNameTag(boolean var1);

    @ZenGetter(value="eyeHeight")
    public float getEyeHight();

    @ZenGetter
    public boolean isOutsideBorder();

    @ZenSetter(value="isOutsideBorder")
    public void setOutsideBorder(boolean var1);

    @ZenGetter
    public boolean isImmuneToExplosions();

    @ZenGetter
    public boolean shouldRiderSit();

    @ZenGetter
    public boolean canRiderInteract();

    @ZenMethod
    public boolean shouldRiderDismountInWater(IEntity var1);

    @ZenGetter(value="controllingPassenger")
    public IEntity getControllingPassenger();

    @ZenMethod
    public boolean isPassenger(IEntity var1);

    @ZenGetter(value="passengersRecursive")
    public List<IEntity> getPassengersRecursive();

    @ZenGetter(value="lowestRidingEntity")
    public IEntity getLowestRidingEntity();

    @ZenMethod
    public boolean isRidingSameEntity(IEntity var1);

    @ZenGetter
    public boolean canPassengerSteer();

    @ZenGetter(value="rotationYaw")
    public float getRotationYaw();

    @ZenSetter(value="rotationYaw")
    public void setRotationYaw(float var1);

    @ZenGetter(value="rotationPitch")
    public float getRotationPitch();

    @ZenSetter(value="rotationPitch")
    public void setRotationPitch(float var1);

    @ZenGetter(value="motionX")
    public double getMotionX();

    @ZenSetter(value="motionX")
    public void setMotionX(double var1);

    @ZenGetter(value="motionY")
    public double getMotionY();

    @ZenSetter(value="motionY")
    public void setMotionY(double var1);

    @ZenGetter(value="motionZ")
    public double getMotionZ();

    @ZenSetter(value="motionZ")
    public void setMotionZ(double var1);

    @ZenGetter(value="posX")
    public double getPosX();

    @ZenSetter(value="posX")
    public void setPosX(double var1);

    @ZenGetter(value="posY")
    public double getPosY();

    @ZenSetter(value="posY")
    public void setPosY(double var1);

    @ZenGetter(value="posZ")
    public double getPosZ();

    @ZenSetter(value="posZ")
    public void setPosZ(double var1);

    @ZenGetter(value="lookingDirection")
    public IVector3d getLookingDirection();
}

