/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.grid.portable;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridTab;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.storage.IStorageTracker;
import com.raoulvdberge.refinedstorage.api.storage.StorageType;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskProvider;
import com.raoulvdberge.refinedstorage.api.util.IFilter;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.grid.handler.FluidGridHandlerPortable;
import com.raoulvdberge.refinedstorage.apiimpl.network.grid.handler.ItemGridHandlerPortable;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.diskdrive.NetworkNodeDiskDrive;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageCacheFluidPortable;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageCacheItemPortable;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageCacheListenerGridPortable;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageCacheListenerGridPortableFluid;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageTrackerFluid;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageTrackerItem;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.StorageDiskFluidPortable;
import com.raoulvdberge.refinedstorage.apiimpl.storage.disk.StorageDiskItemPortable;
import com.raoulvdberge.refinedstorage.block.BlockPortableGrid;
import com.raoulvdberge.refinedstorage.block.enums.PortableGridDiskState;
import com.raoulvdberge.refinedstorage.block.enums.PortableGridType;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerFilter;
import com.raoulvdberge.refinedstorage.inventory.listener.ListenerTile;
import com.raoulvdberge.refinedstorage.item.ItemWirelessGrid;
import com.raoulvdberge.refinedstorage.tile.TileBase;
import com.raoulvdberge.refinedstorage.tile.config.IRedstoneConfigurable;
import com.raoulvdberge.refinedstorage.tile.config.RedstoneMode;
import com.raoulvdberge.refinedstorage.tile.data.TileDataManager;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import com.raoulvdberge.refinedstorage.tile.grid.TileGrid;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TilePortableGrid
extends TileBase
implements IGrid,
IPortableGrid,
IRedstoneConfigurable,
IStorageDiskContainerContext,
IPortableGrid.IPortableGridRenderInfo {
    public static final TileDataParameter<Integer, TilePortableGrid> REDSTONE_MODE = RedstoneMode.createParameter();
    private static final TileDataParameter<Integer, TilePortableGrid> ENERGY_STORED = new TileDataParameter<Integer, TilePortableGrid>(DataSerializers.field_187192_b, 0, t -> t.energyStorage.getEnergyStored());
    private static final TileDataParameter<Integer, TilePortableGrid> SORTING_DIRECTION = new TileDataParameter<Integer, TilePortableGrid>(DataSerializers.field_187192_b, 0, TilePortableGrid::getSortingDirection, (t, v) -> {
        if (IGrid.isValidSortingDirection(v)) {
            t.setSortingDirection((int)v);
            t.func_70296_d();
        }
    }, (initial, p) -> TileGrid.trySortGrid(initial));
    private static final TileDataParameter<Integer, TilePortableGrid> SORTING_TYPE = new TileDataParameter<Integer, TilePortableGrid>(DataSerializers.field_187192_b, 0, TilePortableGrid::getSortingType, (t, v) -> {
        if (IGrid.isValidSortingType(v)) {
            t.setSortingType((int)v);
            t.func_70296_d();
        }
    }, (initial, p) -> TileGrid.trySortGrid(initial));
    private static final TileDataParameter<Integer, TilePortableGrid> SEARCH_BOX_MODE = new TileDataParameter<Integer, TilePortableGrid>(DataSerializers.field_187192_b, 0, TilePortableGrid::getSearchBoxMode, (t, v) -> {
        if (IGrid.isValidSearchBoxMode(v)) {
            t.setSearchBoxMode((int)v);
            t.func_70296_d();
        }
    }, (initial, p) -> GuiBase.executeLater(GuiGrid.class, grid -> grid.getSearchField().setMode((int)p)));
    private static final TileDataParameter<Integer, TilePortableGrid> SIZE = new TileDataParameter<Integer, TilePortableGrid>(DataSerializers.field_187192_b, 0, TilePortableGrid::getSize, (t, v) -> {
        if (IGrid.isValidSize(v)) {
            t.setSize((int)v);
            t.func_70296_d();
        }
    }, (initial, p) -> GuiBase.executeLater(GuiGrid.class, GuiBase::func_73866_w_));
    private static final TileDataParameter<Integer, TilePortableGrid> TAB_SELECTED = new TileDataParameter<Integer, TilePortableGrid>(DataSerializers.field_187192_b, 0, TilePortableGrid::getTabSelected, (t, v) -> {
        t.setTabSelected(v.intValue() == t.getTabSelected() ? -1 : v);
        t.func_70296_d();
    }, (initial, p) -> GuiBase.executeLater(GuiGrid.class, grid -> grid.getView().sort()));
    private static final TileDataParameter<Integer, TilePortableGrid> TAB_PAGE = new TileDataParameter<Integer, TilePortableGrid>(DataSerializers.field_187192_b, 0, TilePortableGrid::getTabPage, (t, v) -> {
        if (v >= 0 && v <= t.getTotalTabPages()) {
            t.setTabPage((int)v);
            t.func_70296_d();
        }
    });
    private static final String NBT_ENERGY = "Energy";
    private static final String NBT_DISK_STATE = "DiskState";
    private static final String NBT_CONNECTED = "Connected";
    private static final String NBT_STORAGE_TRACKER = "StorageTracker";
    private static final String NBT_FLUID_STORAGE_TRACKER = "FluidStorageTracker";
    private static final String NBT_TYPE = "Type";
    private EnergyStorage energyStorage = this.recreateEnergyStorage(0);
    private PortableGridType type;
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    private int sortingType;
    private int sortingDirection;
    private int searchBoxMode;
    private int tabSelected;
    private int tabPage;
    private int size;
    private GridType clientGridType;
    private List<IFilter> filters = new ArrayList<IFilter>();
    private List<IGridTab> tabs = new ArrayList<IGridTab>();
    private ItemHandlerFilter filter = new ItemHandlerFilter(this.filters, this.tabs, new ListenerTile(this));
    private ItemHandlerBase disk = new ItemHandlerBase(1, new ListenerTile(this), new Predicate[]{NetworkNodeDiskDrive.VALIDATOR_STORAGE_DISK}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (TilePortableGrid.this.field_145850_b != null && !((TilePortableGrid)TilePortableGrid.this).field_145850_b.field_72995_K) {
                TilePortableGrid.this.loadStorage();
            }
        }
    };
    @Nullable
    private IStorageDisk storage;
    @Nullable
    private IStorageCache cache;
    private ItemGridHandlerPortable itemHandler = new ItemGridHandlerPortable(this, this);
    private FluidGridHandlerPortable fluidHandler = new FluidGridHandlerPortable(this);
    private PortableGridDiskState diskState = PortableGridDiskState.NONE;
    private boolean connected;
    private StorageTrackerItem storageTracker = new StorageTrackerItem(() -> ((TilePortableGrid)this).func_70296_d());
    private StorageTrackerFluid fluidStorageTracker = new StorageTrackerFluid(() -> ((TilePortableGrid)this).func_70296_d());

    public TilePortableGrid() {
        this.dataManager.addWatchedParameter(REDSTONE_MODE);
        this.dataManager.addWatchedParameter(ENERGY_STORED);
        this.dataManager.addWatchedParameter(SORTING_DIRECTION);
        this.dataManager.addWatchedParameter(SORTING_TYPE);
        this.dataManager.addWatchedParameter(SEARCH_BOX_MODE);
        this.dataManager.addWatchedParameter(SIZE);
        this.dataManager.addWatchedParameter(TAB_SELECTED);
        this.dataManager.addWatchedParameter(TAB_PAGE);
    }

    private void loadStorage() {
        ItemStack diskStack = this.getDisk().getStackInSlot(0);
        if (diskStack.func_190926_b()) {
            this.storage = null;
            this.cache = null;
        } else {
            IStorageDisk disk = API.instance().getStorageDiskManager(this.field_145850_b).getByStack(this.getDisk().getStackInSlot(0));
            if (disk != null) {
                StorageType type = ((IStorageDiskProvider)this.getDisk().getStackInSlot(0).func_77973_b()).getType();
                switch (type) {
                    case ITEM: {
                        this.storage = new StorageDiskItemPortable(disk, this);
                        this.cache = new StorageCacheItemPortable(this);
                        break;
                    }
                    case FLUID: {
                        this.storage = new StorageDiskFluidPortable(disk, this);
                        this.cache = new StorageCacheFluidPortable(this);
                    }
                }
                this.storage.setSettings(this::checkIfDiskStateChanged, this);
            } else {
                this.storage = null;
                this.cache = null;
            }
        }
        if (this.cache != null) {
            this.cache.invalidate();
        }
        this.checkIfDiskStateChanged();
        WorldUtils.updateBlock(this.field_145850_b, this.field_174879_c);
    }

    public PortableGridDiskState getDiskState() {
        return this.diskState;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public PortableGridType getPortableType() {
        IBlockState state;
        if (this.type == null && (state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() == RSBlocks.PORTABLE_GRID) {
            this.type = (PortableGridType)((Object)state.func_177229_b((IProperty)BlockPortableGrid.TYPE));
        }
        return this.type == null ? PortableGridType.NORMAL : this.type;
    }

    public void onPassItemContext(ItemStack stack) {
        this.sortingType = ItemWirelessGrid.getSortingType(stack);
        this.sortingDirection = ItemWirelessGrid.getSortingDirection(stack);
        this.searchBoxMode = ItemWirelessGrid.getSearchBoxMode(stack);
        this.tabSelected = ItemWirelessGrid.getTabSelected(stack);
        this.tabPage = ItemWirelessGrid.getTabPage(stack);
        this.size = ItemWirelessGrid.getSize(stack);
        this.energyStorage = this.recreateEnergyStorage(((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored());
        if (stack.func_77942_o()) {
            for (int i = 0; i < 4; ++i) {
                StackUtils.readItems((IItemHandlerModifiable)this.filter, i, stack.func_77978_p());
            }
            StackUtils.readItems((IItemHandlerModifiable)this.disk, 4, stack.func_77978_p());
            this.redstoneMode = RedstoneMode.read(stack.func_77978_p());
            if (stack.func_77978_p().func_74764_b(NBT_STORAGE_TRACKER)) {
                this.storageTracker.readFromNbt(stack.func_77978_p().func_150295_c(NBT_STORAGE_TRACKER, 10));
            }
            if (stack.func_77978_p().func_74764_b(NBT_FLUID_STORAGE_TRACKER)) {
                this.fluidStorageTracker.readFromNbt(stack.func_77978_p().func_150295_c(NBT_FLUID_STORAGE_TRACKER, 10));
            }
        }
        this.diskState = TilePortableGrid.getDiskState(this);
        this.func_70296_d();
    }

    private EnergyStorage recreateEnergyStorage(int energyStored) {
        return new EnergyStorage(RS.INSTANCE.config.portableGridCapacity, RS.INSTANCE.config.portableGridCapacity, 0, energyStored);
    }

    public ItemStack getAsItem() {
        ItemStack stack = new ItemStack((Block)RSBlocks.PORTABLE_GRID, 1, this.getPortableType() == PortableGridType.NORMAL ? 0 : 1);
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74768_a("SortingDirection", this.sortingDirection);
        stack.func_77978_p().func_74768_a("SortingType", this.sortingType);
        stack.func_77978_p().func_74768_a("SearchBoxMode", this.searchBoxMode);
        stack.func_77978_p().func_74768_a("Size", this.size);
        stack.func_77978_p().func_74768_a("TabSelected", this.tabSelected);
        stack.func_77978_p().func_74768_a("TabPage", this.tabPage);
        stack.func_77978_p().func_74782_a(NBT_STORAGE_TRACKER, (NBTBase)this.storageTracker.serializeNbt());
        stack.func_77978_p().func_74782_a(NBT_FLUID_STORAGE_TRACKER, (NBTBase)this.fluidStorageTracker.serializeNbt());
        ((IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)).receiveEnergy(this.energyStorage.getEnergyStored(), false);
        for (int i = 0; i < 4; ++i) {
            StackUtils.writeItems((IItemHandler)this.filter, i, stack.func_77978_p());
        }
        StackUtils.writeItems((IItemHandler)this.disk, 4, stack.func_77978_p());
        this.redstoneMode.write(stack.func_77978_p());
        return stack;
    }

    @Override
    public GridType getGridType() {
        return this.clientGridType != null ? this.clientGridType : this.getServerGridType();
    }

    private GridType getServerGridType() {
        return this.getDisk().getStackInSlot(0).func_190926_b() || ((IStorageDiskProvider)this.getDisk().getStackInSlot(0).func_77973_b()).getType() == StorageType.ITEM ? GridType.NORMAL : GridType.FLUID;
    }

    @Override
    @Nullable
    public IStorageCache getStorageCache() {
        return this.storage != null ? this.cache : null;
    }

    @Override
    public IStorageCacheListener createListener(EntityPlayerMP player) {
        return this.getServerGridType() == GridType.FLUID ? new StorageCacheListenerGridPortableFluid(this, player) : new StorageCacheListenerGridPortable(this, player);
    }

    @Override
    @Nullable
    public IItemGridHandler getItemHandler() {
        return this.itemHandler;
    }

    @Override
    @Nullable
    public IFluidGridHandler getFluidHandler() {
        return this.fluidHandler;
    }

    @Override
    public String getGuiTitle() {
        return "gui.refinedstorage:portable_grid";
    }

    @Override
    public int getViewType() {
        return -1;
    }

    @Override
    public int getSortingType() {
        return this.field_145850_b.field_72995_K ? SORTING_TYPE.getValue() : this.sortingType;
    }

    @Override
    public int getSortingDirection() {
        return this.field_145850_b.field_72995_K ? SORTING_DIRECTION.getValue() : this.sortingDirection;
    }

    @Override
    public int getSearchBoxMode() {
        return this.field_145850_b.field_72995_K ? SEARCH_BOX_MODE.getValue() : this.searchBoxMode;
    }

    @Override
    public int getTabSelected() {
        return this.field_145850_b.field_72995_K ? TAB_SELECTED.getValue() : this.tabSelected;
    }

    @Override
    public int getTabPage() {
        return this.field_145850_b.field_72995_K ? TAB_PAGE.getValue() : Math.min(this.tabPage, this.getTotalTabPages());
    }

    @Override
    public int getTotalTabPages() {
        return (int)Math.floor((float)Math.max(0, this.tabs.size() - 1) / 6.0f);
    }

    @Override
    public int getSize() {
        return this.field_145850_b.field_72995_K ? SIZE.getValue() : this.size;
    }

    public void setSortingType(int sortingType) {
        this.sortingType = sortingType;
    }

    public void setSortingDirection(int sortingDirection) {
        this.sortingDirection = sortingDirection;
    }

    public void setSearchBoxMode(int searchBoxMode) {
        this.searchBoxMode = searchBoxMode;
    }

    public void setTabSelected(int tabSelected) {
        this.tabSelected = tabSelected;
    }

    public void setTabPage(int page) {
        this.tabPage = page;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public void onViewTypeChanged(int type) {
    }

    @Override
    public void onSortingTypeChanged(int type) {
        TileDataManager.setParameter(SORTING_TYPE, type);
    }

    @Override
    public void onSortingDirectionChanged(int direction) {
        TileDataManager.setParameter(SORTING_DIRECTION, direction);
    }

    @Override
    public void onSearchBoxModeChanged(int searchBoxMode) {
        TileDataManager.setParameter(SEARCH_BOX_MODE, searchBoxMode);
    }

    @Override
    public void onSizeChanged(int size) {
        TileDataManager.setParameter(SIZE, size);
    }

    @Override
    public void onTabSelectionChanged(int tab) {
        TileDataManager.setParameter(TAB_SELECTED, tab);
    }

    @Override
    public void onTabPageChanged(int page) {
        if (page >= 0 && page <= this.getTotalTabPages()) {
            TileDataManager.setParameter(TAB_PAGE, page);
        }
    }

    @Override
    public List<IFilter> getFilters() {
        return this.filters;
    }

    @Override
    public List<IGridTab> getTabs() {
        return this.tabs;
    }

    @Override
    public IItemHandlerModifiable getFilter() {
        return this.filter;
    }

    @Override
    public IStorageTracker<ItemStack> getItemStorageTracker() {
        return this.storageTracker;
    }

    @Override
    public IStorageTracker<FluidStack> getFluidStorageTracker() {
        return this.fluidStorageTracker;
    }

    @Override
    public InventoryCrafting getCraftingMatrix() {
        return null;
    }

    @Override
    public InventoryCraftResult getCraftingResult() {
        return null;
    }

    @Override
    public void onCraftingMatrixChanged() {
    }

    @Override
    public void onCrafted(EntityPlayer player) {
    }

    @Override
    public void onCraftedShift(EntityPlayer player) {
    }

    @Override
    public void onRecipeTransfer(EntityPlayer player, ItemStack[][] recipe) {
    }

    @Override
    public void onClosed(EntityPlayer player) {
    }

    @Override
    public boolean isActive() {
        int stored;
        int n = stored = !this.field_145850_b.field_72995_K ? this.energyStorage.getEnergyStored() : ENERGY_STORED.getValue().intValue();
        if (this.getPortableType() != PortableGridType.CREATIVE && RS.INSTANCE.config.portableGridUsesEnergy && stored <= RS.INSTANCE.config.portableGridOpenUsage) {
            return false;
        }
        if (this.disk.getStackInSlot(0).func_190926_b()) {
            return false;
        }
        RedstoneMode redstoneMode = !this.field_145850_b.field_72995_K ? this.redstoneMode : RedstoneMode.getById(REDSTONE_MODE.getValue());
        return redstoneMode.isEnabled(this.field_145850_b, this.field_174879_c);
    }

    @Override
    @Nullable
    public IStorageCache getCache() {
        return this.cache;
    }

    @Override
    @Nullable
    public IStorageDisk getStorage() {
        return this.storage;
    }

    @Override
    public void drainEnergy(int energy) {
        if (RS.INSTANCE.config.portableGridUsesEnergy && this.getPortableType() != PortableGridType.CREATIVE && this.redstoneMode.isEnabled(this.field_145850_b, this.field_174879_c)) {
            this.energyStorage.extractEnergy(energy, false);
            this.checkIfDiskStateChanged();
        }
        this.checkIfConnectivityChanged();
    }

    @Override
    public int getStored() {
        return this.storage != null ? this.storage.getStored() : 0;
    }

    @Override
    public int getCapacity() {
        return this.storage != null ? this.storage.getCapacity() : 0;
    }

    @Override
    public boolean hasStorage() {
        return this.storage != null;
    }

    @Override
    public int getEnergy() {
        if (RS.INSTANCE.config.portableGridUsesEnergy && this.getPortableType() != PortableGridType.CREATIVE) {
            return this.energyStorage.getEnergyStored();
        }
        return this.energyStorage.getMaxEnergyStored();
    }

    private void checkIfDiskStateChanged() {
        PortableGridDiskState newDiskState = TilePortableGrid.getDiskState(this);
        if (this.diskState != newDiskState) {
            this.diskState = newDiskState;
            WorldUtils.updateBlock(this.field_145850_b, this.field_174879_c);
        }
    }

    private void checkIfConnectivityChanged() {
        boolean isConnected;
        boolean bl = isConnected = this.getEnergy() != 0;
        if (this.connected != isConnected) {
            this.connected = isConnected;
            WorldUtils.updateBlock(this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    public ItemHandlerBase getDisk() {
        return this.disk;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        tag.func_74768_a("SortingDirection", this.sortingDirection);
        tag.func_74768_a("SortingType", this.sortingType);
        tag.func_74768_a("SearchBoxMode", this.searchBoxMode);
        tag.func_74768_a("Size", this.size);
        tag.func_74768_a("TabSelected", this.tabSelected);
        tag.func_74768_a("TabPage", this.tabPage);
        StackUtils.writeItems((IItemHandler)this.disk, 0, tag);
        StackUtils.writeItems((IItemHandler)this.filter, 1, tag);
        tag.func_74768_a(NBT_ENERGY, this.energyStorage.getEnergyStored());
        this.redstoneMode.write(tag);
        tag.func_74782_a(NBT_STORAGE_TRACKER, (NBTBase)this.storageTracker.serializeNbt());
        tag.func_74782_a(NBT_FLUID_STORAGE_TRACKER, (NBTBase)this.fluidStorageTracker.serializeNbt());
        return tag;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_74764_b("SortingDirection")) {
            this.sortingDirection = tag.func_74762_e("SortingDirection");
        }
        if (tag.func_74764_b("SortingType")) {
            this.sortingType = tag.func_74762_e("SortingType");
        }
        if (tag.func_74764_b("SearchBoxMode")) {
            this.searchBoxMode = tag.func_74762_e("SearchBoxMode");
        }
        if (tag.func_74764_b("Size")) {
            this.size = tag.func_74762_e("Size");
        }
        if (tag.func_74764_b("TabSelected")) {
            this.tabSelected = tag.func_74762_e("TabSelected");
        }
        if (tag.func_74764_b("TabPage")) {
            this.tabPage = tag.func_74762_e("TabPage");
        }
        StackUtils.readItems((IItemHandlerModifiable)this.disk, 0, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.filter, 1, tag);
        if (tag.func_74764_b(NBT_ENERGY)) {
            this.energyStorage = this.recreateEnergyStorage(tag.func_74762_e(NBT_ENERGY));
        }
        this.redstoneMode = RedstoneMode.read(tag);
        if (tag.func_74764_b(NBT_STORAGE_TRACKER)) {
            this.storageTracker.readFromNbt(tag.func_150295_c(NBT_STORAGE_TRACKER, 10));
        }
        if (tag.func_74764_b(NBT_FLUID_STORAGE_TRACKER)) {
            this.fluidStorageTracker.readFromNbt(tag.func_150295_c(NBT_FLUID_STORAGE_TRACKER, 10));
        }
    }

    public void onLoad() {
        super.onLoad();
        this.loadStorage();
        this.connected = this.getEnergy() != 0;
        this.diskState = TilePortableGrid.getDiskState(this);
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        tag.func_74768_a(NBT_DISK_STATE, this.diskState.getId());
        tag.func_74757_a(NBT_CONNECTED, this.getEnergy() != 0);
        tag.func_74768_a(NBT_TYPE, this.getServerGridType().ordinal());
        return super.writeUpdate(tag);
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        super.readUpdate(tag);
        this.diskState = PortableGridDiskState.getById(tag.func_74762_e(NBT_DISK_STATE));
        this.connected = tag.func_74767_n(NBT_CONNECTED);
        this.clientGridType = GridType.values()[tag.func_74762_e(NBT_TYPE)];
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityEnergy.ENERGY ? CapabilityEnergy.ENERGY.cast((Object)this.energyStorage) : super.getCapability(capability, facing));
    }

    public void onOpened() {
        this.drainEnergy(RS.INSTANCE.config.portableGridOpenUsage);
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
        this.redstoneMode = mode;
        this.func_70296_d();
    }

    public static PortableGridDiskState getDiskState(IPortableGrid.IPortableGridRenderInfo renderInfo) {
        if (!renderInfo.hasStorage()) {
            return PortableGridDiskState.NONE;
        }
        if (!renderInfo.isActive()) {
            return PortableGridDiskState.DISCONNECTED;
        }
        if (renderInfo.getStored() == renderInfo.getCapacity()) {
            return PortableGridDiskState.FULL;
        }
        if ((int)((float)renderInfo.getStored() / (float)renderInfo.getCapacity() * 100.0f) >= 75) {
            return PortableGridDiskState.NEAR_CAPACITY;
        }
        return PortableGridDiskState.NORMAL;
    }

    @Override
    public AccessType getAccessType() {
        return AccessType.INSERT_EXTRACT;
    }
}

