/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.grid.filtering;

import com.raoulvdberge.refinedstorage.api.util.IFilter;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.gui.grid.stack.GridStackFluid;
import com.raoulvdberge.refinedstorage.gui.grid.stack.GridStackItem;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GridFilterFilter
implements Predicate<IGridStack> {
    private List<IFilter> filters;

    public GridFilterFilter(List<IFilter> filters) {
        this.filters = filters;
    }

    @Override
    public boolean test(IGridStack stack) {
        if (this.filters.isEmpty()) {
            return true;
        }
        int lastMode = 0;
        for (IFilter filter : this.filters) {
            String stackInFilterModId;
            ItemStack stackInFilter;
            lastMode = filter.getMode();
            if (stack instanceof GridStackItem && filter.getStack() instanceof ItemStack) {
                stackInFilter = (ItemStack)filter.getStack();
                if (!(filter.isModFilter() ? stackInFilter.func_77973_b().getRegistryName().func_110624_b().equalsIgnoreCase(stack.getModId()) : API.instance().getComparer().isEqual(((GridStackItem)stack).getStack(), stackInFilter, filter.getCompare()))) continue;
                return filter.getMode() == 0;
            }
            if (!(stack instanceof GridStackFluid) || !(filter.getStack() instanceof FluidStack)) continue;
            stackInFilter = (FluidStack)filter.getStack();
            if (!(filter.isModFilter() ? (stackInFilterModId = FluidRegistry.getModId((FluidStack)stackInFilter)) != null && stackInFilterModId.equalsIgnoreCase(stack.getModId()) : API.instance().getComparer().isEqual(((GridStackFluid)stack).getStack(), (FluidStack)stackInFilter, filter.getCompare()))) continue;
            return filter.getMode() == 0;
        }
        return lastMode != 0;
    }
}

