/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingRequestInfo;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridTab;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawer;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawers;
import com.raoulvdberge.refinedstorage.api.util.IFilter;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.container.ContainerCraftingMonitor;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.IResizableDisplay;
import com.raoulvdberge.refinedstorage.gui.control.Scrollbar;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonGridSize;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonRedstoneMode;
import com.raoulvdberge.refinedstorage.gui.control.TabList;
import com.raoulvdberge.refinedstorage.network.MessageCraftingMonitorCancel;
import com.raoulvdberge.refinedstorage.tile.craftingmonitor.ICraftingMonitor;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiCraftingMonitor
extends GuiBase
implements IResizableDisplay {
    private static final int ITEM_WIDTH = 143;
    private static final int ITEM_HEIGHT = 18;
    private GuiButton cancelButton;
    private GuiButton cancelAllButton;
    private ICraftingMonitor craftingMonitor;
    private List<IGridTab> tasks = Collections.emptyList();
    private TabList tabs;
    private int elementSelected = -1;
    private IElementDrawers drawers = new CraftingMonitorElementDrawers();

    public GuiCraftingMonitor(ContainerCraftingMonitor container, final ICraftingMonitor craftingMonitor) {
        super(container, 176, 230);
        this.craftingMonitor = craftingMonitor;
        this.tabs = new TabList(this, new GuiBase.ElementDrawers(), () -> this.tasks, () -> (int)Math.floor((float)Math.max(0, this.tasks.size() - 1) / 6.0f), craftingMonitor::getTabPage, () -> {
            IGridTab tab = this.getCurrentTab();
            if (tab == null) {
                return -1;
            }
            return this.tasks.indexOf(tab);
        }, 6);
        this.tabs.addListener(new TabList.ITabListListener(){

            @Override
            public void onSelectionChanged(int tab) {
                craftingMonitor.onTabSelectionChanged((Optional<UUID>)Optional.of((Object)((CraftingMonitorTask)GuiCraftingMonitor.this.tasks.get(tab)).id));
                GuiCraftingMonitor.this.scrollbar.setOffset(0);
            }

            @Override
            public void onPageChanged(int page) {
                craftingMonitor.onTabPageChanged(page);
            }
        });
    }

    public void setTasks(List<IGridTab> tasks) {
        this.tasks = tasks;
    }

    public List<ICraftingMonitorElement> getElements() {
        IGridTab tab = this.getCurrentTab();
        if (tab == null) {
            return Collections.emptyList();
        }
        return ((CraftingMonitorTask)tab).elements;
    }

    @Override
    public void init(int x, int y) {
        ((ContainerCraftingMonitor)this.field_147002_h).initSlots();
        this.tabs.init(this.field_146999_f);
        this.scrollbar = new Scrollbar(157, this.getTopHeight() + this.tabs.getHeight(), 12, this.getVisibleRows() * 18 - 1);
        if (this.craftingMonitor.getRedstoneModeParameter() != null) {
            this.addSideButton(new SideButtonRedstoneMode(this, this.craftingMonitor.getRedstoneModeParameter()));
        }
        this.addSideButton(new SideButtonGridSize(this, () -> this.craftingMonitor.getSize(), size -> this.craftingMonitor.onSizeChanged((int)size)));
        String cancel = GuiCraftingMonitor.t("gui.cancel", new Object[0]);
        String cancelAll = GuiCraftingMonitor.t("misc.refinedstorage:cancel_all", new Object[0]);
        int cancelButtonWidth = 14 + this.field_146289_q.func_78256_a(cancel);
        int cancelAllButtonWidth = 14 + this.field_146289_q.func_78256_a(cancelAll);
        int by = y + this.getTopHeight() + this.getVisibleRows() * 18 + 3 + this.tabs.getHeight();
        this.cancelButton = this.addButton(x + 7, by, cancelButtonWidth, 20, cancel, false, true);
        this.cancelAllButton = this.addButton(x + 7 + cancelButtonWidth + 4, by, cancelAllButtonWidth, 20, cancelAll, false, true);
    }

    private void updateScrollbar() {
        if (this.scrollbar != null) {
            this.scrollbar.setEnabled(this.getRows() > this.getVisibleRows());
            this.scrollbar.setMaxOffset(this.getRows() - this.getVisibleRows());
        }
    }

    @Override
    public void update(int x, int y) {
        this.updateScrollbar();
        this.tabs.update();
        if (this.elementSelected >= this.getElements().size()) {
            this.elementSelected = -1;
        }
        if (this.cancelButton != null) {
            this.cancelButton.field_146124_l = this.hasValidTabSelected();
        }
        if (this.cancelAllButton != null) {
            this.cancelAllButton.field_146124_l = this.tasks.size() > 0;
        }
    }

    private boolean hasValidTabSelected() {
        return this.getCurrentTab() != null;
    }

    @Nullable
    private IGridTab getCurrentTab() {
        IGridTab tab;
        Optional<UUID> currentTab = this.craftingMonitor.getTabSelected();
        if (currentTab.isPresent() && (tab = this.getTabById((UUID)currentTab.get())) != null) {
            return tab;
        }
        if (this.tasks.isEmpty()) {
            return null;
        }
        return this.tasks.get(0);
    }

    @Nullable
    private IGridTab getTabById(UUID id) {
        return this.tasks.stream().filter(t -> ((CraftingMonitorTask)t).id.equals(id)).findFirst().orElse(null);
    }

    @Override
    protected void calcHeight() {
        this.screenHeight = this.field_147000_g = this.getTopHeight() + this.getBottomHeight() + this.getVisibleRows() * 18 + this.tabs.getHeight();
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        this.tabs.drawBackground(x, y);
        this.bindTexture("gui/crafting_monitor.png");
        int yy = y + this.tabs.getHeight();
        this.drawTexture(x, yy, 0, 0, this.screenWidth, this.getTopHeight());
        yy += this.getTopHeight();
        int rows = this.getVisibleRows();
        for (int i = 0; i < rows; ++i) {
            this.drawTexture(x, yy, 0, this.getTopHeight() + (i > 0 ? (i == rows - 1 ? 36 : 18) : 0), this.screenWidth, 18);
            yy += 18;
        }
        this.drawTexture(x, yy, 0, this.getTopHeight() + 54, this.screenWidth, this.getBottomHeight());
        this.tabs.drawForeground(x, y, mouseX, mouseY);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        this.drawString(7, 7 + this.tabs.getHeight(), GuiCraftingMonitor.t(this.craftingMonitor.getGuiTitle(), new Object[0]));
        this.drawString(7, this.getYPlayerInventory() - 12, GuiCraftingMonitor.t("container.inventory", new Object[0]));
        int item = this.scrollbar != null ? this.scrollbar.getOffset() : 0;
        RenderHelper.func_74520_c();
        int x = 8;
        int y = 20 + this.tabs.getHeight();
        String itemSelectedTooltip = null;
        for (int i = this.scrollbar.getOffset(); i < this.scrollbar.getOffset() + this.getVisibleRows(); ++i) {
            if (item < this.getElements().size()) {
                ICraftingMonitorElement element = this.getElements().get(item);
                if (this.inBounds(x, y, 143, 18, mouseX, mouseY)) {
                    itemSelectedTooltip = element.getTooltip();
                }
                element.draw(x, y, this.drawers, item == this.elementSelected);
                y += 18;
            }
            ++item;
        }
        if (itemSelectedTooltip != null && !itemSelectedTooltip.isEmpty()) {
            this.drawTooltip(mouseX, mouseY, I18n.func_135052_a((String)itemSelectedTooltip, (Object[])new Object[0]));
        }
        this.tabs.drawTooltip(this.field_146289_q, mouseX, mouseY);
    }

    @Override
    public int getVisibleRows() {
        switch (this.craftingMonitor.getSize()) {
            case 0: {
                int screenSpaceAvailable = this.field_146295_m - this.getTopHeight() - this.getBottomHeight() - this.tabs.getHeight();
                return Math.max(3, Math.min(screenSpaceAvailable / 18 - 3, RS.INSTANCE.config.maxRowsStretch));
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 8;
            }
        }
        return 3;
    }

    @Override
    public int getRows() {
        return this.getElements().size();
    }

    @Override
    public int getCurrentOffset() {
        return this.scrollbar.getOffset();
    }

    @Override
    public String getSearchFieldText() {
        return null;
    }

    @Override
    public int getTopHeight() {
        return 20;
    }

    @Override
    public int getBottomHeight() {
        return 120;
    }

    @Override
    public int getYPlayerInventory() {
        return this.getTopHeight() + 18 * this.getVisibleRows() + 38 + this.tabs.getHeight();
    }

    @Override
    protected int getSideButtonYStart() {
        return super.getSideButtonYStart() + this.tabs.getHeight();
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        this.tabs.actionPerformed(button);
        if (button == this.cancelButton && this.hasValidTabSelected()) {
            RS.INSTANCE.network.sendToServer((IMessage)new MessageCraftingMonitorCancel(((CraftingMonitorTask)this.getCurrentTab()).id));
        } else if (button == this.cancelAllButton && this.tasks.size() > 0) {
            RS.INSTANCE.network.sendToServer((IMessage)new MessageCraftingMonitorCancel(null));
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.tabs.mouseClicked();
        this.elementSelected = -1;
        if (mouseButton == 0) {
            int item = this.scrollbar != null ? this.scrollbar.getOffset() : 0;
            for (int i = 0; i < this.getVisibleRows(); ++i) {
                int ix = 8;
                int iy = 20 + i * 18 + this.tabs.getHeight();
                if (!this.inBounds(ix, iy, 143, 18, mouseX - this.field_147003_i, mouseY - this.field_147009_r) || item + i >= this.getElements().size()) continue;
                this.elementSelected = item + i;
            }
        }
    }

    public static class CraftingMonitorTask
    implements IGridTab {
        private UUID id;
        private ICraftingRequestInfo requested;
        private int qty;
        private long executionStarted;
        private List<ICraftingMonitorElement> elements;

        public CraftingMonitorTask(UUID id, ICraftingRequestInfo requested, int qty, long executionStarted, List<ICraftingMonitorElement> elements) {
            this.id = id;
            this.requested = requested;
            this.qty = qty;
            this.executionStarted = executionStarted;
            this.elements = elements;
        }

        @Override
        public List<IFilter> getFilters() {
            return null;
        }

        @Override
        public void drawTooltip(int x, int y, int screenWidth, int screenHeight, FontRenderer fontRenderer) {
            ArrayList textLines = Lists.newArrayList((Object[])new String[]{this.requested.getItem() != null ? this.requested.getItem().func_82833_r() : this.requested.getFluid().getLocalizedName()});
            ArrayList smallTextLines = Lists.newArrayList();
            int totalSecs = (int)(System.currentTimeMillis() - this.executionStarted) / 1000;
            int minutes = totalSecs % 3600 / 60;
            int seconds = totalSecs % 60;
            smallTextLines.add(I18n.func_135052_a((String)"gui.refinedstorage:crafting_monitor.tooltip.requested", (Object[])new Object[]{this.requested.getFluid() != null ? API.instance().getQuantityFormatter().formatInBucketForm(this.qty) : API.instance().getQuantityFormatter().format(this.qty)}));
            smallTextLines.add(String.format("%02d:%02d", minutes, seconds));
            RenderUtils.drawTooltipWithSmallText(textLines, smallTextLines, true, ItemStack.field_190927_a, x, y, screenWidth, screenHeight, fontRenderer);
        }

        @Override
        public void drawIcon(int x, int y, IElementDrawer<ItemStack> itemDrawer, IElementDrawer<FluidStack> fluidDrawer) {
            if (this.requested.getItem() != null) {
                itemDrawer.draw(x, y, this.requested.getItem());
            } else {
                fluidDrawer.draw(x, y, this.requested.getFluid());
            }
        }
    }

    public class CraftingMonitorElementDrawers
    extends GuiBase.ElementDrawers {
        private IElementDrawer<Integer> overlayDrawer = (x, y, color) -> {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            Gui.func_73734_a((int)x, (int)y, (int)(x + 143), (int)(y + 18 - 1), (int)color);
        };

        @Override
        public IElementDrawer<Integer> getOverlayDrawer() {
            return this.overlayDrawer;
        }
    }
}

