/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.container;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.container.slot.filter.SlotFilter;
import com.raoulvdberge.refinedstorage.container.slot.filter.SlotFilterFluid;
import com.raoulvdberge.refinedstorage.container.slot.legacy.SlotLegacyDisabled;
import com.raoulvdberge.refinedstorage.container.slot.legacy.SlotLegacyFilter;
import com.raoulvdberge.refinedstorage.container.transfer.TransferManager;
import com.raoulvdberge.refinedstorage.network.MessageSlotFilterFluidUpdate;
import com.raoulvdberge.refinedstorage.tile.TileBase;
import com.raoulvdberge.refinedstorage.tile.data.TileDataWatcher;
import invtweaks.api.container.InventoryContainer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@InventoryContainer(showOptions=false)
public abstract class ContainerBase
extends Container {
    @Nullable
    private TileBase tile;
    @Nullable
    private TileDataWatcher listener;
    private EntityPlayer player;
    protected TransferManager transferManager = new TransferManager(this);
    private List<SlotFilterFluid> fluidSlots = new ArrayList<SlotFilterFluid>();
    private List<FluidStack> fluids = new ArrayList<FluidStack>();

    public ContainerBase(@Nullable TileBase tile, EntityPlayer player) {
        this.tile = tile;
        if (tile != null && player instanceof EntityPlayerMP) {
            this.listener = new TileDataWatcher((EntityPlayerMP)player, tile.getDataManager());
        }
        this.player = player;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    @Nullable
    public TileBase getTile() {
        return this.tile;
    }

    protected void addPlayerInventory(int xInventory, int yInventory) {
        int x;
        int id = 0;
        for (int i = 0; i < 9; ++i) {
            x = xInventory + i * 18;
            int y = yInventory + 4 + 54;
            if (this.isHeldItemDisabled() && i == this.player.field_71071_by.field_70461_c) {
                this.func_75146_a(new SlotLegacyDisabled((IInventory)this.player.field_71071_by, id, x, y));
            } else {
                this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, id, x, y));
            }
            ++id;
        }
        for (int y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, id, xInventory + x * 18, yInventory + y * 18));
                ++id;
            }
        }
    }

    public ItemStack func_184996_a(int id, int dragType, ClickType clickType, EntityPlayer player) {
        Slot slot;
        Slot slot2 = slot = id >= 0 ? this.func_75139_a(id) : null;
        if (this.isHeldItemDisabled() && clickType == ClickType.SWAP && dragType == player.field_71071_by.field_70461_c) {
            return ItemStack.field_190927_a;
        }
        if (slot instanceof SlotFilter) {
            if (((SlotFilter)slot).isSizeAllowed()) {
                if (clickType == ClickType.QUICK_MOVE) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                } else if (!player.field_71071_by.func_70445_o().func_190926_b()) {
                    slot.func_75215_d(player.field_71071_by.func_70445_o().func_77946_l());
                } else if (slot.func_75216_d()) {
                    slot.func_75211_c().func_190920_e(((SlotFilter)slot).getModifiedAmount(dragType));
                    this.func_75142_b();
                }
            } else if (player.field_71071_by.func_70445_o().func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else if (slot.func_75214_a(player.field_71071_by.func_70445_o())) {
                slot.func_75215_d(player.field_71071_by.func_70445_o().func_77946_l());
            }
            return player.field_71071_by.func_70445_o();
        }
        if (slot instanceof SlotFilterFluid) {
            if (((SlotFilterFluid)slot).isSizeAllowed()) {
                if (clickType == ClickType.QUICK_MOVE) {
                    ((SlotFilterFluid)slot).onContainerClicked(ItemStack.field_190927_a);
                } else if (!player.field_71071_by.func_70445_o().func_190926_b()) {
                    ((SlotFilterFluid)slot).onContainerClicked(player.field_71071_by.func_70445_o());
                }
            } else if (player.field_71071_by.func_70445_o().func_190926_b()) {
                ((SlotFilterFluid)slot).onContainerClicked(ItemStack.field_190927_a);
            } else {
                ((SlotFilterFluid)slot).onContainerClicked(player.field_71071_by.func_70445_o());
            }
            return player.field_71071_by.func_70445_o();
        }
        if (slot instanceof SlotLegacyFilter) {
            if (player.field_71071_by.func_70445_o().func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else if (slot.func_75214_a(player.field_71071_by.func_70445_o())) {
                slot.func_75215_d(player.field_71071_by.func_70445_o().func_77946_l());
            }
            return player.field_71071_by.func_70445_o();
        }
        if (slot instanceof SlotLegacyDisabled) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(id, dragType, clickType, player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        return this.transferManager.transfer(slotIndex);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    protected boolean isHeldItemDisabled() {
        return false;
    }

    protected Slot func_75146_a(Slot slot) {
        if (slot instanceof SlotFilterFluid) {
            this.fluids.add(null);
            this.fluidSlots.add((SlotFilterFluid)slot);
        }
        return super.func_75146_a(slot);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.listener != null) {
            this.listener.detectAndSendChanges();
        }
        if (this.getPlayer() instanceof EntityPlayerMP) {
            for (int i = 0; i < this.fluidSlots.size(); ++i) {
                SlotFilterFluid slot = this.fluidSlots.get(i);
                FluidStack cached = this.fluids.get(i);
                FluidStack actual = slot.getFluidInventory().getFluid(slot.getSlotIndex());
                if (API.instance().getComparer().isEqual(cached, actual, 6)) continue;
                this.fluids.set(i, actual);
                RS.INSTANCE.network.sendTo((IMessage)new MessageSlotFilterFluidUpdate(slot.field_75222_d, actual), (EntityPlayerMP)this.getPlayer());
            }
        }
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.listener != null) {
            this.listener.onClosed();
        }
    }
}

