/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.externalstorage;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.externalstorage.IExternalStorageContext;
import com.raoulvdberge.refinedstorage.api.storage.externalstorage.IStorageExternal;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class StorageExternalItem
implements IStorageExternal<ItemStack> {
    private IExternalStorageContext context;
    private Supplier<IItemHandler> handlerSupplier;
    private List<ItemStack> cache;
    private boolean connectedToInterface;

    public StorageExternalItem(IExternalStorageContext context, Supplier<IItemHandler> handlerSupplier, boolean connectedToInterface) {
        this.context = context;
        this.handlerSupplier = handlerSupplier;
        this.connectedToInterface = connectedToInterface;
    }

    public boolean isConnectedToInterface() {
        return this.connectedToInterface;
    }

    @Override
    public void update(INetwork network) {
        int i;
        if (this.getAccessType() == AccessType.INSERT) {
            return;
        }
        if (this.cache == null) {
            this.cache = new ArrayList<ItemStack>(this.getStacks());
            return;
        }
        ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>(this.getStacks());
        for (i = 0; i < newStacks.size(); ++i) {
            ItemStack actual = (ItemStack)newStacks.get(i);
            if (i >= this.cache.size()) {
                if (actual.func_190926_b()) continue;
                network.getItemStorageCache().add(actual, actual.func_190916_E(), false, true);
                continue;
            }
            ItemStack cached = this.cache.get(i);
            if (!cached.func_190926_b() && actual.func_190926_b()) {
                network.getItemStorageCache().remove(cached, cached.func_190916_E(), true);
                continue;
            }
            if (cached.func_190926_b() && !actual.func_190926_b()) {
                network.getItemStorageCache().add(actual, actual.func_190916_E(), false, true);
                if (this.isConnectedToInterface()) continue;
                network.getCraftingManager().track(actual, actual.func_190916_E());
                continue;
            }
            if (cached.func_190926_b() && actual.func_190926_b()) continue;
            if (!API.instance().getComparer().isEqualNoQuantity(cached, actual)) {
                network.getItemStorageCache().remove(cached, cached.func_190916_E(), true);
                network.getItemStorageCache().add(actual, actual.func_190916_E(), false, true);
                if (this.isConnectedToInterface()) continue;
                network.getCraftingManager().track(actual, actual.func_190916_E());
                continue;
            }
            if (cached.func_190916_E() == actual.func_190916_E()) continue;
            int delta = actual.func_190916_E() - cached.func_190916_E();
            if (delta > 0) {
                network.getItemStorageCache().add(actual, delta, false, true);
                if (this.isConnectedToInterface()) continue;
                network.getCraftingManager().track(actual, delta);
                continue;
            }
            network.getItemStorageCache().remove(actual, Math.abs(delta), true);
        }
        if (this.cache.size() > newStacks.size()) {
            for (i = newStacks.size(); i < this.cache.size(); ++i) {
                if (this.cache.get(i) == ItemStack.field_190927_a) continue;
                network.getItemStorageCache().remove(this.cache.get(i), this.cache.get(i).func_190916_E(), true);
            }
        }
        this.cache = newStacks;
        network.getItemStorageCache().flush();
    }

    @Override
    public int getCapacity() {
        IItemHandler handler = this.handlerSupplier.get();
        if (handler == null) {
            return 0;
        }
        int capacity = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            capacity += Math.min(handler.getSlotLimit(i), handler.getStackInSlot(i).func_77976_d());
        }
        return capacity;
    }

    @Override
    public Collection<ItemStack> getStacks() {
        IItemHandler handler = this.handlerSupplier.get();
        if (handler == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            stacks.add(handler.getStackInSlot(i).func_77946_l());
        }
        return stacks;
    }

    @Override
    @Nullable
    public ItemStack insert(@Nonnull ItemStack stack, int size, Action action) {
        IItemHandler handler = this.handlerSupplier.get();
        if (handler != null && this.context.acceptsItem(stack)) {
            return StackUtils.emptyToNull(ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size), (action == Action.SIMULATE ? 1 : 0) != 0));
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
    }

    @Override
    @Nullable
    public ItemStack extract(@Nonnull ItemStack stack, int size, int flags, Action action) {
        int remaining = size;
        ItemStack received = null;
        IItemHandler handler = this.handlerSupplier.get();
        if (handler == null) {
            return null;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack got;
            ItemStack slot = handler.getStackInSlot(i);
            if (slot.func_190926_b() || !API.instance().getComparer().isEqual(slot, stack, flags) || (got = handler.extractItem(i, remaining, action == Action.SIMULATE)).func_190926_b()) continue;
            if (received == null) {
                received = got.func_77946_l();
            } else {
                received.func_190917_f(got.func_190916_E());
            }
            if ((remaining -= got.func_190916_E()) == 0) break;
        }
        return received;
    }

    @Override
    public int getStored() {
        IItemHandler handler = this.handlerSupplier.get();
        if (handler == null) {
            return 0;
        }
        int size = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            size += handler.getStackInSlot(i).func_190916_E();
        }
        return size;
    }

    @Override
    public int getPriority() {
        return this.context.getPriority();
    }

    @Override
    public AccessType getAccessType() {
        return this.context.getAccessType();
    }

    @Override
    public int getCacheDelta(int storedPreInsertion, int size, @Nullable ItemStack remainder) {
        if (this.getAccessType() == AccessType.INSERT) {
            return 0;
        }
        return remainder == null ? size : size - remainder.func_190916_E();
    }
}

