/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.google.common.base.Optional;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingManager;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.tile.craftingmonitor.ICraftingMonitor;
import com.raoulvdberge.refinedstorage.tile.craftingmonitor.TileCraftingMonitor;
import com.raoulvdberge.refinedstorage.tile.data.TileDataManager;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NetworkNodeCraftingMonitor
extends NetworkNode
implements ICraftingMonitor {
    public static final String ID = "crafting_monitor";
    private static final String NBT_SIZE = "Size";
    private static final String NBT_TAB_SELECTED = "TabSelected";
    private static final String NBT_TAB_PAGE = "TabPage";
    private int size = 0;
    private Optional<UUID> tabSelected = Optional.absent();
    private int tabPage;

    public NetworkNodeCraftingMonitor(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getSize() {
        return this.world.field_72995_K ? TileCraftingMonitor.SIZE.getValue() : this.size;
    }

    @Override
    public void onSizeChanged(int size) {
        TileDataManager.setParameter(TileCraftingMonitor.SIZE, size);
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.craftingMonitorUsage;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    @Override
    public String getGuiTitle() {
        return "gui.refinedstorage:crafting_monitor";
    }

    @Override
    public void onCancelled(EntityPlayerMP player, @Nullable UUID id) {
        if (this.network != null) {
            this.network.getItemGridHandler().onCraftingCancelRequested(player, id);
        }
    }

    @Override
    public TileDataParameter<Integer, ?> getRedstoneModeParameter() {
        return TileCraftingMonitor.REDSTONE_MODE;
    }

    @Override
    public Collection<ICraftingTask> getTasks() {
        return this.network != null ? this.network.getCraftingManager().getTasks() : Collections.emptyList();
    }

    @Override
    @Nullable
    public ICraftingManager getCraftingManager() {
        return this.network != null ? this.network.getCraftingManager() : null;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_SIZE, this.size);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_SIZE)) {
            this.size = tag.func_74762_e(NBT_SIZE);
        }
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        tag.func_74768_a(NBT_TAB_PAGE, this.tabPage);
        if (this.tabSelected.isPresent()) {
            tag.func_186854_a(NBT_TAB_SELECTED, (UUID)this.tabSelected.get());
        }
        return tag;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_74764_b(NBT_TAB_PAGE)) {
            this.tabPage = tag.func_74762_e(NBT_TAB_PAGE);
        }
        if (tag.func_186855_b(NBT_TAB_SELECTED)) {
            this.tabSelected = Optional.of((Object)tag.func_186857_a(NBT_TAB_SELECTED));
        }
    }

    public void setTabSelected(Optional<UUID> tabSelected) {
        this.tabSelected = tabSelected;
    }

    public void setTabPage(int tabPage) {
        this.tabPage = tabPage;
    }

    @Override
    public void onClosed(EntityPlayer player) {
    }

    @Override
    public Optional<UUID> getTabSelected() {
        return this.world.field_72995_K ? TileCraftingMonitor.TAB_SELECTED.getValue() : this.tabSelected;
    }

    @Override
    public int getTabPage() {
        return this.world.field_72995_K ? TileCraftingMonitor.TAB_PAGE.getValue() : this.tabPage;
    }

    @Override
    public void onTabSelectionChanged(Optional<UUID> tab) {
        TileDataManager.setParameter(TileCraftingMonitor.TAB_SELECTED, tab);
    }

    @Override
    public void onTabPageChanged(int page) {
        if (page >= 0) {
            TileDataManager.setParameter(TileCraftingMonitor.TAB_PAGE, page);
        }
    }
}

