/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.step;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.extractor.CraftingExtractor;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.extractor.CraftingExtractorStack;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.step.CraftingStep;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;

public class CraftingStepProcess
extends CraftingStep {
    public static final String TYPE = "process";
    private static final String NBT_EXTRACTOR = "Extractor";
    private static final String NBT_TO_RECEIVE = "ToReceive";
    private static final String NBT_TO_RECEIVE_FLUIDS = "ToReceiveFluids";
    private CraftingExtractor extractor;
    private IStackList<ItemStack> itemsToReceive = API.instance().createItemStackList();
    private IStackList<FluidStack> fluidsToReceive = API.instance().createFluidStackList();

    public CraftingStepProcess(ICraftingPattern pattern, INetwork network, List<ItemStack> toExtract, List<FluidStack> fluidsToExtract) {
        super(pattern);
        if (!pattern.isProcessing()) {
            throw new IllegalArgumentException("Cannot pass non-processing pattern to processing handler");
        }
        ArrayList<CraftingExtractorStack> stacks = new ArrayList<CraftingExtractorStack>();
        for (ItemStack item : toExtract) {
            stacks.add(new CraftingExtractorStack(item));
        }
        for (FluidStack fluid : fluidsToExtract) {
            stacks.add(new CraftingExtractorStack(fluid));
        }
        this.extractor = new CraftingExtractor(network, stacks, true);
        for (ItemStack output : pattern.getOutputs()) {
            this.itemsToReceive.add(output);
        }
        for (ItemStack output : pattern.getFluidOutputs()) {
            this.fluidsToReceive.add((FluidStack)output);
        }
    }

    public CraftingStepProcess(ICraftingPattern pattern, INetwork network, NBTTagCompound tag) throws CraftingTaskReadException {
        super(pattern);
        if (!pattern.isProcessing()) {
            throw new IllegalArgumentException("Cannot pass non-processing pattern to processing handler");
        }
        this.extractor = new CraftingExtractor(network, tag.func_150295_c(NBT_EXTRACTOR, 10), true);
        NBTTagList toReceiveList = tag.func_150295_c(NBT_TO_RECEIVE, 10);
        for (int i = 0; i < toReceiveList.func_74745_c(); ++i) {
            ItemStack toReceive = StackUtils.deserializeStackFromNbt(toReceiveList.func_150305_b(i));
            if (toReceive.func_190926_b()) {
                throw new CraftingTaskReadException("Item to receive is empty");
            }
            this.itemsToReceive.add(toReceive);
        }
        NBTTagList toReceiveFluidsList = tag.func_150295_c(NBT_TO_RECEIVE_FLUIDS, 10);
        for (int i = 0; i < toReceiveFluidsList.func_74745_c(); ++i) {
            FluidStack toReceive = FluidStack.loadFluidStackFromNBT((NBTTagCompound)toReceiveFluidsList.func_150305_b(i));
            if (toReceive == null) {
                throw new CraftingTaskReadException("Fluid to receive is null");
            }
            this.fluidsToReceive.add(toReceive);
        }
    }

    @Override
    public boolean canExecute() {
        this.extractor.updateStatus(this.pattern.getContainer().getConnectedInventory(), this.pattern.getContainer().getConnectedFluidInventory());
        return this.extractor.isAllAvailable();
    }

    public int onTrackedItemInserted(ItemStack stack, int size) {
        if (!this.extractor.isAllExtracted()) {
            return size;
        }
        ItemStack inList = this.itemsToReceive.get(stack);
        if (inList == null) {
            return size;
        }
        int toExtract = Math.min(size, inList.func_190916_E());
        this.itemsToReceive.remove(stack, toExtract);
        return size - toExtract;
    }

    public int onTrackedFluidInserted(FluidStack stack, int size) {
        if (!this.extractor.isAllExtracted()) {
            return size;
        }
        FluidStack inList = this.fluidsToReceive.get(stack);
        if (inList == null) {
            return size;
        }
        int toExtract = Math.min(size, inList.amount);
        this.fluidsToReceive.remove(stack, toExtract);
        return size - toExtract;
    }

    @Override
    public boolean execute() {
        if (!this.extractor.isAllExtracted()) {
            this.extractor.extractOne(this.pattern.getContainer().getConnectedInventory(), this.pattern.getContainer().getConnectedFluidInventory());
        }
        return this.extractor.isAllExtracted() && this.itemsToReceive.isEmpty() && this.fluidsToReceive.isEmpty();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound tag = super.writeToNbt();
        tag.func_74782_a(NBT_EXTRACTOR, (NBTBase)this.extractor.writeToNbt());
        NBTTagList toReceive = new NBTTagList();
        for (ItemStack toReceiveStack : this.itemsToReceive.getStacks()) {
            toReceive.func_74742_a((NBTBase)StackUtils.serializeStackToNbt(toReceiveStack));
        }
        tag.func_74782_a(NBT_TO_RECEIVE, (NBTBase)toReceive);
        NBTTagList toReceiveFluids = new NBTTagList();
        for (FluidStack toReceiveStack : this.fluidsToReceive.getStacks()) {
            toReceiveFluids.func_74742_a((NBTBase)toReceiveStack.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a(NBT_TO_RECEIVE_FLUIDS, (NBTBase)toReceiveFluids);
        return tag;
    }

    public CraftingExtractor getExtractor() {
        return this.extractor;
    }
}

