/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.inserter;

import com.raoulvdberge.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.inserter.CraftingInserterItem;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.inserter.CraftingInserterItemStatus;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class CraftingInserter {
    private static final String NBT_ITEM = "Item";
    private static final String NBT_STATUS = "Status";
    private INetwork network;
    private Deque<CraftingInserterItem> items = new ArrayDeque<CraftingInserterItem>();

    public CraftingInserter(INetwork network) {
        this.network = network;
    }

    public CraftingInserter(INetwork network, NBTTagList list) throws CraftingTaskReadException {
        this(network);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound itemTag = list.func_150305_b(i);
            ItemStack stack = StackUtils.deserializeStackFromNbt(itemTag.func_74775_l(NBT_ITEM));
            if (stack.func_190926_b()) {
                throw new CraftingTaskReadException("Inserter has empty stack");
            }
            CraftingInserterItemStatus status = CraftingInserterItemStatus.values()[itemTag.func_74762_e(NBT_STATUS)];
            this.items.push(new CraftingInserterItem(stack, status));
        }
    }

    public void insert(ItemStack stack) {
        this.items.addLast(new CraftingInserterItem(stack, CraftingInserterItemStatus.WAITING));
        this.network.getCraftingManager().onTaskChanged();
    }

    public void insertOne() {
        CraftingInserterItem item = this.items.peekFirst();
        if (item != null) {
            CraftingInserterItemStatus currentStatus = item.getStatus();
            if (this.network.insertItem(item.getStack(), item.getStack().func_190916_E(), Action.SIMULATE) == null) {
                ItemStack inserted = this.network.insertItem(item.getStack(), item.getStack().func_190916_E(), Action.PERFORM);
                if (inserted != null) {
                    throw new IllegalStateException("Could not insert item");
                }
                this.items.pop();
                this.network.getCraftingManager().onTaskChanged();
            } else if (currentStatus != CraftingInserterItemStatus.FULL) {
                item.setStatus(CraftingInserterItemStatus.FULL);
                this.network.getCraftingManager().onTaskChanged();
            }
        }
    }

    public void insertAll() {
        while (!this.items.isEmpty()) {
            CraftingInserterItem item = this.items.pop();
            this.network.insertItem(item.getStack(), item.getStack().func_190916_E(), Action.PERFORM);
        }
        this.network.getCraftingManager().onTaskChanged();
    }

    public Collection<CraftingInserterItem> getItems() {
        return this.items;
    }

    public NBTTagList writeToNbt() {
        NBTTagList list = new NBTTagList();
        for (CraftingInserterItem item : this.items) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a(NBT_ITEM, (NBTBase)StackUtils.serializeStackToNbt(item.getStack()));
            tag.func_74768_a(NBT_STATUS, item.getStatus().ordinal());
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }
}

