/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternChain;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternChainList;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElementList;
import com.raoulvdberge.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.CraftingTaskErrorType;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingRequestInfo;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTaskError;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementColor;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementFluidRender;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementItemRender;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor.CraftingMonitorElementText;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.CraftingPreviewElementFluidStack;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.CraftingPreviewElementItemStack;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.CraftingTaskError;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.extractor.CraftingExtractor;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.extractor.CraftingExtractorStack;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.extractor.CraftingExtractorStatus;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.inserter.CraftingInserter;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.inserter.CraftingInserterItem;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.inserter.CraftingInserterItemStatus;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.step.CraftingStep;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.step.CraftingStepCraft;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.step.CraftingStepProcess;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class CraftingTask
implements ICraftingTask {
    private static final long CALCULATION_TIMEOUT_MS = 5000L;
    private static final String NBT_REQUESTED = "Requested";
    private static final String NBT_QUANTITY = "Quantity";
    private static final String NBT_PATTERN = "Pattern";
    private static final String NBT_STEPS = "Steps";
    private static final String NBT_INSERTER = "Inserter";
    private static final String NBT_TICKS = "Ticks";
    private static final String NBT_ID = "Id";
    private static final String NBT_MISSING = "Missing";
    private static final String NBT_EXECUTION_STARTED = "ExecutionStarted";
    private static final String NBT_PATTERN_STACK = "Stack";
    private static final String NBT_PATTERN_CONTAINER_POS = "ContainerPos";
    private INetwork network;
    private ICraftingRequestInfo requested;
    private int quantity;
    private ICraftingPattern pattern;
    private List<CraftingStep> steps = new LinkedList<CraftingStep>();
    private CraftingInserter inserter;
    private Set<ICraftingPattern> patternsUsed = new HashSet<ICraftingPattern>();
    private int ticks = 0;
    private long calculationStarted = -1L;
    private long executionStarted = -1L;
    private UUID id = UUID.randomUUID();
    private IStackList<ItemStack> toTake = API.instance().createItemStackList();
    private IStackList<FluidStack> toTakeFluids = API.instance().createFluidStackList();
    private IStackList<ItemStack> missing = API.instance().createItemStackList();
    private IStackList<FluidStack> missingFluids = API.instance().createFluidStackList();
    private IStackList<ItemStack> toCraft = API.instance().createItemStackList();
    private IStackList<FluidStack> toCraftFluids = API.instance().createFluidStackList();

    public CraftingTask(INetwork network, ICraftingRequestInfo requested, int quantity, ICraftingPattern pattern) {
        this.network = network;
        this.inserter = new CraftingInserter(network);
        this.requested = requested;
        this.quantity = quantity;
        this.pattern = pattern;
    }

    public CraftingTask(INetwork network, NBTTagCompound tag) throws CraftingTaskReadException {
        this.network = network;
        this.requested = API.instance().createCraftingRequestInfo(tag.func_74775_l(NBT_REQUESTED));
        this.quantity = tag.func_74762_e(NBT_QUANTITY);
        this.pattern = CraftingTask.readPatternFromNbt(tag.func_74775_l(NBT_PATTERN), network.world());
        this.inserter = new CraftingInserter(network, tag.func_150295_c(NBT_INSERTER, 10));
        this.ticks = tag.func_74762_e(NBT_TICKS);
        this.id = tag.func_186857_a(NBT_ID);
        NBTTagList steps = tag.func_150295_c(NBT_STEPS, 10);
        for (int i = 0; i < steps.func_74745_c(); ++i) {
            NBTTagCompound stepTag = steps.func_150305_b(i);
            this.steps.add(CraftingStep.readFromNbt(network, this.inserter, stepTag));
        }
        NBTTagList missing = tag.func_150295_c(NBT_MISSING, 10);
        for (int i = 0; i < missing.func_74745_c(); ++i) {
            ItemStack missingItem = StackUtils.deserializeStackFromNbt(missing.func_150305_b(i));
            if (missingItem.func_190926_b()) {
                throw new CraftingTaskReadException("Missing item is empty");
            }
            this.missing.add(missingItem);
        }
        if (tag.func_74764_b(NBT_EXECUTION_STARTED)) {
            this.executionStarted = tag.func_74763_f(NBT_EXECUTION_STARTED);
        }
    }

    @Override
    @Nullable
    public ICraftingTaskError calculate() {
        if (this.calculationStarted != -1L) {
            throw new IllegalStateException("Task already calculated!");
        }
        if (this.executionStarted != -1L) {
            throw new IllegalStateException("Task already started!");
        }
        this.calculationStarted = System.currentTimeMillis();
        int qty = this.quantity;
        int qtyPerCraft = this.getQuantityPerCraft();
        int crafted = 0;
        IStackList<ItemStack> results = API.instance().createItemStackList();
        IStackList<FluidStack> fluidResults = API.instance().createFluidStackList();
        IStackList<ItemStack> storage = this.network.getItemStorageCache().getList().copy();
        IStackList<FluidStack> fluidStorage = this.network.getFluidStorageCache().getList().copy();
        for (ICraftingTask task : this.network.getCraftingManager().getTasks()) {
            if (!(task instanceof CraftingTask)) continue;
            for (CraftingStep step : ((CraftingTask)task).steps) {
                CraftingExtractor extractor = null;
                if (step instanceof CraftingStepCraft) {
                    extractor = ((CraftingStepCraft)step).getExtractor();
                } else if (step instanceof CraftingStepProcess) {
                    extractor = ((CraftingStepProcess)step).getExtractor();
                }
                if (extractor == null) continue;
                for (CraftingExtractorStack inUse : extractor.getStacks()) {
                    ItemStack inUseItem = inUse.getItem();
                    if (inUseItem != null) {
                        storage.remove(inUseItem);
                        continue;
                    }
                    FluidStack inUseFluid = inUse.getFluid();
                    if (inUseFluid != null) {
                        fluidStorage.remove(inUseFluid);
                        continue;
                    }
                    throw new IllegalStateException("Extractor stack is neither a fluid or an item!");
                }
            }
        }
        ICraftingPatternChainList patternChainList = this.network.getCraftingManager().createPatternChainList();
        ICraftingPatternChain patternChain = patternChainList.getChain(this.pattern);
        while (qty > 0) {
            Pair<CraftingStep, ICraftingTaskError> result = this.calculateInternal(storage, fluidStorage, results, fluidResults, patternChainList, patternChain.current());
            if (result.getRight() != null) {
                return (ICraftingTaskError)result.getRight();
            }
            this.steps.add((CraftingStep)result.getLeft());
            qty -= qtyPerCraft;
            crafted += qtyPerCraft;
            patternChain.cycle();
        }
        if (this.requested.getItem() != null) {
            this.toCraft.add(this.requested.getItem(), crafted);
        } else {
            this.toCraftFluids.add(this.requested.getFluid(), crafted);
        }
        return null;
    }

    private Pair<CraftingStep, ICraftingTaskError> calculateInternal(IStackList<ItemStack> mutatedStorage, IStackList<FluidStack> mutatedFluidStorage, IStackList<ItemStack> results, IStackList<FluidStack> fluidResults, ICraftingPatternChainList patternChainList, ICraftingPattern pattern) {
        if (System.currentTimeMillis() - this.calculationStarted > 5000L) {
            return Pair.of(null, (Object)new CraftingTaskError(CraftingTaskErrorType.TOO_COMPLEX));
        }
        if (!this.patternsUsed.add(pattern)) {
            return Pair.of(null, (Object)new CraftingTaskError(CraftingTaskErrorType.RECURSIVE, pattern));
        }
        IStackList<ItemStack> itemsToExtract = API.instance().createItemStackList();
        IStackList<FluidStack> fluidsToExtract = API.instance().createFluidStackList();
        NonNullList took = NonNullList.func_191196_a();
        for (NonNullList<ItemStack> possibleInputs : pattern.getInputs()) {
            ItemStack possibleInput;
            if (possibleInputs.isEmpty()) {
                took.add((Object)ItemStack.field_190927_a);
                continue;
            }
            if (possibleInputs.size() == 1) {
                possibleInput = (ItemStack)possibleInputs.get(0);
            } else {
                NonNullList sortedPossibleInputs = NonNullList.func_191196_a();
                sortedPossibleInputs.addAll(possibleInputs);
                sortedPossibleInputs.sort((a, b) -> {
                    ItemStack ar = mutatedStorage.get((ItemStack)a);
                    ItemStack br = mutatedStorage.get((ItemStack)b);
                    return (br == null ? 0 : br.func_190916_E()) - (ar == null ? 0 : ar.func_190916_E());
                });
                sortedPossibleInputs.sort((a, b) -> {
                    ItemStack ar = results.get((ItemStack)a);
                    ItemStack br = results.get((ItemStack)b);
                    return (br == null ? 0 : br.func_190916_E()) - (ar == null ? 0 : ar.func_190916_E());
                });
                possibleInput = (ItemStack)sortedPossibleInputs.get(0);
            }
            took.add((Object)possibleInput);
            int flags = CraftingTask.getFlags(possibleInput);
            ItemStack fromSelf = results.get(possibleInput, flags);
            ItemStack fromNetwork = mutatedStorage.get(possibleInput, flags);
            int remaining = possibleInput.func_190916_E();
            while (remaining > 0) {
                if (fromSelf != null) {
                    int toTake = Math.min(remaining, fromSelf.func_190916_E());
                    itemsToExtract.add(possibleInput, toTake);
                    results.remove(fromSelf, toTake);
                    remaining -= toTake;
                    took.set(took.size() - 1, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)fromSelf, (int)possibleInput.func_190916_E()));
                    fromSelf = results.get(possibleInput, flags);
                    continue;
                }
                if (fromNetwork != null) {
                    int toTake = Math.min(remaining, fromNetwork.func_190916_E());
                    this.toTake.add(possibleInput, toTake);
                    itemsToExtract.add(possibleInput, toTake);
                    mutatedStorage.remove(fromNetwork, toTake);
                    remaining -= toTake;
                    took.set(took.size() - 1, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)fromNetwork, (int)possibleInput.func_190916_E()));
                    fromNetwork = mutatedStorage.get(possibleInput, flags);
                    continue;
                }
                ICraftingPattern subPattern = this.network.getCraftingManager().getPattern(possibleInput);
                if (subPattern != null) {
                    ICraftingPatternChain subPatternChain = patternChainList.getChain(subPattern);
                    while ((fromSelf == null ? 0 : fromSelf.func_190916_E()) < remaining) {
                        Pair<CraftingStep, ICraftingTaskError> result = this.calculateInternal(mutatedStorage, mutatedFluidStorage, results, fluidResults, patternChainList, subPatternChain.current());
                        if (result.getRight() != null) {
                            return Pair.of(null, (Object)result.getRight());
                        }
                        this.steps.add((CraftingStep)result.getLeft());
                        fromSelf = results.get(possibleInput, flags);
                        if (fromSelf == null) {
                            throw new IllegalStateException("Recursive calculation didn't yield anything");
                        }
                        fromNetwork = mutatedStorage.get(possibleInput, flags);
                        subPatternChain.cycle();
                    }
                    this.toCraft.add(possibleInput, fromSelf.func_190916_E());
                    continue;
                }
                this.missing.add(possibleInput, remaining);
                itemsToExtract.add(possibleInput, remaining);
                remaining = 0;
            }
        }
        for (FluidStack input : pattern.getFluidInputs()) {
            FluidStack fromSelf = fluidResults.get(input, 2);
            FluidStack fromNetwork = mutatedFluidStorage.get(input, 2);
            int remaining = input.amount;
            while (remaining > 0) {
                if (fromSelf != null) {
                    int toTake = Math.min(remaining, fromSelf.amount);
                    fluidsToExtract.add(input, toTake);
                    fluidResults.remove(input, toTake);
                    remaining -= toTake;
                    fromSelf = fluidResults.get(input, 2);
                    continue;
                }
                if (fromNetwork != null) {
                    int toTake = Math.min(remaining, fromNetwork.amount);
                    this.toTakeFluids.add(input, toTake);
                    fluidsToExtract.add(input, toTake);
                    mutatedFluidStorage.remove(fromNetwork, toTake);
                    remaining -= toTake;
                    fromNetwork = mutatedFluidStorage.get(input, 2);
                    continue;
                }
                ICraftingPattern subPattern = this.network.getCraftingManager().getPattern(input);
                if (subPattern != null) {
                    ICraftingPatternChain subPatternChain = patternChainList.getChain(subPattern);
                    while ((fromSelf == null ? 0 : fromSelf.amount) < remaining) {
                        Pair<CraftingStep, ICraftingTaskError> result = this.calculateInternal(mutatedStorage, mutatedFluidStorage, results, fluidResults, patternChainList, subPatternChain.current());
                        if (result.getRight() != null) {
                            return Pair.of(null, (Object)result.getRight());
                        }
                        this.steps.add((CraftingStep)result.getLeft());
                        fromSelf = fluidResults.get(input, 2);
                        if (fromSelf == null) {
                            throw new IllegalStateException("Recursive fluid calculation didn't yield anything");
                        }
                        fromNetwork = mutatedFluidStorage.get(input, 2);
                        subPatternChain.cycle();
                    }
                    this.toCraftFluids.add(input, fromSelf.amount);
                    continue;
                }
                this.missingFluids.add(input, remaining);
                fluidsToExtract.add(input, remaining);
                remaining = 0;
            }
        }
        this.patternsUsed.remove(pattern);
        if (pattern.isProcessing()) {
            for (ItemStack output : pattern.getOutputs()) {
                results.add(output);
            }
            for (ItemStack output : pattern.getFluidOutputs()) {
                fluidResults.add((FluidStack)output);
            }
            return Pair.of((Object)new CraftingStepProcess(pattern, this.network, new ArrayList<ItemStack>(itemsToExtract.getStacks()), new ArrayList<FluidStack>(fluidsToExtract.getStacks())), null);
        }
        if (!fluidsToExtract.isEmpty()) {
            throw new IllegalStateException("Cannot extract fluids in normal pattern!");
        }
        results.add(pattern.getOutput((NonNullList<ItemStack>)took));
        for (ItemStack byproduct : pattern.getByproducts((NonNullList<ItemStack>)took)) {
            results.add(byproduct);
        }
        return Pair.of((Object)new CraftingStepCraft(pattern, this.inserter, this.network, new ArrayList<ItemStack>(itemsToExtract.getStacks()), (NonNullList<ItemStack>)took), null);
    }

    @Override
    public int getQuantityPerCraft() {
        int qty = 0;
        if (this.requested.getItem() != null) {
            for (ItemStack output : this.pattern.getOutputs()) {
                if (!API.instance().getComparer().isEqualNoQuantity(output, this.requested.getItem())) continue;
                qty += output.func_190916_E();
                if (this.pattern.isProcessing()) continue;
                break;
            }
        } else {
            for (FluidStack output : this.pattern.getFluidOutputs()) {
                if (!API.instance().getComparer().isEqual(output, this.requested.getFluid(), 2)) continue;
                qty += output.amount;
            }
        }
        return qty;
    }

    @Override
    public boolean update() {
        if (this.executionStarted == -1L) {
            this.executionStarted = System.currentTimeMillis();
        }
        boolean allCompleted = true;
        if (this.ticks % this.getTickInterval(this.pattern.getContainer().getSpeedUpgradeCount()) == 0) {
            this.inserter.insertOne();
        }
        for (CraftingStep step : this.steps) {
            if (step.isCompleted()) continue;
            allCompleted = false;
            if (this.ticks % this.getTickInterval(step.getPattern().getContainer().getSpeedUpgradeCount()) != 0 || !step.canExecute() || !step.execute()) continue;
            step.setCompleted();
            this.network.getCraftingManager().onTaskChanged();
        }
        ++this.ticks;
        return allCompleted && this.inserter.getItems().isEmpty();
    }

    @Override
    public void onCancelled() {
        this.inserter.insertAll();
    }

    @Override
    public int getQuantity() {
        return this.quantity;
    }

    @Override
    public ICraftingRequestInfo getRequested() {
        return this.requested;
    }

    @Override
    public int onTrackedInsert(ItemStack stack, int size) {
        for (CraftingStep step : this.steps) {
            if (step instanceof CraftingStepProcess && (size = ((CraftingStepProcess)step).onTrackedItemInserted(stack, size)) == 0) break;
        }
        return size;
    }

    @Override
    public int onTrackedInsert(FluidStack stack, int size) {
        for (CraftingStep step : this.steps) {
            if (step instanceof CraftingStepProcess && (size = ((CraftingStepProcess)step).onTrackedFluidInserted(stack, size)) == 0) break;
        }
        return size;
    }

    @Override
    public List<ICraftingMonitorElement> getCraftingMonitorElements() {
        CraftingExtractorStack stack;
        int i;
        CraftingExtractor extractor;
        ICraftingMonitorElementList elements = API.instance().createCraftingMonitorElementList();
        if (!this.missing.isEmpty() || !this.missingFluids.isEmpty()) {
            elements.directAdd(new CraftingMonitorElementText("gui.refinedstorage:crafting_monitor.missing", 5));
        }
        if (!this.missing.isEmpty()) {
            for (ItemStack itemStack : this.missing.getStacks()) {
                elements.add(new CraftingMonitorElementColor(new CraftingMonitorElementItemRender(itemStack, itemStack.func_190916_E(), 0), "", -860450));
            }
            elements.commit();
        }
        if (!this.missingFluids.isEmpty()) {
            for (FluidStack fluidStack : this.missingFluids.getStacks()) {
                elements.add(new CraftingMonitorElementColor(new CraftingMonitorElementFluidRender(fluidStack, fluidStack.amount, 0), "", -860450));
            }
            elements.commit();
        }
        if (!this.inserter.getItems().isEmpty()) {
            elements.directAdd(new CraftingMonitorElementText("gui.refinedstorage:crafting_monitor.items_inserting", 5));
            for (CraftingInserterItem craftingInserterItem : this.inserter.getItems()) {
                ICraftingMonitorElement element = new CraftingMonitorElementItemRender(craftingInserterItem.getStack(), craftingInserterItem.getStack().func_190916_E(), 0);
                if (craftingInserterItem.getStatus() == CraftingInserterItemStatus.FULL) {
                    element = new CraftingMonitorElementColor(element, "gui.refinedstorage:crafting_monitor.network_full", -860450);
                }
                elements.add(element);
            }
            elements.commit();
        }
        if (this.steps.stream().anyMatch(s -> s instanceof CraftingStepCraft && !s.isCompleted() && !((CraftingStepCraft)s).getExtractor().getStacks().isEmpty())) {
            elements.directAdd(new CraftingMonitorElementText("gui.refinedstorage:crafting_monitor.items_crafting", 5));
            for (CraftingStep craftingStep : this.steps) {
                if (!(craftingStep instanceof CraftingStepCraft) || craftingStep.isCompleted()) continue;
                extractor = ((CraftingStepCraft)craftingStep).getExtractor();
                for (i = 0; i < extractor.getStacks().size(); ++i) {
                    stack = extractor.getStacks().get(i);
                    ICraftingMonitorElement element = new CraftingMonitorElementItemRender(stack.getItem(), stack.getItem().func_190916_E(), 0);
                    if (stack.getStatus() == CraftingExtractorStatus.MISSING) {
                        element = new CraftingMonitorElementColor(element, "gui.refinedstorage:crafting_monitor.waiting_for_items", -2494985);
                    }
                    elements.add(element);
                }
            }
            elements.commit();
        }
        if (this.steps.stream().anyMatch(s -> s instanceof CraftingStepProcess && !s.isCompleted())) {
            elements.directAdd(new CraftingMonitorElementText("gui.refinedstorage:crafting_monitor.processing", 5));
            for (CraftingStep craftingStep : this.steps) {
                if (!(craftingStep instanceof CraftingStepProcess) || craftingStep.isCompleted()) continue;
                extractor = ((CraftingStepProcess)craftingStep).getExtractor();
                for (i = 0; i < extractor.getStacks().size(); ++i) {
                    stack = extractor.getStacks().get(i);
                    if (stack.getItem() == null) continue;
                    elements.add(this.wrapAccordingToStatus(new CraftingMonitorElementItemRender(stack.getItem(), stack.getItem().func_190916_E(), 0), stack));
                }
            }
            elements.commit();
            for (CraftingStep craftingStep : this.steps) {
                if (!(craftingStep instanceof CraftingStepProcess) || craftingStep.isCompleted()) continue;
                extractor = ((CraftingStepProcess)craftingStep).getExtractor();
                for (i = 0; i < extractor.getStacks().size(); ++i) {
                    stack = extractor.getStacks().get(i);
                    if (stack.getItem() != null) continue;
                    elements.add(this.wrapAccordingToStatus(new CraftingMonitorElementFluidRender(stack.getFluid(), stack.getFluid().amount, 0), stack));
                }
            }
            elements.commit();
        }
        return elements.getElements();
    }

    private ICraftingMonitorElement wrapAccordingToStatus(ICraftingMonitorElement element, CraftingExtractorStack stack) {
        if (stack.getStatus() == CraftingExtractorStatus.MISSING) {
            element = new CraftingMonitorElementColor(element, stack.getFluid() != null ? "gui.refinedstorage:crafting_monitor.waiting_for_fluids" : "gui.refinedstorage:crafting_monitor.waiting_for_items", -2494985);
        } else if (stack.getStatus() == CraftingExtractorStatus.MACHINE_DOES_NOT_ACCEPT) {
            element = new CraftingMonitorElementColor(element, stack.getFluid() != null ? "gui.refinedstorage:crafting_monitor.machine_does_not_accept_fluid" : "gui.refinedstorage:crafting_monitor.machine_does_not_accept_item", -860450);
        } else if (stack.getStatus() == CraftingExtractorStatus.MACHINE_NONE) {
            element = new CraftingMonitorElementColor(element, "gui.refinedstorage:crafting_monitor.machine_none", -860450);
        } else if (stack.getStatus() == CraftingExtractorStatus.EXTRACTED) {
            element = new CraftingMonitorElementColor(element, "gui.refinedstorage:crafting_monitor.inserted_into_machine", -5383226);
        }
        return element;
    }

    @Override
    public List<ICraftingPreviewElement> getPreviewStacks() {
        ICraftingPreviewElement<ItemStack> previewStack;
        int hash;
        LinkedHashMap<Integer, ICraftingPreviewElement<ItemStack>> map = new LinkedHashMap<Integer, ICraftingPreviewElement<ItemStack>>();
        LinkedHashMap<Integer, ICraftingPreviewElement<ItemStack>> mapFluids = new LinkedHashMap<Integer, ICraftingPreviewElement<ItemStack>>();
        for (ItemStack itemStack : this.toCraft.getStacks()) {
            hash = API.instance().getItemStackHashCode(itemStack);
            previewStack = (CraftingPreviewElementItemStack)map.get(hash);
            if (previewStack == null) {
                previewStack = new CraftingPreviewElementItemStack(itemStack);
            }
            ((CraftingPreviewElementItemStack)previewStack).addToCraft(itemStack.func_190916_E());
            map.put(hash, previewStack);
        }
        for (FluidStack fluidStack : this.toCraftFluids.getStacks()) {
            hash = API.instance().getFluidStackHashCode(fluidStack);
            previewStack = (CraftingPreviewElementFluidStack)mapFluids.get(hash);
            if (previewStack == null) {
                previewStack = new CraftingPreviewElementFluidStack(fluidStack);
            }
            ((CraftingPreviewElementFluidStack)previewStack).addToCraft(fluidStack.amount);
            mapFluids.put(hash, previewStack);
        }
        for (ItemStack itemStack : this.missing.getStacks()) {
            hash = API.instance().getItemStackHashCode(itemStack);
            previewStack = (CraftingPreviewElementItemStack)map.get(hash);
            if (previewStack == null) {
                previewStack = new CraftingPreviewElementItemStack(itemStack);
            }
            ((CraftingPreviewElementItemStack)previewStack).setMissing(true);
            ((CraftingPreviewElementItemStack)previewStack).addToCraft(itemStack.func_190916_E());
            map.put(hash, previewStack);
        }
        for (FluidStack fluidStack : this.missingFluids.getStacks()) {
            hash = API.instance().getFluidStackHashCode(fluidStack);
            previewStack = (CraftingPreviewElementFluidStack)mapFluids.get(hash);
            if (previewStack == null) {
                previewStack = new CraftingPreviewElementFluidStack(fluidStack);
            }
            ((CraftingPreviewElementFluidStack)previewStack).setMissing(true);
            ((CraftingPreviewElementFluidStack)previewStack).addToCraft(fluidStack.amount);
            mapFluids.put(hash, previewStack);
        }
        for (ItemStack itemStack : this.toTake.getStacks()) {
            hash = API.instance().getItemStackHashCode(itemStack);
            previewStack = (CraftingPreviewElementItemStack)map.get(hash);
            if (previewStack == null) {
                previewStack = new CraftingPreviewElementItemStack(itemStack);
            }
            ((CraftingPreviewElementItemStack)previewStack).addAvailable(itemStack.func_190916_E());
            map.put(hash, previewStack);
        }
        for (FluidStack fluidStack : this.toTakeFluids.getStacks()) {
            hash = API.instance().getFluidStackHashCode(fluidStack);
            previewStack = (CraftingPreviewElementFluidStack)mapFluids.get(hash);
            if (previewStack == null) {
                previewStack = new CraftingPreviewElementFluidStack(fluidStack);
            }
            ((CraftingPreviewElementFluidStack)previewStack).addAvailable(fluidStack.amount);
            mapFluids.put(hash, previewStack);
        }
        ArrayList<ICraftingPreviewElement> elements = new ArrayList<ICraftingPreviewElement>();
        elements.addAll(map.values());
        elements.addAll(mapFluids.values());
        return elements;
    }

    @Override
    public ICraftingPattern getPattern() {
        return this.pattern;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public long getExecutionStarted() {
        return this.executionStarted;
    }

    @Override
    public IStackList<ItemStack> getMissing() {
        return this.missing;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public NBTTagCompound writeToNbt(NBTTagCompound tag) {
        tag.func_74782_a(NBT_REQUESTED, (NBTBase)this.requested.writeToNbt());
        tag.func_74768_a(NBT_QUANTITY, this.quantity);
        tag.func_74782_a(NBT_PATTERN, (NBTBase)CraftingTask.writePatternToNbt(this.pattern));
        tag.func_74782_a(NBT_INSERTER, (NBTBase)this.inserter.writeToNbt());
        tag.func_74768_a(NBT_TICKS, this.ticks);
        tag.func_186854_a(NBT_ID, this.id);
        tag.func_74772_a(NBT_EXECUTION_STARTED, this.executionStarted);
        NBTTagList steps = new NBTTagList();
        for (CraftingStep step : this.steps) {
            steps.func_74742_a((NBTBase)step.writeToNbt());
        }
        tag.func_74782_a(NBT_STEPS, (NBTBase)steps);
        NBTTagList missing = new NBTTagList();
        for (ItemStack missingItem : this.missing.getStacks()) {
            missing.func_74742_a((NBTBase)StackUtils.serializeStackToNbt(missingItem));
        }
        tag.func_74782_a(NBT_MISSING, (NBTBase)missing);
        return tag;
    }

    private int getTickInterval(int speedUpgrades) {
        switch (speedUpgrades) {
            case 0: {
                return 10;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 2;
            }
        }
        return 2;
    }

    public static NBTTagCompound writePatternToNbt(ICraftingPattern pattern) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a(NBT_PATTERN_STACK, (NBTBase)pattern.getStack().serializeNBT());
        tag.func_74772_a(NBT_PATTERN_CONTAINER_POS, pattern.getContainer().getPosition().func_177986_g());
        return tag;
    }

    public static ICraftingPattern readPatternFromNbt(NBTTagCompound tag, World world) throws CraftingTaskReadException {
        BlockPos containerPos = BlockPos.func_177969_a((long)tag.func_74763_f(NBT_PATTERN_CONTAINER_POS));
        INetworkNode node = API.instance().getNetworkNodeManager(world).getNode(containerPos);
        if (node instanceof ICraftingPatternContainer) {
            ItemStack stack = new ItemStack(tag.func_74775_l(NBT_PATTERN_STACK));
            if (stack.func_77973_b() instanceof ICraftingPatternProvider) {
                return ((ICraftingPatternProvider)stack.func_77973_b()).create(world, stack, (ICraftingPatternContainer)((Object)node));
            }
            throw new CraftingTaskReadException("Pattern stack is not a crafting pattern provider");
        }
        throw new CraftingTaskReadException("Crafting pattern container doesn't exist anymore");
    }

    public static int getFlags(ItemStack stack) {
        if (stack.func_77973_b().func_77645_m()) {
            return 2;
        }
        return 3;
    }
}

