/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor;

import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawers;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class CraftingMonitorElementColor
implements ICraftingMonitorElement {
    public static final int COLOR_INFO = -2494985;
    public static final int COLOR_ERROR = -860450;
    public static final int COLOR_SUCCESS = -5383226;
    public static final String ID = "color";
    private ICraftingMonitorElement base;
    private String tooltip;
    private int color;
    private int darkenedColor;

    public CraftingMonitorElementColor(ICraftingMonitorElement base, @Nullable String tooltip, int color) {
        this.base = base;
        this.tooltip = tooltip;
        this.color = color;
        float ratio = 0.9f;
        int a = color >> 24 & 0xFF;
        int r = (int)((float)(color >> 16 & 0xFF) * ratio);
        int g = (int)((float)(color >> 8 & 0xFF) * ratio);
        int b = (int)((float)(color & 0xFF) * ratio);
        this.darkenedColor = a << 24 | r << 16 | g << 8 | b;
    }

    @Override
    public void draw(int x, int y, IElementDrawers drawers, boolean selected) {
        drawers.getOverlayDrawer().draw(x, y, selected ? this.darkenedColor : this.color);
        this.base.draw(x, y, drawers, false);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    @Nullable
    public String getTooltip() {
        return this.tooltip;
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeInt(this.color);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.base.getId());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.tooltip);
        this.base.write(buf);
    }

    @Override
    public boolean merge(ICraftingMonitorElement element) {
        return element.getId().equals(this.getId()) && this.elementHashCode() == element.elementHashCode() && this.base.merge(((CraftingMonitorElementColor)element).base);
    }

    @Override
    public int elementHashCode() {
        return this.base.elementHashCode() ^ this.tooltip.hashCode() ^ this.color;
    }
}

