/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.sync;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import sonar.core.sync.ISonarValue;
import sonar.core.sync.IValueWatcher;
import sonar.core.utils.SimpleObservableList;

public class SonarControlledList<V>
implements ISonarValue<List<V>>,
SimpleObservableList.IListWatcher<V> {
    public final Class<V> type;
    public final IValueWatcher watcher;
    public SimpleObservableList<V> value = new SimpleObservableList();
    public boolean isDirty;

    public SonarControlledList(Class<V> type, IValueWatcher watcher, List<V> value) {
        this.type = type;
        this.watcher = watcher;
        this.watcher.addSyncValue(this);
        this.setValueInternal(value);
        this.addWatcher(this);
    }

    public final void addWatcher(SimpleObservableList.IListWatcher<V> listener) {
        this.value.addWatcher(listener);
    }

    public final void removeWatcher(SimpleObservableList.IListWatcher<V> listener) {
        this.value.removeWatcher(listener);
    }

    @Override
    public List<V> getValue() {
        return this.value;
    }

    @Override
    public boolean setValueInternal(List<V> set) {
        this.value.addAll((Collection<V>)set);
        return true;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    @Override
    public void onElementAdded(@Nullable V added) {
        this.setDirty(true);
    }

    @Override
    public void onElementRemoved(@Nullable V added) {
        this.setDirty(true);
    }

    @Override
    public void onListChanged() {
        this.setDirty(true);
    }
}

