/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.tileentity;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.item.ItemStack;
import sonar.core.api.inventories.ISonarInventory;
import sonar.core.api.inventories.ISonarInventoryTile;
import sonar.core.common.tileentity.TileEntityEnergy;
import sonar.core.handlers.energy.DischargeValues;
import sonar.core.handlers.energy.EnergyTransferHandler;
import sonar.core.handlers.energy.IEnergyHandler;
import sonar.core.handlers.inventories.SonarInventoryTile;

public class TileEntityEnergyInventory
extends TileEntityEnergy
implements ISonarInventoryTile {
    public int CHARGING_RATE;
    public final SonarInventoryTile inv = new SonarInventoryTile(this);

    public TileEntityEnergyInventory() {
        this.syncList.addPart(this.inv);
    }

    @Override
    public ISonarInventory inv() {
        return this.inv;
    }

    public List<ItemStack> slots() {
        return this.inv.slots();
    }

    public void charge(int id) {
        long maxTransfer = this.CHARGING_RATE != 0 ? Math.min((long)this.CHARGING_RATE, this.getStorage().getMaxReceive()) : this.getStorage().getMaxReceive();
        EnergyTransferHandler.INSTANCE_SC.chargeItem(Lists.newArrayList((Object[])new IEnergyHandler[]{this.storage.getInternalWrapper()}), this.slots().get(id), maxTransfer);
    }

    public void discharge(int id) {
        int value;
        long maxTransfer = this.CHARGING_RATE != 0 ? Math.min((long)this.CHARGING_RATE, this.getStorage().getMaxExtract()) : this.getStorage().getMaxExtract();
        long transferred = EnergyTransferHandler.INSTANCE_SC.dischargeItem(Lists.newArrayList((Object[])new IEnergyHandler[]{this.storage.getInternalWrapper()}), this.slots().get(id), maxTransfer);
        if (transferred == 0L && (value = DischargeValues.getValueOf(this.slots().get(id))) > 0 && this.storage.getEnergyStored() + value <= this.storage.getMaxEnergyStored()) {
            this.storage.setEnergyStored(value + this.storage.getEnergyStored());
            this.slots().get(id).func_190918_g(1);
        }
    }
}

