/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.data;

import com.feed_the_beast.ftblib.events.team.ForgeTeamConfigEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamDataEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamDeletedEvent;
import com.feed_the_beast.ftblib.lib.EnumTeamStatus;
import com.feed_the_beast.ftblib.lib.config.ConfigBoolean;
import com.feed_the_beast.ftblib.lib.config.ConfigEnum;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.TeamData;
import com.feed_the_beast.ftblib.lib.math.ChunkDimPos;
import com.feed_the_beast.ftbutilities.FTBUtilitiesPermissions;
import com.feed_the_beast.ftbutilities.data.ClaimedChunk;
import com.feed_the_beast.ftbutilities.data.ClaimedChunks;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.OptionalInt;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="ftbutilities")
public class FTBUtilitiesTeamData
extends TeamData {
    private final ConfigEnum<EnumTeamStatus> editBlocks = new ConfigEnum(EnumTeamStatus.NAME_MAP_PERMS);
    private final ConfigEnum<EnumTeamStatus> interactWithBlocks = new ConfigEnum(EnumTeamStatus.NAME_MAP_PERMS);
    private final ConfigEnum<EnumTeamStatus> attackEntities = new ConfigEnum(EnumTeamStatus.NAME_MAP_PERMS);
    private final ConfigEnum<EnumTeamStatus> useItems = new ConfigEnum(EnumTeamStatus.NAME_MAP_PERMS);
    private final ConfigBoolean explosions = new ConfigBoolean(false);
    public boolean canForceChunks = false;
    private int cachedMaxClaimChunks;
    private int cachedMaxChunkloaderChunks;

    public static FTBUtilitiesTeamData get(ForgeTeam team) {
        return (FTBUtilitiesTeamData)team.getData().get("ftbutilities");
    }

    @SubscribeEvent
    public static void registerTeamData(ForgeTeamDataEvent event) {
        event.register((TeamData)new FTBUtilitiesTeamData(event.getTeam()));
    }

    @SubscribeEvent
    public static void getTeamSettings(ForgeTeamConfigEvent event) {
        FTBUtilitiesTeamData.get(event.getTeam()).addConfig(event.getConfig());
    }

    @SubscribeEvent
    public static void onTeamDeleted(ForgeTeamDeletedEvent event) {
        if (ClaimedChunks.isActive()) {
            ClaimedChunks.instance.unclaimAllChunks(event.getTeam(), OptionalInt.empty());
        }
    }

    private FTBUtilitiesTeamData(ForgeTeam t) {
        super(t);
    }

    public String func_176610_l() {
        return "ftbutilities";
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("Explosions", this.explosions.getBoolean());
        nbt.func_74778_a("EditBlocks", this.editBlocks.getString());
        nbt.func_74778_a("InteractWithBlocks", this.interactWithBlocks.getString());
        nbt.func_74778_a("AttackEntities", this.attackEntities.getString());
        nbt.func_74778_a("UseItems", this.useItems.getString());
        if (ClaimedChunks.isActive()) {
            Int2ObjectOpenHashMap claimedChunks = new Int2ObjectOpenHashMap();
            for (ClaimedChunk chunk : ClaimedChunks.instance.getTeamChunks(this.team, OptionalInt.empty())) {
                ChunkDimPos pos = chunk.getPos();
                NBTTagList list = (NBTTagList)claimedChunks.get(pos.dim);
                if (list == null) {
                    list = new NBTTagList();
                    claimedChunks.put(pos.dim, (Object)list);
                }
                NBTTagCompound chunkNBT = new NBTTagCompound();
                chunkNBT.func_74768_a("x", pos.posX);
                chunkNBT.func_74768_a("z", pos.posZ);
                if (chunk.isLoaded()) {
                    chunkNBT.func_74757_a("loaded", true);
                }
                list.func_74742_a((NBTBase)chunkNBT);
            }
            NBTTagCompound claimedChunksTag = new NBTTagCompound();
            for (Map.Entry entry : claimedChunks.entrySet()) {
                claimedChunksTag.func_74782_a(((Integer)entry.getKey()).toString(), (NBTBase)entry.getValue());
            }
            if (!claimedChunksTag.func_82582_d()) {
                nbt.func_74782_a("ClaimedChunks", (NBTBase)claimedChunksTag);
            }
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.explosions.setBoolean(nbt.func_74767_n("Explosions"));
        this.editBlocks.setValue(nbt.func_74779_i("EditBlocks"));
        this.interactWithBlocks.setValue(nbt.func_74779_i("InteractWithBlocks"));
        this.attackEntities.setValue(nbt.func_74779_i("AttackEntities"));
        this.useItems.setValue(nbt.func_74779_i("UseItems"));
        if (ClaimedChunks.isActive()) {
            NBTTagCompound claimedChunksTag = nbt.func_74775_l("ClaimedChunks");
            for (String dim : claimedChunksTag.func_150296_c()) {
                NBTTagList list = claimedChunksTag.func_150295_c(dim, 10);
                int dimInt = Integer.parseInt(dim);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound chunkNBT = list.func_150305_b(i);
                    ClaimedChunk chunk = new ClaimedChunk(new ChunkDimPos(new ChunkPos(chunkNBT.func_74762_e("x"), chunkNBT.func_74762_e("z")), dimInt), this);
                    chunk.setLoaded(chunkNBT.func_74767_n("loaded"));
                    ClaimedChunks.instance.addChunk(chunk);
                }
            }
        }
    }

    private void addConfig(ConfigGroup main) {
        ConfigGroup group = main.getGroup("ftbutilities");
        group.setDisplayName((ITextComponent)new TextComponentString("FTB Utilities"));
        group.add("explosions", (ConfigValue)this.explosions, (ConfigValue)new ConfigBoolean(false));
        group.add("blocks_edit", this.editBlocks, (ConfigValue)new ConfigEnum(EnumTeamStatus.NAME_MAP_PERMS));
        group.add("blocks_interact", this.interactWithBlocks, (ConfigValue)new ConfigEnum(EnumTeamStatus.NAME_MAP_PERMS));
        group.add("attack_entities", this.attackEntities, (ConfigValue)new ConfigEnum(EnumTeamStatus.NAME_MAP_PERMS));
        group.add("use_items", this.useItems, (ConfigValue)new ConfigEnum(EnumTeamStatus.NAME_MAP_PERMS));
    }

    public EnumTeamStatus getEditBlocksStatus() {
        return (EnumTeamStatus)this.editBlocks.getValue();
    }

    public EnumTeamStatus getInteractWithBlocksStatus() {
        return (EnumTeamStatus)this.interactWithBlocks.getValue();
    }

    public EnumTeamStatus getAttackEntitiesStatus() {
        return (EnumTeamStatus)this.attackEntities.getValue();
    }

    public EnumTeamStatus getUseItemsStatus() {
        return (EnumTeamStatus)this.useItems.getValue();
    }

    public boolean hasExplosions() {
        return this.explosions.getBoolean();
    }

    public int getMaxClaimChunks() {
        if (!ClaimedChunks.isActive()) {
            return -1;
        }
        if (!this.team.isValid()) {
            return -2;
        }
        if (this.cachedMaxClaimChunks >= 0) {
            return this.cachedMaxClaimChunks;
        }
        this.cachedMaxClaimChunks = 0;
        for (ForgePlayer player : this.team.getMembers()) {
            this.cachedMaxClaimChunks += player.getRankConfig(FTBUtilitiesPermissions.CLAIMS_MAX_CHUNKS).getInt();
        }
        return this.cachedMaxClaimChunks;
    }

    public int getMaxChunkloaderChunks() {
        if (!ClaimedChunks.isActive()) {
            return -1;
        }
        if (!this.team.isValid()) {
            return -2;
        }
        if (this.cachedMaxChunkloaderChunks >= 0) {
            return this.cachedMaxChunkloaderChunks;
        }
        this.cachedMaxChunkloaderChunks = 0;
        for (ForgePlayer player : this.team.getMembers()) {
            this.cachedMaxChunkloaderChunks += player.getRankConfig(FTBUtilitiesPermissions.CHUNKLOADER_MAX_CHUNKS).getInt();
        }
        return this.cachedMaxChunkloaderChunks;
    }

    public void clearCache() {
        this.cachedMaxClaimChunks = -1;
        this.cachedMaxChunkloaderChunks = -1;
    }
}

