/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.api.core.ISecurable;
import cofh.core.init.CoreProps;
import cofh.core.item.ItemCore;
import cofh.core.render.IModelRegister;
import cofh.core.util.CoreUtils;
import cofh.core.util.RegistrySocial;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.SecurityHelper;
import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemMulti
extends ItemCore
implements IModelRegister {
    protected Map<Integer, ItemEntry> itemMap = new Int2ObjectOpenHashMap();
    protected ArrayList<Integer> itemList = new ArrayList();
    public static final int CREATIVE = 32000;

    public ItemMulti() {
        this("cofh");
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public ItemMulti(String modName) {
        super(modName);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public static boolean canPlayerAccess(ItemStack stack, EntityPlayer player) {
        if (!SecurityHelper.isSecure(stack)) {
            return true;
        }
        String name = player.func_70005_c_();
        ISecurable.AccessMode access = SecurityHelper.getAccess(stack);
        if (access.isPublic() || CoreProps.enableOpSecureAccess && CoreUtils.isOp(name)) {
            return true;
        }
        GameProfile profile = SecurityHelper.getOwner(stack);
        UUID ownerID = profile.getId();
        if (SecurityHelper.isDefaultUUID(ownerID)) {
            return true;
        }
        UUID otherID = SecurityHelper.getID(player);
        return ownerID.equals(otherID) || access.isFriendsOnly() && RegistrySocial.playerHasAccess(name, profile);
    }

    public static boolean isCreative(ItemStack stack) {
        return ItemHelper.getItemDamage(stack) == 32000;
    }

    public ItemStack addItem(int number, ItemEntry entry) {
        if (this.itemMap.containsKey(number)) {
            return ItemStack.field_190927_a;
        }
        this.itemMap.put(number, entry);
        this.itemList.add(number);
        return new ItemStack((Item)this, 1, number);
    }

    public ItemStack addItem(int number, String name, EnumRarity rarity) {
        return this.addItem(number, new ItemEntry(name, rarity));
    }

    public ItemStack addItem(int number, String name) {
        return this.addItem(number, new ItemEntry(name));
    }

    public ItemStack addOreDictItem(int number, String name, String oreName, EnumRarity rarity) {
        ItemStack stack = this.addItem(number, name, rarity);
        OreDictionary.registerOre((String)oreName, (ItemStack)stack);
        return stack;
    }

    public ItemStack addOreDictItem(int number, String name, String oreName) {
        ItemStack stack = this.addItem(number, name);
        OreDictionary.registerOre((String)oreName, (ItemStack)stack);
        return stack;
    }

    public ItemStack addOreDictItem(int number, String name, EnumRarity rarity) {
        return this.addOreDictItem(number, name, name, rarity);
    }

    public ItemStack addOreDictItem(int number, String name) {
        return this.addOreDictItem(number, name, name);
    }

    public ImmutableList<ItemStack> getAllItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int metadata : this.itemList) {
            items.add(new ItemStack((Item)this, 1, metadata));
        }
        return ImmutableList.copyOf(items);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int metadata : this.itemList) {
                items.add((Object)new ItemStack((Item)this, 1, metadata));
            }
        }
    }

    public boolean func_77645_m() {
        return false;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        int i = ItemHelper.getItemDamage(stack);
        if (!this.itemMap.containsKey(i)) {
            return EnumRarity.COMMON;
        }
        return this.itemMap.get((Object)Integer.valueOf((int)ItemHelper.getItemDamage((ItemStack)stack))).rarity;
    }

    public String func_77667_c(ItemStack stack) {
        int i = ItemHelper.getItemDamage(stack);
        if (!this.itemMap.containsKey(i)) {
            return "item.invalid";
        }
        ItemEntry item = this.itemMap.get(i);
        return this.func_77658_a() + "." + item.name;
    }

    public Item func_77655_b(String name) {
        this.name = name;
        name = this.modName + "." + name;
        return super.func_77655_b(name);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (Map.Entry<Integer, ItemEntry> entry : this.itemMap.entrySet()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)entry.getKey(), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "type=" + entry.getValue().name));
        }
    }

    public class ItemEntry {
        public String name;
        public EnumRarity rarity;

        ItemEntry(String name, EnumRarity rarity) {
            this.name = name;
            this.rarity = rarity;
        }

        ItemEntry(String name) {
            this(name, EnumRarity.COMMON);
        }
    }
}

