/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.block;

import cofh.api.block.IBlockInfo;
import cofh.api.block.IDismantleable;
import cofh.api.core.IAugmentable;
import cofh.api.core.ISecurable;
import cofh.api.item.IPlacementUtilItem;
import cofh.api.tileentity.IInventoryRetainer;
import cofh.api.tileentity.IReconfigurableFacing;
import cofh.api.tileentity.IRedstoneControl;
import cofh.api.tileentity.ITileInfo;
import cofh.core.block.BlockCore;
import cofh.core.block.TileAugmentableSecure;
import cofh.core.block.TileCore;
import cofh.core.block.TileNameable;
import cofh.core.block.TileReconfigurable;
import cofh.core.util.CoreUtils;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.ReconfigurableHelper;
import cofh.core.util.helpers.RedstoneControlHelper;
import cofh.core.util.helpers.SecurityHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.redstoneflux.api.IEnergyHandler;
import cofh.redstoneflux.api.IEnergyReceiver;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockCoreTile
extends BlockCore
implements IInitializer,
ITileEntityProvider,
IBlockInfo,
IDismantleable {
    public BlockCoreTile(Material material, String modName) {
        super(material, modName);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return this.func_149915_a(world, state.func_177230_c().func_176201_c(state));
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCore) {
            return ((TileCore)tile).getExtendedState(state, world, pos);
        }
        return state;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCore) {
            ((TileCore)tile).blockBroken();
        }
        if (!(tile instanceof IInventoryRetainer && ((IInventoryRetainer)tile).retainInventory() || !(tile instanceof IInventory))) {
            IInventory inv = (IInventory)tile;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                CoreUtils.dropItemStackIntoWorldWithVelocity(inv.func_70301_a(i), world, pos);
            }
        }
        if (tile != null) {
            world.func_175713_t(pos);
        }
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        ItemStack offhand;
        TileEntity tile = world.func_175625_s(pos);
        if (ServerHelper.isServerWorld(world) && tile instanceof ISecurable && SecurityHelper.isSecure(stack)) {
            GameProfile stackOwner = SecurityHelper.getOwner(stack);
            if (!((ISecurable)tile).setOwner(stackOwner) && placer instanceof ICommandSender) {
                ((ISecurable)tile).setOwnerName(placer.func_70005_c_());
            }
            ((ISecurable)tile).setAccess(SecurityHelper.getAccess(stack));
        }
        if (tile instanceof IRedstoneControl && RedstoneControlHelper.hasRSControl(stack)) {
            ((IRedstoneControl)tile).setControl(RedstoneControlHelper.getControl(stack));
        }
        if (tile instanceof IReconfigurableFacing) {
            IReconfigurableFacing reconfig = (IReconfigurableFacing)tile;
            EnumFacing facing = reconfig.allowYAxisFacing() ? EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer) : placer.func_174811_aO().func_176734_d();
            reconfig.setFacing(facing.ordinal(), placer.func_70093_af());
        }
        if (tile instanceof TileCore) {
            ((TileCore)tile).blockPlaced();
        }
        if (ServerHelper.isServerWorld(world) && !(offhand = placer.func_184592_cb()).func_190926_b() && offhand.func_77973_b() instanceof IPlacementUtilItem) {
            ((IPlacementUtilItem)offhand.func_77973_b()).onBlockPlacement(offhand, world, pos, state, (EntityPlayer)placer);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCore) {
            ((TileCore)tile).onNeighborBlockChange();
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCore) {
            ((TileCore)tile).onNeighborTileChange(neighbor);
        }
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ISecurable && !((ISecurable)tile).canPlayerAccess(player)) {
            return -1.0f;
        }
        return super.func_180647_a(state, player, world, pos);
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileCore && tile.func_145830_o() ? ((TileCore)tile).getComparatorInputOverride() : 0;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileCore && tile.func_145830_o() ? ((TileCore)tile).getLightValue() : super.getLightValue(state, world, pos);
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        TileEntity tile = world.func_175625_s(pos);
        return tile != null && tile.func_145842_c(id, param);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.addAll(this.dropDelegate(this.getItemStackTag(world, pos), world, pos, fortune));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        Item item = Item.func_150898_a((Block)this);
        if (item == Items.field_190931_a) {
            return ItemStack.field_190927_a;
        }
        int bMeta = state.func_177230_c().func_176201_c(state);
        ItemStack retStack = new ItemStack(item, 1, bMeta);
        retStack.func_77982_d(this.getItemStackTag((IBlockAccess)world, pos));
        return retStack;
    }

    public NBTTagCompound getItemStackTag(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        NBTTagCompound retTag = new NBTTagCompound();
        if (tile instanceof TileNameable && !((TileNameable)tile).customName.isEmpty()) {
            retTag = ItemHelper.setItemStackTagName(retTag, ((TileNameable)tile).customName);
        }
        if (tile instanceof TileAugmentableSecure) {
            retTag.func_74757_a("Creative", ((TileAugmentableSecure)tile).isCreative);
            retTag.func_74774_a("Level", (byte)((TileAugmentableSecure)tile).getLevel());
            if (((TileAugmentableSecure)tile).isSecured()) {
                retTag = SecurityHelper.setItemStackTagSecure(retTag, (ISecurable)tile);
            }
        }
        if (tile instanceof IAugmentable) {
            retTag = AugmentHelper.setItemStackTagAugments(retTag, (IAugmentable)tile);
        }
        if (tile instanceof IRedstoneControl) {
            retTag = RedstoneControlHelper.setItemStackTagRS(retTag, (IRedstoneControl)tile);
        }
        if (tile instanceof TileReconfigurable) {
            retTag = ReconfigurableHelper.setItemStackTagReconfig(retTag, (TileReconfigurable)tile);
        }
        if (tile instanceof IEnergyHandler) {
            retTag.func_74768_a("Energy", ((IEnergyHandler)tile).getEnergyStored(null));
        }
        return retTag;
    }

    public ArrayList<ItemStack> dropDelegate(NBTTagCompound nbt, IBlockAccess world, BlockPos pos, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        int meta = state.func_177230_c().func_176201_c(state);
        ItemStack dropBlock = new ItemStack((Block)this, 1, meta);
        if (nbt != null) {
            dropBlock.func_77982_d(nbt);
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(dropBlock);
        return ret;
    }

    public ArrayList<ItemStack> dismantleDelegate(NBTTagCompound nbt, World world, BlockPos pos, EntityPlayer player, boolean returnDrops, boolean simulate) {
        TileEntity tile = world.func_175625_s(pos);
        IBlockState state = world.func_180495_p(pos);
        int meta = state.func_177230_c().func_176201_c(state);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (state.func_177230_c() != this) {
            return ret;
        }
        ItemStack dropBlock = new ItemStack((Block)this, 1, meta);
        if (nbt != null) {
            dropBlock.func_77982_d(nbt);
        }
        if (!simulate) {
            if (tile instanceof TileCore) {
                ((TileCore)tile).blockDismantled();
            }
            world.func_175698_g(pos);
            if (!returnDrops) {
                float f = 0.3f;
                double x2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double y2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double z2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem dropEntity = new EntityItem(world, (double)pos.func_177958_n() + x2, (double)pos.func_177956_o() + y2, (double)pos.func_177952_p() + z2, dropBlock);
                dropEntity.func_174867_a(10);
                if (tile instanceof ISecurable && !((ISecurable)tile).getAccess().isPublic()) {
                    dropEntity.func_145797_a(player.func_70005_c_());
                }
                world.func_72838_d((Entity)dropEntity);
                if (player != null) {
                    CoreUtils.dismantleLog(player.func_70005_c_(), state.func_177230_c(), meta, pos);
                }
            }
        }
        ret.add(dropBlock);
        return ret;
    }

    @Override
    public void getBlockInfo(List<ITextComponent> info, IBlockAccess world, BlockPos pos, EnumFacing side, EntityPlayer player, boolean debug) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ITileInfo) {
            ((ITileInfo)tile).getTileInfo(info, side, player, debug);
        } else if (tile instanceof IEnergyReceiver) {
            IEnergyReceiver rec = (IEnergyReceiver)tile;
            if (rec.getMaxEnergyStored(side) <= 0) {
                return;
            }
            info.add(new TextComponentTranslation("info.cofh.energy", new Object[0]).func_150258_a(": " + StringHelper.formatNumber(rec.getEnergyStored(side)) + "/" + StringHelper.formatNumber(rec.getMaxEnergyStored(side)) + " RF"));
        }
    }

    @Override
    public ArrayList<ItemStack> dismantleBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player, boolean returnDrops) {
        return this.dismantleDelegate(this.getItemStackTag((IBlockAccess)world, pos), world, pos, player, returnDrops, false);
    }

    @Override
    public boolean canDismantle(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ISecurable) {
            return ((ISecurable)tile).canPlayerAccess(player);
        }
        if (tile instanceof TileCore) {
            return ((TileCore)tile).canPlayerDismantle(player);
        }
        return true;
    }

    @Override
    public boolean preInit() {
        return false;
    }

    @Override
    public boolean initialize() {
        return false;
    }
}

