/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.container;

import fi.dy.masa.enderutilities.inventory.IContainerItem;
import fi.dy.masa.enderutilities.inventory.container.base.ContainerTile;
import fi.dy.masa.enderutilities.inventory.container.base.MergeSlotRange;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerGeneric;
import fi.dy.masa.enderutilities.inventory.slot.SlotModuleModularItem;
import fi.dy.masa.enderutilities.item.base.IModular;
import fi.dy.masa.enderutilities.item.base.IStringInput;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.tileentity.TileEntityToolWorkstation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerToolWorkstation
extends ContainerTile
implements IContainerItem,
IStringInput {
    public static final int CONT_SLOT_MODULES_START = 1;
    public static final int NUM_MODULE_SLOTS = 10;
    public static final int NUM_STORAGE_SLOTS = 9;
    private final TileEntityToolWorkstation tetw;
    private int slotTool;
    private int slotRename;
    private ItemStack toolStackLast = ItemStack.field_190927_a;

    public ContainerToolWorkstation(EntityPlayer player, TileEntityToolWorkstation te) {
        super(player, te);
        this.tetw = te;
        this.addCustomInventorySlots();
        this.addPlayerInventorySlots(8, 135);
    }

    @Override
    protected void addCustomInventorySlots() {
        int i;
        this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.tetw.getToolSlotInventory(), 0, 8, 19));
        this.slotTool = this.field_75151_b.size() - 1;
        int x = 80;
        int y = 19;
        for (i = 0; i < 10; ++i) {
            this.func_75146_a((Slot)new SlotModuleModularItem(this.tetw.getInstalledModulesInventory(), i, x, y, ItemModule.ModuleType.TYPE_INVALID, this));
            if (i == 4) {
                y += 18;
                x -= 90;
            }
            x += 18;
        }
        x = 8;
        y = 66;
        for (i = 0; i < 9; ++i) {
            this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventory, i, x, y));
            x += 18;
        }
        this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.tetw.getRenameSlotInventory(), 0, 8, 97));
        this.slotRename = this.field_75151_b.size() - 1;
        this.customInventorySlots = new MergeSlotRange(0, this.field_75151_b.size());
        this.setModuleSlotTypes();
        this.toolStackLast = this.getContainerItem();
    }

    @Override
    public ItemStack getContainerItem() {
        return this.func_75139_a(this.slotTool).func_75211_c();
    }

    public int getSlotTool() {
        return this.slotTool;
    }

    public int getSlotRename() {
        return this.slotRename;
    }

    private void setModuleSlotTypes() {
        int slotNum = 1;
        int slots = 0;
        Slot slot = this.func_75139_a(this.slotTool);
        if (slot != null && slot.func_75216_d() && slot.func_75211_c().func_77973_b() instanceof IModular) {
            ItemStack toolStack = slot.func_75211_c();
            IModular imodular = (IModular)toolStack.func_77973_b();
            for (ItemModule.ModuleType moduleType : ItemModule.ModuleType.values()) {
                if (moduleType.equals(ItemModule.ModuleType.TYPE_INVALID)) continue;
                int maxOfType = imodular.getMaxModules(toolStack, moduleType);
                int i = 0;
                while (i < maxOfType && slots < 10) {
                    slot = this.func_75139_a(slotNum);
                    if (slot instanceof SlotModuleModularItem) {
                        ((SlotModuleModularItem)slot).setModuleType(moduleType);
                    }
                    ++i;
                    ++slotNum;
                    ++slots;
                }
                if (slots >= 10) break;
            }
        }
        while (slotNum < 11) {
            slot = this.func_75139_a(slotNum);
            if (slot instanceof SlotModuleModularItem) {
                ((SlotModuleModularItem)slot).setModuleType(ItemModule.ModuleType.TYPE_INVALID);
            }
            ++slotNum;
        }
    }

    @Override
    public void syncStackInSlot(int slotId, ItemStack stack) {
        super.syncStackInSlot(slotId, stack);
        ItemStack containerStack = this.getContainerItem();
        if (slotId == this.slotTool && containerStack != this.toolStackLast) {
            this.setModuleSlotTypes();
            this.toolStackLast = containerStack;
        }
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        ItemStack containerStack = this.getContainerItem();
        if (containerStack != this.toolStackLast) {
            this.setModuleSlotTypes();
            this.toolStackLast = containerStack;
        }
    }

    @Override
    public void handleString(EntityPlayer player, ItemStack stack, String text) {
        this.tetw.renameItem(text);
    }
}

