/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.block;

import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.tileentity.TileEntityCreationStation;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderInfuser;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.tileentity.TileEntityQuickStackerAdvanced;
import fi.dy.masa.enderutilities.tileentity.TileEntityToolWorkstation;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMachine
extends BlockEnderUtilitiesInventory {
    public static final PropertyEnum<EnumMachineType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumMachineType.class);

    public BlockMachine(String name, float hardness, float resistance, int harvestLevel, Material material) {
        super(name, hardness, resistance, harvestLevel, material);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumMachineType.ENDER_INFUSER)).func_177226_a((IProperty)FACING_H, (Comparable)BlockEnderUtilities.DEFAULT_FACING));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, FACING_H});
    }

    @Override
    protected String[] generateUnlocalizedNames() {
        return new String[]{"ender_infuser", "tool_workstation", "creation_station", "quick_stacker_advanced"};
    }

    @Override
    protected TileEntityEnderUtilities createTileEntityInstance(World worldIn, IBlockState state) {
        switch ((EnumMachineType)((Object)state.func_177229_b(TYPE))) {
            case CREATION_STATION: {
                return new TileEntityCreationStation();
            }
            case ENDER_INFUSER: {
                return new TileEntityEnderInfuser();
            }
            case QUICK_STACKER: {
                return new TileEntityQuickStackerAdvanced();
            }
            case TOOL_WORKSTATION: {
                return new TileEntityToolWorkstation();
            }
        }
        return new TileEntityEnderInfuser();
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityToolWorkstation te;
        EnumMachineType machine = (EnumMachineType)((Object)state.func_177229_b(TYPE));
        if (machine == EnumMachineType.CREATION_STATION) {
            TileEntityCreationStation te2 = BlockMachine.getTileEntitySafely((IBlockAccess)world, pos, TileEntityCreationStation.class);
            if (te2 != null) {
                InventoryUtils.dropInventoryContentsInWorld(world, pos, te2.getFurnaceInventory());
            }
        } else if (machine == EnumMachineType.TOOL_WORKSTATION && (te = BlockMachine.getTileEntitySafely((IBlockAccess)world, pos, TileEntityToolWorkstation.class)) != null) {
            InventoryUtils.dropInventoryContentsInWorld(world, pos, te.getToolSlotInventory());
            InventoryUtils.dropInventoryContentsInWorld(world, pos, te.getRenameSlotInventory());
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public int getLightValue(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (state.func_177229_b(TYPE) == EnumMachineType.CREATION_STATION) {
            return 10;
        }
        return super.getLightValue(state, worldIn, pos);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumMachineType.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumMachineType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < EnumMachineType.values().length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, EnumMachineType.values()[i].getMeta()));
        }
    }

    public static enum EnumMachineType implements IStringSerializable
    {
        ENDER_INFUSER(0, "ender_infuser"),
        TOOL_WORKSTATION(1, "tool_workstation"),
        CREATION_STATION(2, "creation_station"),
        QUICK_STACKER(3, "quick_stacker_advanced");

        private final String name;
        private final int meta;

        private EnumMachineType(int meta, String name) {
            this.name = name;
            this.meta = meta;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumMachineType fromMeta(int meta) {
            return meta < EnumMachineType.values().length ? EnumMachineType.values()[meta] : ENDER_INFUSER;
        }
    }
}

