/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.block;

import fi.dy.masa.enderutilities.block.BlockElevator;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.item.block.ItemBlockEnderUtilities;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesBlocks;
import fi.dy.masa.enderutilities.tileentity.TileEntityElevator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockElevatorSlab
extends BlockElevator {
    public static final AxisAlignedBB BOUNDS_SLAB_BOTTOM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    public static final AxisAlignedBB BOUNDS_SLAB_TOP = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB BOUNDS_LAYER_BOTTOM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    public static final AxisAlignedBB BOUNDS_LAYER_TOP = new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0);
    public static final PropertyEnum<BlockSlab.EnumBlockHalf> HALF = PropertyEnum.func_177709_a((String)"half", BlockSlab.EnumBlockHalf.class);

    public BlockElevatorSlab(String name, float hardness, float resistance, int harvestLevel, Material material) {
        super(name, hardness, resistance, harvestLevel, material);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)COLOR, (Comparable)EnumDyeColor.WHITE).func_177226_a(HALF, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{COLOR, HALF}, new IUnlistedProperty[]{CAMOBLOCKSTATE, CAMOBLOCKSTATEEXTENDED});
    }

    @Override
    public ItemBlock createItemBlock() {
        return new ItemBlockEnderUtilities(this){

            public String func_77653_i(ItemStack stack) {
                String name = super.func_77653_i(stack);
                return name.replace("{COLOR}", EnumDyeColor.func_176764_b((int)stack.func_77960_j()).func_176610_l());
            }

            public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
                if (super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState)) {
                    TileEntityElevator te = BlockEnderUtilities.getTileEntitySafely((IBlockAccess)world, pos, TileEntityElevator.class);
                    if (te != null) {
                        te.setIsTopHalf(newState.func_177229_b(HALF) == BlockSlab.EnumBlockHalf.TOP);
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        boolean top = facing == EnumFacing.DOWN || facing.func_176740_k().func_176722_c() && hitY >= 0.5f;
        state = state.func_177226_a(HALF, (Comparable)(top ? BlockSlab.EnumBlockHalf.TOP : BlockSlab.EnumBlockHalf.BOTTOM));
        return state;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityElevator te = BlockElevatorSlab.getTileEntitySafely(world, pos, TileEntityElevator.class);
        if (te != null) {
            state = state.func_177226_a(HALF, (Comparable)(te.isTopHalf() ? BlockSlab.EnumBlockHalf.TOP : BlockSlab.EnumBlockHalf.BOTTOM));
        }
        return state;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        if (this == EnderUtilitiesBlocks.ELEVATOR_SLAB) {
            return (state = state.func_185899_b(blockAccess, pos)).func_177229_b(HALF) == BlockSlab.EnumBlockHalf.TOP ? BOUNDS_SLAB_TOP : BOUNDS_SLAB_BOTTOM;
        }
        if (this == EnderUtilitiesBlocks.ELEVATOR_LAYER) {
            return (state = state.func_185899_b(blockAccess, pos)).func_177229_b(HALF) == BlockSlab.EnumBlockHalf.TOP ? BOUNDS_LAYER_TOP : BOUNDS_LAYER_BOTTOM;
        }
        return field_185505_j;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }
}

