/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.yunomakegoodmap;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGeneratorHell;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.MapGenNetherBridge;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.lex.yunomakegoodmap.YUNoMakeGoodMap;

public class WorldProviderHellVoid
extends WorldProviderHell {
    public IChunkGenerator func_186060_c() {
        if (YUNoMakeGoodMap.instance.shouldBeVoid(this.field_76579_a)) {
            return new ChunkGeneratorHellVoid(this.field_76579_a, YUNoMakeGoodMap.instance.shouldGenerateNetherFortress(this.field_76579_a), this.field_76579_a.func_72905_C());
        }
        return new ChunkGeneratorHell(this.field_76579_a, YUNoMakeGoodMap.instance.shouldGenerateNetherFortress(this.field_76579_a), this.field_76579_a.func_72905_C());
    }

    public static class ChunkGeneratorHellVoid
    extends ChunkGeneratorHell {
        private World world;
        private Random hellRNG;

        public ChunkGeneratorHellVoid(World world, boolean shouldGenNetherFortress, long seed) {
            super(world, shouldGenNetherFortress, seed);
            this.world = world;
            this.hellRNG = new Random(seed);
            this.field_73172_c = (MapGenNetherBridge)TerrainGen.getModdedMapGen((MapGenBase)this.field_73172_c, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_BRIDGE);
        }

        public void func_185931_b(int x, int z) {
            if (YUNoMakeGoodMap.instance.shouldGenerateNetherFortress(this.world)) {
                this.field_73172_c.func_175794_a(this.world, this.hellRNG, new ChunkPos(x, z));
            }
            int spawnX = this.world.func_72912_H().func_76079_c() / 8;
            int spawnY = this.world.func_72912_H().func_76075_d();
            int spawnZ = this.world.func_72912_H().func_76074_e() / 8;
            if (x == spawnX / 16 && z == spawnZ / 16) {
                YUNoMakeGoodMap.instance.getPlatformType(this.world).generate(this.world, new BlockPos(spawnX, spawnY, spawnZ));
            }
        }

        public Chunk func_185932_a(int x, int z) {
            ChunkPrimer data = new ChunkPrimer();
            if (YUNoMakeGoodMap.instance.shouldGenerateNetherFortress(this.world)) {
                this.field_73172_c.func_186125_a(this.world, x, z, data);
            } else {
                this.field_73172_c.func_186125_a(this.world, x, z, null);
            }
            Chunk ret = new Chunk(this.world, data, x, z);
            Biome[] biomes = this.world.func_72959_q().func_76933_b(null, x * 16, z * 16, 16, 16);
            byte[] ids = ret.func_76605_m();
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = (byte)Biome.func_185362_a((Biome)biomes[i]);
            }
            ret.func_76603_b();
            return ret;
        }
    }
}

