/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.container;

import com.google.common.collect.Maps;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifiable;
import org.cyclops.cyclopscore.inventory.container.ExtendedInventoryContainer;
import org.cyclops.cyclopscore.inventory.container.button.IButtonActionClient;
import org.cyclops.cyclopscore.inventory.container.button.IButtonClickAcceptorClient;
import org.cyclops.cyclopscore.inventory.slot.SlotExtended;
import org.cyclops.cyclopscore.network.packet.ButtonClickPacket;
import org.lwjgl.opengl.GL11;

public abstract class GuiContainerExtended
extends GuiContainer
implements IButtonClickAcceptorClient<GuiContainerExtended, ExtendedInventoryContainer>,
IValueNotifiable {
    private final Map<Integer, IButtonActionClient<GuiContainerExtended, ExtendedInventoryContainer>> buttonActions = Maps.newHashMap();
    protected ExtendedInventoryContainer container;
    protected ResourceLocation texture;
    protected int offsetX = 0;
    protected int offsetY = 0;

    public GuiContainerExtended(ExtendedInventoryContainer container) {
        super((Container)container);
        container.setGuiValueListener(this);
        this.container = container;
        this.texture = this.constructResourceLocation();
    }

    protected ExtendedInventoryContainer getContainer() {
        return this.container;
    }

    protected ResourceLocation constructResourceLocation() {
        return new ResourceLocation(this.container.getGuiProvider().getModGui().getModId(), this.getGuiTexture());
    }

    public abstract String getGuiTexture();

    public void func_73866_w_() {
        this.field_146999_f = this.getBaseXSize() + this.offsetX * 2;
        this.field_147000_g = this.getBaseYSize() + this.offsetY * 2;
        super.func_73866_w_();
    }

    public final void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.drawCurrentScreen(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void drawCurrentScreen(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected int getBaseXSize() {
        return 176;
    }

    protected int getBaseYSize() {
        return 166;
    }

    protected void func_146976_a(float f, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.texture);
        this.func_73729_b(this.field_147003_i + this.offsetX, this.field_147009_r + this.offsetY, 0, 0, this.field_146999_f - 2 * this.offsetX, this.field_147000_g - 2 * this.offsetY);
    }

    public boolean func_146978_c(int left, int top, int right, int bottom, int pointX, int pointY) {
        return RenderHelpers.isPointInRegion(left, top, right, bottom, pointX - this.field_147003_i, pointY - this.field_147009_r);
    }

    public boolean isPointInRegion(Rectangle region, Point mouse) {
        return this.func_146978_c(region.x, region.y, region.width, region.height, mouse.x, mouse.y);
    }

    public void drawTooltip(List<String> lines, int x, int y) {
        GlStateManager.func_179094_E();
        GL11.glDisable((int)2929);
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        int tooltipWidth = 0;
        for (String line : lines) {
            int tempWidth = this.field_146289_q.func_78256_a(line);
            if (tempWidth <= tooltipWidth) continue;
            tooltipWidth = tempWidth;
        }
        int xStart = x + 12;
        int yStart = y - 12;
        int tooltipHeight = 8;
        if (lines.size() > 1) {
            tooltipHeight += 2 + (lines.size() - 1) * 10;
        }
        if (this.field_147003_i + xStart + tooltipWidth + 6 > this.field_146294_l) {
            xStart = this.field_146294_l - tooltipWidth - this.field_147003_i - 6;
        }
        if (this.field_147009_r + yStart + tooltipHeight + 6 > this.field_146295_m) {
            yStart = this.field_146295_m - tooltipHeight - this.field_147009_r - 6;
        }
        this.field_73735_i = 300.0f;
        this.field_146296_j.field_77023_b = 300.0f;
        int color1 = -267386864;
        this.func_73733_a(xStart - 3, yStart - 4, xStart + tooltipWidth + 3, yStart - 3, color1, color1);
        this.func_73733_a(xStart - 3, yStart + tooltipHeight + 3, xStart + tooltipWidth + 3, yStart + tooltipHeight + 4, color1, color1);
        this.func_73733_a(xStart - 3, yStart - 3, xStart + tooltipWidth + 3, yStart + tooltipHeight + 3, color1, color1);
        this.func_73733_a(xStart - 4, yStart - 3, xStart - 3, yStart + tooltipHeight + 3, color1, color1);
        this.func_73733_a(xStart + tooltipWidth + 3, yStart - 3, xStart + tooltipWidth + 4, yStart + tooltipHeight + 3, color1, color1);
        int color2 = 0x505000FF;
        int color3 = (color2 & 0xFEFEFE) >> 1 | color2 & 0xFF000000;
        this.func_73733_a(xStart - 3, yStart - 3 + 1, xStart - 3 + 1, yStart + tooltipHeight + 3 - 1, color2, color3);
        this.func_73733_a(xStart + tooltipWidth + 2, yStart - 3 + 1, xStart + tooltipWidth + 3, yStart + tooltipHeight + 3 - 1, color2, color3);
        this.func_73733_a(xStart - 3, yStart - 3, xStart + tooltipWidth + 3, yStart - 3 + 1, color2, color2);
        this.func_73733_a(xStart - 3, yStart + tooltipHeight + 2, xStart + tooltipWidth + 3, yStart + tooltipHeight + 3, color3, color3);
        for (int stringIndex = 0; stringIndex < lines.size(); ++stringIndex) {
            String line = lines.get(stringIndex);
            line = stringIndex == 0 ? "\u00a7" + Integer.toHexString(15) + line : "\u00a77" + line;
            this.field_146289_q.func_175063_a(line, (float)xStart, (float)yStart, -1);
            if (stringIndex == 0) {
                yStart += 2;
            }
            yStart += 10;
        }
        GlStateManager.func_179121_F();
        GL11.glEnable((int)2929);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
    }

    protected void func_146273_a(int mouseX, int mouseY, int mouseButton, long time) {
        Slot slot = this.getSlotUnderMouse();
        if (mouseButton == 1 && slot instanceof SlotExtended && ((SlotExtended)slot).isPhantom()) {
            return;
        }
        super.func_146273_a(mouseX, mouseY, mouseButton, time);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (this.requiresAction(button.field_146127_k)) {
            this.onButtonClick(button.field_146127_k);
        }
        if (this.getContainer().requiresAction(button.field_146127_k)) {
            this.getContainer().onButtonClick(button.field_146127_k);
            CyclopsCore._instance.getPacketHandler().sendToServer(new ButtonClickPacket(button.field_146127_k));
        }
    }

    @Override
    public void putButtonAction(int buttonId, IButtonActionClient<GuiContainerExtended, ExtendedInventoryContainer> action) {
        this.buttonActions.put(buttonId, action);
    }

    @Override
    public boolean requiresAction(int buttonId) {
        return this.buttonActions.containsKey(buttonId);
    }

    @Override
    public void onButtonClick(int buttonId) {
        IButtonActionClient<GuiContainerExtended, ExtendedInventoryContainer> action = this.buttonActions.get(buttonId);
        if (action != null) {
            action.onAction(buttonId, this, this.getContainer());
        }
    }

    @Override
    public void onUpdate(int valueId, NBTTagCompound value) {
    }

    protected void refreshValues() {
        for (int id : this.getContainer().getValueIds()) {
            this.onUpdate(id, this.getContainer().getValue(id));
        }
    }

    public int getGuiLeft() {
        return this.field_147003_i + this.offsetX;
    }

    public int getGuiTop() {
        return this.field_147009_r + this.offsetY;
    }
}

