/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Pair;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;

public class ToStringer {
    private final List<Pair<String, Object>> list = new ArrayList<Pair<String, Object>>();
    private final String name;

    public ToStringer(@Nonnull Object object) {
        Sanity.nullCheck(object, "Object cannot be null");
        this.name = object.getClass().getSimpleName();
    }

    @Nonnull
    public ToStringer add(@Nonnull String name, @Nullable Object object) {
        Sanity.nullCheck(name, "Name cannot be null");
        this.list.add(new Pair<String, Object>(name, object));
        return this;
    }

    @Nonnull
    public ToStringer add(@Nonnull String name, boolean b) {
        this.add(name, String.valueOf(b));
        return this;
    }

    @Nonnull
    public ToStringer add(@Nonnull String name, byte b) {
        this.add(name, String.valueOf(b));
        return this;
    }

    @Nonnull
    public ToStringer add(@Nonnull String name, char c) {
        this.add(name, String.valueOf(c));
        return this;
    }

    @Nonnull
    public ToStringer add(@Nonnull String name, double d) {
        this.add(name, String.valueOf(d));
        return this;
    }

    @Nonnull
    public ToStringer add(@Nonnull String name, float f) {
        this.add(name, String.valueOf(f));
        return this;
    }

    @Nonnull
    public ToStringer add(@Nonnull String name, int i) {
        this.add(name, String.valueOf(i));
        return this;
    }

    @Nonnull
    public ToStringer add(@Nonnull String name, long l) {
        this.add(name, String.valueOf(l));
        return this;
    }

    @Nonnull
    public ToStringer add(@Nonnull String name, short s) {
        this.add(name, String.valueOf(s));
        return this;
    }

    @Nonnull
    public String toString() {
        StringBuilder builder = new StringBuilder(this.name.length() + this.list.size() * 10);
        builder.append(this.name).append(" (");
        boolean first = true;
        for (Pair<String, Object> pair : this.list) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(pair.getLeft()).append('=');
            if (pair.getRight() != null && pair.getRight().getClass().isArray()) {
                String arr = Arrays.deepToString(new Object[]{pair.getRight()});
                builder.append(arr.substring(1, arr.length() - 1));
                continue;
            }
            builder.append(pair.getRight());
        }
        builder.append(')');
        return builder.toString();
    }
}

