/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.util;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsPolicy;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsPropertiesStorageManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsStorageManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;

public final class StsUtil {
    public static final String DEFAULT_FILENAME = ".kicl_sts.properties";

    private StsUtil() {
    }

    @Nonnull
    public static StsStorageManager getDefaultStorageManager() {
        return StsUtil.getDefaultStorageManager(Paths.get(System.getProperty("user.home"), DEFAULT_FILENAME));
    }

    @Nonnull
    public static StsStorageManager getDefaultStorageManager(@Nonnull Path stsFile) {
        return new StsPropertiesStorageManager(stsFile);
    }

    @Nonnull
    public static StsPolicy getStsPolicyFromString(@Nonnull String delimiter, @Nonnull String str) {
        Sanity.nullCheck(delimiter, "Need a valid delimiter.");
        Sanity.nullCheck(str, "Need a valid string to parse.");
        String[] components = str.split(delimiter);
        HashMap<String, String> options = new HashMap<String, String>();
        HashSet<String> flags = new HashSet<String>();
        for (String component : components) {
            if (!component.contains("=")) {
                flags.add(component);
                continue;
            }
            String[] innerComponents = component.split("=");
            options.put(innerComponents[0], innerComponents[1]);
        }
        return new StsPolicy(options, flags);
    }
}

