/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.defaultoptions;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.blay09.mods.defaultoptions.CommandDefaultOptions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="defaultoptions", name="Default Options", clientSideOnly=true, acceptedMinecraftVersions="[1.12]", dependencies="after:journeymap")
public class DefaultOptions {
    public static final String MOD_ID = "defaultoptions";
    public static final Logger logger = LogManager.getLogger((String)"defaultoptions");
    @Mod.Instance
    public static DefaultOptions instance;
    private static Map<String, DefaultBinding> defaultKeys;
    private static List<String> knownKeys;
    private Pattern PATTERN = Pattern.compile("key_(.+):([0-9\\-]+)(?::(.+))?");

    @Mod.EventHandler
    public void construct(FMLConstructionEvent event) {
        DefaultOptions.preStartGame();
        Minecraft mc = Minecraft.func_71410_x();
        GameSettings gameSettings = mc.field_71474_y;
        gameSettings.func_74300_a();
        mc.func_135016_M().field_135048_c = gameSettings.field_74363_ab;
        ResourcePackRepository resourcePackRepository = mc.func_110438_M();
        resourcePackRepository.func_110611_a();
        List repositoryEntriesAll = resourcePackRepository.func_110609_b();
        ArrayList repositoryEntries = Lists.newArrayList();
        Iterator it = gameSettings.field_151453_l.iterator();
        block0: while (it.hasNext()) {
            String packName = (String)it.next();
            for (ResourcePackRepository.Entry entry : repositoryEntriesAll) {
                if (!entry.func_110515_d().equals(packName)) continue;
                if (entry.func_183027_f() == 3 || gameSettings.field_183018_l.contains(entry.func_110515_d())) {
                    repositoryEntries.add(entry);
                    continue block0;
                }
                it.remove();
                logger.warn("[Vanilla Behaviour] Removed selected resource pack {} because it's no longer compatible", (Object)entry.func_110515_d());
            }
        }
        resourcePackRepository.func_148527_a((List)repositoryEntries);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandDefaultOptions());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        File defaultKeybindings;
        File defaultOptionsOF;
        File defaultOptions = new File(DefaultOptions.getDefaultOptionsFolder(), "options.txt");
        if (!defaultOptions.exists()) {
            this.saveDefaultOptions();
        }
        if (!(defaultOptionsOF = new File(DefaultOptions.getDefaultOptionsFolder(), "optionsof.txt")).exists()) {
            this.saveDefaultOptionsOptiFine();
        }
        if (!(defaultKeybindings = new File(DefaultOptions.getDefaultOptionsFolder(), "keybindings.txt")).exists()) {
            this.saveDefaultMappings();
        }
        this.reloadDefaultMappings();
    }

    public static void preStartGame() {
        File serversDatFile;
        File optionsFileOF;
        boolean firstRun;
        File mcDataDir = Minecraft.func_71410_x().field_71412_D;
        File optionsFile = new File(mcDataDir, "options.txt");
        boolean bl = firstRun = !optionsFile.exists();
        if (firstRun) {
            DefaultOptions.applyDefaultOptions();
        }
        if (!(optionsFileOF = new File(mcDataDir, "optionsof.txt")).exists()) {
            DefaultOptions.applyDefaultOptionsOptiFine();
        }
        if (!(serversDatFile = new File(mcDataDir, "servers.dat")).exists()) {
            DefaultOptions.applyDefaultServers();
        }
        File overwriteConfig = new File(mcDataDir, "overwrite-config");
        if (firstRun || overwriteConfig.exists()) {
            DefaultOptions.applyDefaultConfig();
            if (overwriteConfig.exists() && !overwriteConfig.delete()) {
                logger.warn("Could not delete overwrite-config file. Configs will be overwritten from defaults upon next run unless you delete the file manually.");
            }
        }
    }

    private static boolean applyDefaultServers() {
        try {
            FileUtils.copyFile((File)new File(DefaultOptions.getDefaultOptionsFolder(), "servers.dat"), (File)new File(Minecraft.func_71410_x().field_71412_D, "servers.dat"));
            return true;
        }
        catch (IOException e) {
            logger.error((Object)e);
            return false;
        }
    }

    public static boolean applyDefaultConfig() {
        try {
            FileUtils.copyDirectory((File)DefaultOptions.getDefaultOptionsFolder(), (File)new File(Minecraft.func_71410_x().field_71412_D, "config"), (FileFilter)new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return !file.getName().equals("options.txt") && !file.getName().equals("optionsof.txt") && !file.getName().equals("keybindings.txt") && !file.getName().equals(DefaultOptions.MOD_ID) && !file.getName().equals("servers.dat");
                }
            });
            return true;
        }
        catch (IOException e) {
            logger.error((Object)e);
            return false;
        }
    }

    public static boolean applyDefaultOptions() {
        File defaultOptionsFile = new File(DefaultOptions.getDefaultOptionsFolder(), "options.txt");
        if (defaultOptionsFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(defaultOptionsFile));
                 PrintWriter writer = new PrintWriter(new FileWriter(new File(Minecraft.func_71410_x().field_71412_D, "options.txt")));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("key_")) continue;
                    writer.println(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static boolean applyDefaultOptionsOptiFine() {
        File defaultOptionsFile = new File(DefaultOptions.getDefaultOptionsFolder(), "optionsof.txt");
        if (defaultOptionsFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(defaultOptionsFile));
                 PrintWriter writer = new PrintWriter(new FileWriter(new File(Minecraft.func_71410_x().field_71412_D, "optionsof.txt")));){
                String line;
                while ((line = reader.readLine()) != null) {
                    writer.println(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public boolean saveDefaultOptionsOptiFine() {
        if (!FMLClientHandler.instance().hasOptifine()) {
            return true;
        }
        Minecraft.func_71410_x().field_71474_y.func_74303_b();
        try (PrintWriter writer = new PrintWriter(new FileWriter(new File(DefaultOptions.getDefaultOptionsFolder(), "optionsof.txt")));
             BufferedReader reader = new BufferedReader(new FileReader(new File(Minecraft.func_71410_x().field_71412_D, "optionsof.txt")));){
            String line;
            while ((line = reader.readLine()) != null) {
                writer.println(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean saveDefaultOptions() {
        Minecraft.func_71410_x().field_71474_y.func_74303_b();
        try (PrintWriter writer = new PrintWriter(new FileWriter(new File(DefaultOptions.getDefaultOptionsFolder(), "options.txt")));
             BufferedReader reader = new BufferedReader(new FileReader(new File(Minecraft.func_71410_x().field_71412_D, "options.txt")));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("key_")) continue;
                writer.println(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean saveDefaultServers() {
        File serversDat = new File(Minecraft.func_71410_x().field_71412_D, "servers.dat");
        if (serversDat.exists()) {
            try {
                FileUtils.copyFile((File)serversDat, (File)new File(DefaultOptions.getDefaultOptionsFolder(), "servers.dat"));
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public boolean saveDefaultMappings() {
        try (PrintWriter writer = new PrintWriter(new FileWriter(new File(DefaultOptions.getDefaultOptionsFolder(), "keybindings.txt")));){
            for (KeyBinding keyBinding : Minecraft.func_71410_x().field_71474_y.field_74324_K) {
                writer.println("key_" + keyBinding.func_151464_g() + ":" + keyBinding.func_151463_i() + ":" + keyBinding.getKeyModifier().name());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void reloadDefaultMappings() {
        File knownKeysFile;
        block51: {
            defaultKeys.clear();
            knownKeys.clear();
            File defaultKeysFile = new File(DefaultOptions.getDefaultOptionsFolder(), "keybindings.txt");
            if (defaultKeysFile.exists()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(defaultKeysFile));
                    Throwable throwable = null;
                    block35: while (true) {
                        try {
                            String line;
                            while ((line = reader.readLine()) != null) {
                                Matcher matcher;
                                if (line.isEmpty() || !(matcher = this.PATTERN.matcher(line)).matches()) continue;
                                try {
                                    KeyModifier modifier = matcher.group(3) != null ? KeyModifier.valueFromString((String)matcher.group(3)) : KeyModifier.NONE;
                                    defaultKeys.put(matcher.group(1), new DefaultBinding(Integer.parseInt(matcher.group(2)), modifier));
                                    continue block35;
                                }
                                catch (NumberFormatException e) {
                                    e.printStackTrace();
                                }
                            }
                            break block51;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    finally {
                        if (reader != null) {
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                reader.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if ((knownKeysFile = new File(Minecraft.func_71410_x().field_71412_D, "knownkeys.txt")).exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(knownKeysFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    knownKeys.add(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (KeyBinding keyBinding : Minecraft.func_71410_x().field_71474_y.field_74324_K) {
            if (!defaultKeys.containsKey(keyBinding.func_151464_g())) continue;
            DefaultBinding defaultBinding = defaultKeys.get(keyBinding.func_151464_g());
            keyBinding.field_151472_e = defaultBinding.keyCode;
            ReflectionHelper.setPrivateValue(KeyBinding.class, (Object)keyBinding, (Object)defaultBinding.modifier, (String[])new String[]{"keyModifierDefault"});
            if (knownKeys.contains(keyBinding.func_151464_g())) continue;
            keyBinding.setKeyModifierAndCode(keyBinding.getKeyModifierDefault(), keyBinding.func_151469_h());
            knownKeys.add(keyBinding.func_151464_g());
        }
        KeyBinding.func_74508_b();
        try (PrintWriter writer = new PrintWriter(new FileWriter(new File(Minecraft.func_71410_x().field_71412_D, "knownkeys.txt")));){
            for (String key : knownKeys) {
                writer.println(key);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static File getDefaultOptionsFolder() {
        File defaultOptions = new File(Minecraft.func_71410_x().field_71412_D, "config/defaultoptions");
        defaultOptions.mkdirs();
        return defaultOptions;
    }

    static {
        defaultKeys = Maps.newHashMap();
        knownKeys = Lists.newArrayList();
    }

    private static class DefaultBinding {
        public final int keyCode;
        public final KeyModifier modifier;

        public DefaultBinding(int keyCode, KeyModifier modifier) {
            this.keyCode = keyCode;
            this.modifier = modifier;
        }
    }
}

