/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.FMLCommonHandler;
import reborncore.RebornCore;
import reborncore.common.RebornCoreConfig;
import reborncore.common.util.serialization.SerializationUtil;

public class PowerSystem {
    public static File priorityConfig;
    private static int euPriority;
    private static int forgePriority;
    private static int euPriorityDefault;
    private static int forgePriorityDefault;
    private static final char[] magnitude;

    public static String getLocaliszedPower(double eu) {
        return PowerSystem.getLocaliszedPower((int)eu);
    }

    public static String getLocaliszedPowerNoSuffix(double eu) {
        return PowerSystem.getLocaliszedPowerNoSuffix((int)eu);
    }

    public static String getLocaliszedPowerFormatted(double eu) {
        return PowerSystem.getLocaliszedPowerFormatted((int)eu);
    }

    public static String getLocaliszedPowerFormattedNoSuffix(double eu) {
        return PowerSystem.getLocaliszedPowerFormattedNoSuffix((int)eu);
    }

    public static String getLocaliszedPower(int eu) {
        if (PowerSystem.getDisplayPower() == EnergySystem.EU) {
            return PowerSystem.getRoundedString(eu, EnergySystem.EU.abbreviation);
        }
        return PowerSystem.getRoundedString(eu * RebornCoreConfig.euPerFU, PowerSystem.getDisplayPower().abbreviation);
    }

    public static String getLocaliszedPowerNoSuffix(int eu) {
        if (PowerSystem.getDisplayPower() == EnergySystem.EU) {
            return PowerSystem.getRoundedString(eu, "");
        }
        return PowerSystem.getRoundedString(eu * RebornCoreConfig.euPerFU, "");
    }

    public static String getLocaliszedPowerFormatted(int eu) {
        if (PowerSystem.getDisplayPower() == EnergySystem.EU) {
            return PowerSystem.getRoundedString(eu, EnergySystem.EU.abbreviation);
        }
        return PowerSystem.getRoundedString(eu * RebornCoreConfig.euPerFU, PowerSystem.getDisplayPower().abbreviation, true);
    }

    public static String getLocaliszedPowerFormattedNoSuffix(int eu) {
        if (PowerSystem.getDisplayPower() == EnergySystem.EU) {
            return PowerSystem.getRoundedString(eu, "", true);
        }
        return PowerSystem.getRoundedString(eu * RebornCoreConfig.euPerFU, "", true);
    }

    private static String getRoundedString(int value, String units) {
        return PowerSystem.getRoundedString(value, units, false);
    }

    private static String getRoundedString(int euValue, String units, boolean doFormat) {
        String ret = "";
        float value = 0.0f;
        int i = 0;
        boolean showMagnitude = true;
        if (euValue < 0) {
            ret = "-";
            euValue = -euValue;
        }
        if (euValue < 1000) {
            doFormat = false;
            showMagnitude = false;
            value = euValue;
        } else if (euValue >= 1000) {
            i = 0;
            while (true) {
                if (euValue < 10000 && euValue % 1000 >= 100) {
                    value = euValue / 1000;
                    value += (float)euValue % 1000.0f / 1000.0f;
                    break;
                }
                if ((euValue /= 1000) < 1000) {
                    value = euValue;
                    break;
                }
                ++i;
            }
        }
        ret = FMLCommonHandler.instance().getEffectiveSide().isClient() && doFormat ? ret + NumberFormat.getNumberInstance(Locale.forLanguageTag(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a())).format(value) : ret + value;
        if (showMagnitude) {
            ret = ret + magnitude[i];
        }
        if (units != "") {
            ret = ret + " " + units;
        }
        return ret;
    }

    public static EnergySystem getDisplayPower() {
        int eu = euPriority;
        int fe = forgePriority;
        if (eu > fe && RebornCoreConfig.getRebornPower().eu()) {
            return EnergySystem.EU;
        }
        return EnergySystem.FE;
    }

    public static void bumpPowerConfig() {
        EnergyPriorityConfig config = new EnergyPriorityConfig();
        if (PowerSystem.getDisplayPower() == EnergySystem.EU) {
            config.setEuPriority(0);
            config.setForgePriority(1);
        } else if (PowerSystem.getDisplayPower() == EnergySystem.FE) {
            config.setEuPriority(1);
            config.setForgePriority(0);
        }
        PowerSystem.writeConfig(config);
    }

    public static void reloadConfig() {
        if (!priorityConfig.exists()) {
            PowerSystem.writeConfig(new EnergyPriorityConfig());
        }
        if (priorityConfig.exists()) {
            EnergyPriorityConfig config = null;
            try (FileReader reader = new FileReader(priorityConfig);){
                config = (EnergyPriorityConfig)SerializationUtil.GSON.fromJson((Reader)reader, EnergyPriorityConfig.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                RebornCore.logHelper.error("Failed to read power config, will reset to defautls and save a new file.");
            }
            if (config == null) {
                config = new EnergyPriorityConfig();
                PowerSystem.writeConfig(config);
            }
            euPriority = config.euPriority;
            forgePriority = config.forgePriority;
        }
    }

    public static void writeConfig(EnergyPriorityConfig config) {
        try (FileWriter writer = new FileWriter(priorityConfig);){
            SerializationUtil.GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PowerSystem.reloadConfig();
    }

    static /* synthetic */ int access$000() {
        return euPriorityDefault;
    }

    static /* synthetic */ int access$100() {
        return forgePriorityDefault;
    }

    static {
        euPriorityDefault = 0;
        forgePriorityDefault = 1;
        magnitude = new char[]{'k', 'M', 'G', 'T'};
    }

    public static class EnergyPriorityConfig {
        public int euPriority = PowerSystem.access$000();
        public int forgePriority = PowerSystem.access$100();

        public int getEuPriority() {
            return this.euPriority;
        }

        public void setEuPriority(int euPriority) {
            this.euPriority = euPriority;
        }

        public int getForgePriority() {
            return this.forgePriority;
        }

        public void setForgePriority(int forgePriority) {
            this.forgePriority = forgePriority;
        }
    }

    public static enum EnergySystem {
        EU(-8387072, "EU", 43, 151, -10027008),
        FE(-4315110, "FE", 15, 151, -6943475);

        public int colour;
        public int altColour;
        public String abbreviation;
        public int xBar;
        public int yBar;

        private EnergySystem(int colour, String abbreviation, int xBar, int yBar, int altColour) {
            this.colour = colour;
            this.abbreviation = abbreviation;
            this.xBar = xBar;
            this.yBar = yBar;
            this.altColour = altColour;
        }
    }
}

