/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.tile;

import com.feed_the_beast.ftblib.lib.config.ConfigBoolean;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.IConfigCallback;
import com.feed_the_beast.ftblib.lib.tile.EnumSaveType;
import com.latmod.yabba.YabbaItems;
import com.latmod.yabba.api.YabbaConfigEvent;
import com.latmod.yabba.block.BlockAdvancedBarrelBase;
import com.latmod.yabba.item.upgrade.ItemUpgradeRedstone;
import com.latmod.yabba.tile.TileBarrelBase;
import com.latmod.yabba.util.BarrelLook;
import com.latmod.yabba.util.EnumBarrelModel;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileAdvancedBarrelBase
extends TileBarrelBase
implements IConfigCallback {
    private BarrelLook look = BarrelLook.DEFAULT;
    public ConfigBoolean alwaysDisplayData = new ConfigBoolean(false);
    public ConfigBoolean displayBar = new ConfigBoolean(false);
    public long lastClick;
    private float cachedRotationY;
    private AxisAlignedBB cachedAABB;

    @Override
    protected void writeData(NBTTagCompound nbt, EnumSaveType type) {
        super.writeData(nbt, type);
        if (!this.look.model.isDefault()) {
            nbt.func_74778_a("Model", this.look.model.getNBTName());
        }
        if (!this.look.skin.isEmpty()) {
            nbt.func_74778_a("Skin", this.look.skin);
        }
        if (this.alwaysDisplayData.getBoolean()) {
            nbt.func_74757_a("AlwaysDisplayData", true);
        }
        if (this.displayBar.getBoolean()) {
            nbt.func_74757_a("DisplayBar", true);
        }
    }

    @Override
    protected void readData(NBTTagCompound nbt, EnumSaveType type) {
        super.readData(nbt, type);
        this.look = BarrelLook.get(EnumBarrelModel.getFromNBTName(nbt.func_74779_i("Model")), nbt.func_74779_i("Skin"));
        this.alwaysDisplayData.setBoolean(nbt.func_74767_n("AlwaysDisplayData"));
        this.displayBar.setBoolean(nbt.func_74767_n("DisplayBar"));
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.cachedRotationY = -1.0f;
        this.cachedAABB = null;
    }

    public float getRotationAngleY() {
        if (this.cachedRotationY == -1.0f) {
            IBlockState state = this.getBlockState();
            if (!(state.func_177230_c() instanceof BlockAdvancedBarrelBase)) {
                return 0.0f;
            }
            this.cachedRotationY = ((EnumFacing)state.func_177229_b(BlockAdvancedBarrelBase.FACING)).func_185119_l() + 180.0f;
        }
        return this.cachedRotationY;
    }

    @Override
    public BarrelLook getLook() {
        return this.look;
    }

    @Override
    public boolean setLook(BarrelLook l, boolean simulate) {
        if (!this.look.equals(l)) {
            if (!simulate) {
                this.look = l;
                this.markBarrelDirty(true);
                this.func_145836_u();
            }
            return true;
        }
        return false;
    }

    public boolean canConnectRedstone(@Nullable EnumFacing facing) {
        return this.getUpgradeData(YabbaItems.UPGRADE_REDSTONE_OUT) instanceof ItemUpgradeRedstone.Data;
    }

    public int redstoneOutput(EnumFacing facing) {
        return 0;
    }

    public String getItemDisplayName() {
        return "ERROR";
    }

    public String getItemDisplayCount(boolean isSneaking, boolean isCreative, boolean infinite) {
        return "ERROR";
    }

    public void addItem(EntityPlayer player, EnumHand hand) {
    }

    public void addAllItems(EntityPlayer player, EnumHand hand) {
    }

    public void removeItem(EntityPlayer player, boolean stack) {
    }

    @Override
    public void createConfig(YabbaConfigEvent event) {
        super.createConfig(event);
        event.getConfig().add("always_display_data", (ConfigValue)this.alwaysDisplayData, (ConfigValue)new ConfigBoolean(false)).setDisplayName((ITextComponent)new TextComponentTranslation("yabba_client.general.always_display_data", new Object[0]));
        if (!this.tier.infiniteCapacity()) {
            event.getConfig().add("display_bar", (ConfigValue)this.displayBar, (ConfigValue)new ConfigBoolean(false)).setDisplayName((ITextComponent)new TextComponentTranslation("yabba_client.general.display_bar", new Object[0]));
        }
    }

    public AxisAlignedBB getAABB(IBlockState state) {
        if (this.cachedAABB == null) {
            this.cachedAABB = this.getLook().model.getAABB(state);
        }
        return this.cachedAABB;
    }
}

