/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.ftba.web;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import me.modmuss50.ftba.client.ClientDataManager;
import me.modmuss50.ftba.client.RunComparison;
import me.modmuss50.ftba.client.hud.Timer;
import me.modmuss50.ftba.files.runs.RunData;
import me.modmuss50.ftba.repack.fi.iki.elonen.NanoHTTPD;
import me.modmuss50.ftba.util.TimerServerHandler;
import me.modmuss50.ftba.web.PageBuilder;
import org.apache.commons.lang3.tuple.Pair;

public class WebServer
extends NanoHTTPD {
    String indexData;
    HashMap<String, Pair<String, String>> streamMap = new HashMap();
    public static WebServer SERVER;

    public WebServer() throws IOException, URISyntaxException {
        super(7123);
        this.loadFiles();
        this.start(5000, false);
        System.out.println("\nRunning! Point your browsers to http://localhost:7123/ \n");
    }

    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        if (session.getUri().equals("/") || session.getUri().equals("/index.html")) {
            return WebServer.newFixedLengthResponse(this.indexData);
        }
        if (session.getUri().equals("/time")) {
            String response = "<h2>" + Timer.getNiceTime() + "</h2>";
            if (RunComparison.getRunData() != null) {
                RunData runData = RunComparison.getRunData();
                response = response + "<h4>Comparing run against " + runData.userName + "</h4><p>Time to beat: " + TimerServerHandler.getNiceTimeFromLong(runData.totalTime) + "</p>";
            }
            return WebServer.newFixedLengthResponse(response);
        }
        if (session.getUri().equals("/data")) {
            return WebServer.newFixedLengthResponse(PageBuilder.getData(this, ClientDataManager.getConfigFormat(), ClientDataManager.getWorldFormat()));
        }
        if (this.streamMap.containsKey(session.getUri())) {
            Pair<String, String> responseData = this.streamMap.get(session.getUri());
            try {
                return WebServer.newChunkedResponse(NanoHTTPD.Response.Status.OK, (String)responseData.getRight(), this.getInputStream((String)responseData.getLeft()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return WebServer.newFixedLengthResponse("An error has occurred!");
    }

    public void loadFiles() throws IOException, URISyntaxException {
        this.streamMap.clear();
        this.indexData = this.readFile("index.html");
        this.streamMap.put("/bootstrap-theme.min.css", this.getFileResponse("bootstrap-theme.min.css"));
        this.streamMap.put("/bootstrap.min.css", this.getFileResponse("bootstrap.min.css"));
        this.streamMap.put("/script.js", this.getFileResponse("script.js"));
        this.streamMap.put("/style.css", this.getFileResponse("style.css"));
        this.streamMap.put("/jquery-3.2.0.min.js", this.getFileResponse("jquery-3.2.0.min.js"));
    }

    public String readFile(String name) throws IOException {
        return Resources.toString((URL)WebServer.class.getResource("/assets/ftbachievements/web/" + name), (Charset)Charsets.UTF_8);
    }

    public Pair<String, String> getFileResponse(String name) throws IOException, URISyntaxException {
        return Pair.of((Object)name, (Object)this.getContentType(name));
    }

    public String getContentType(String name) {
        if (name.endsWith(".js")) {
            return "application/javascript";
        }
        return "text/css";
    }

    public InputStream getInputStream(String name) throws IOException {
        InputStream inputStream = WebServer.class.getResource("/assets/ftbachievements/web/" + name).openStream();
        return inputStream;
    }
}

