/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.ftba.util.recipes;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.modmuss50.ftba.FTBAchievements;
import me.modmuss50.ftba.api.IPoweredRecipe;
import me.modmuss50.ftba.client.gui.poweredCrafting.ContainerCraftingTable;
import me.modmuss50.ftba.packets.PacketSendJEIRecipeData;
import me.modmuss50.ftba.util.FTBTeamUtil;
import me.modmuss50.ftba.util.recipes.ITieredRecipe;
import me.modmuss50.ftba.util.recipes.PoweredCraftingManager;
import me.modmuss50.ftba.util.recipes.PoweredRecipes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.io.FileUtils;
import reborncore.RebornCore;
import reborncore.common.util.serialization.SerializationUtil;

public class PoweredTierRecipe {
    static final List<RecipeGroupTracker> groupTracker = new ArrayList<RecipeGroupTracker>();
    static final Map<String, Integer> maxTierMap = new LinkedHashMap<String, Integer>();

    public static void addTierdShapedRecipe(String id, int teir, ItemStack output, int power, Object ... ingredients) {
        ResourceLocation resourceLocation = new ResourceLocation("ftbachievements", id + "_" + teir);
        TiredShapedRecipe recipe = new TiredShapedRecipe(resourceLocation, id, teir, output, power, ingredients);
        PoweredCraftingManager.register(resourceLocation, recipe);
    }

    public static void addTierdShapelessRecipe(String id, int teir, ItemStack output, int power, Object ... ingredients) {
        ResourceLocation resourceLocation = new ResourceLocation("ftbachievements", id + "_" + teir);
        TiredShapelessRecipe recipe = new TiredShapelessRecipe(resourceLocation, id, teir, output, power, ingredients);
        PoweredCraftingManager.register(resourceLocation, recipe);
    }

    public static String getTeamID(EntityPlayer player) {
        return FTBAchievements.proxy.getTeamName(player);
    }

    public static RecipeGroupTracker getTrackerForPlayer(EntityPlayer player, String recipe) {
        String teamID = PoweredTierRecipe.getTeamID(player);
        for (RecipeGroupTracker tracker : groupTracker) {
            if (!tracker.teamID.equals(teamID) || !tracker.recipeGroup.equals(recipe)) continue;
            return tracker;
        }
        RecipeGroupTracker tracker = new RecipeGroupTracker();
        tracker.setRecipeGroup(recipe);
        tracker.setTeamID(teamID);
        groupTracker.add(tracker);
        return tracker;
    }

    public static List<RecipeGroupTracker> getTrackersForPlayers(EntityPlayer player) {
        String teamID = PoweredTierRecipe.getTeamID(player);
        return groupTracker.stream().filter(input -> ((RecipeGroupTracker)input).teamID.equals(teamID)).collect(Collectors.toList());
    }

    private static void updateMaxTier(String id, int tier) {
        if (maxTierMap.containsKey(id) && maxTierMap.get(id) > tier) {
            return;
        }
        if (maxTierMap.containsKey(id)) {
            maxTierMap.remove(id);
        }
        maxTierMap.put(id, tier);
    }

    @SubscribeEvent
    public static void worldSaveEvent(WorldEvent.Save event) {
        PoweredTierRecipe.save(event.getWorld().func_72860_G());
    }

    @SubscribeEvent
    public static void worldLoadEvent(WorldEvent.Load event) throws IOException {
        PoweredTierRecipe.load(event.getWorld().func_72860_G());
    }

    public static void save(ISaveHandler saveHandler) {
        SaveFormat saveFormat = new SaveFormat(groupTracker, "0");
        ThreadedFileIOBase.func_178779_a().func_75735_a(() -> {
            File file = new File(saveHandler.func_75765_b(), "craftingTiers.json");
            try {
                FileUtils.writeStringToFile((File)file, (String)SerializationUtil.GSON.toJson((Object)saveFormat), (Charset)Charsets.UTF_8);
            }
            catch (IOException ioe) {
                RebornCore.logHelper.error((Object)"Failed to write the craftingTiers.json file");
                RebornCore.logHelper.error((Object)ioe);
            }
            return false;
        });
    }

    public static void load(ISaveHandler saveHandler) throws IOException {
        if (saveHandler == null || saveHandler.func_75765_b() == null) {
            RebornCore.logHelper.error((Object)"Failed to read crafting teirs json");
            groupTracker.clear();
            return;
        }
        File file = new File(saveHandler.func_75765_b(), "craftingTiers.json");
        if (!file.exists()) {
            groupTracker.clear();
            return;
        }
        String json = FileUtils.readFileToString((File)file, (Charset)Charsets.UTF_8);
        SaveFormat saveFormat = (SaveFormat)SerializationUtil.GSON.fromJson(json, SaveFormat.class);
        if (saveFormat != null && saveFormat.groupTracker != null) {
            groupTracker.clear();
            groupTracker.addAll(saveFormat.groupTracker);
        }
    }

    public static class SaveFormat {
        List<RecipeGroupTracker> groupTracker;
        String saveVersion;

        public SaveFormat(List<RecipeGroupTracker> groupTracker, String saveVersion) {
            this.groupTracker = groupTracker;
            this.saveVersion = saveVersion;
        }

        public SaveFormat() {
        }

        public List<RecipeGroupTracker> getGroupTracker() {
            return this.groupTracker;
        }

        public void setGroupTracker(List<RecipeGroupTracker> groupTracker) {
            this.groupTracker = groupTracker;
        }

        public String getSaveVersion() {
            return this.saveVersion;
        }

        public void setSaveVersion(String saveVersion) {
            this.saveVersion = saveVersion;
        }
    }

    public static class RecipeGroupTracker {
        private String recipeGroup;
        private String teamID;
        public int currentTier;

        public void increaseTier(EntityPlayer player) {
            if (maxTierMap.get(this.recipeGroup) == this.currentTier) {
                if (player instanceof EntityPlayerMP) {
                    PacketSendJEIRecipeData.sendJEIPacket((EntityPlayerMP)player);
                }
                return;
            }
            ++this.currentTier;
            FTBTeamUtil.handleOnlineMemebers(player, player1 -> {
                player1.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "The recipe difficultly has been increased"));
                PacketSendJEIRecipeData.sendJEIPacket((EntityPlayerMP)player1);
                if (player1.field_71070_bA != null && player1.field_71070_bA instanceof ContainerCraftingTable) {
                    player1.field_71070_bA.func_75130_a(null);
                }
            });
        }

        public void resetTeir(EntityPlayer player) {
            this.currentTier = 0;
            FTBTeamUtil.handleOnlineMemebers(player, player1 -> {
                PacketSendJEIRecipeData.sendJEIPacket((EntityPlayerMP)player1);
                if (player1.field_71070_bA != null && player1.field_71070_bA instanceof ContainerCraftingTable) {
                    player1.field_71070_bA.func_75130_a(null);
                }
            });
        }

        public String getRecipeGroup() {
            return this.recipeGroup;
        }

        public void setRecipeGroup(String recipeGroup) {
            Preconditions.checkArgument((!recipeGroup.isEmpty() ? 1 : 0) != 0);
            this.recipeGroup = recipeGroup;
        }

        public String getTeamID() {
            return this.teamID;
        }

        public void setTeamID(String teamID) {
            this.teamID = teamID;
        }

        public int getCurrentTier() {
            return this.currentTier;
        }
    }

    public static class PoweredParentTierRecipe
    extends PoweredRecipes.PoweredParentRecipe
    implements ITieredRecipe {
        String id;
        int tier;

        public PoweredParentTierRecipe(IRecipe parentRecipe, int power, String id, int tier) {
            super(parentRecipe, power);
            Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0);
            this.id = id;
            this.tier = tier;
            PoweredTierRecipe.updateMaxTier(id, tier);
        }

        @Override
        public boolean enabled(EntityPlayer player) {
            RecipeGroupTracker tracker = PoweredTierRecipe.getTrackerForPlayer(player, this.id);
            if (tracker.currentTier == maxTierMap.get(this.id)) {
                return tracker.currentTier == this.tier;
            }
            return tracker.currentTier == this.tier;
        }

        @Override
        public void onCraft(EntityPlayer player) {
            RecipeGroupTracker tracker = PoweredTierRecipe.getTrackerForPlayer(player, this.id);
            tracker.increaseTier(player);
        }

        @Override
        public int getTier() {
            return this.tier;
        }

        @Override
        public String getTierGroup() {
            return this.id;
        }
    }

    public static class TiredShapelessRecipe
    extends ShapelessOreRecipe
    implements IPoweredRecipe,
    ITieredRecipe {
        public int power;
        String id;
        int tier;

        public TiredShapelessRecipe(ResourceLocation resourceLocation, String id, int tier, ItemStack output, int power, Object ... ingredients) {
            super(resourceLocation, output, ingredients);
            this.power = power;
            this.id = id;
            this.tier = tier;
            PoweredTierRecipe.updateMaxTier(id, tier);
        }

        @Override
        public int powerUsage() {
            return this.power;
        }

        @Override
        public boolean enabled(EntityPlayer player) {
            RecipeGroupTracker tracker = PoweredTierRecipe.getTrackerForPlayer(player, this.id);
            if (tracker.currentTier == maxTierMap.get(this.id)) {
                return tracker.currentTier == this.tier;
            }
            return tracker.currentTier == this.tier;
        }

        @Override
        public void onCraft(EntityPlayer player) {
            RecipeGroupTracker tracker = PoweredTierRecipe.getTrackerForPlayer(player, this.id);
            tracker.increaseTier(player);
        }

        @Override
        public int getTier() {
            return this.tier;
        }

        @Override
        public String getTierGroup() {
            return this.id;
        }
    }

    public static class TiredShapedRecipe
    extends ShapedOreRecipe
    implements IPoweredRecipe,
    ITieredRecipe {
        public int power;
        String id;
        int tier;

        public TiredShapedRecipe(ResourceLocation resourceLocation, String id, int tier, ItemStack output, int power, Object ... ingredients) {
            super(resourceLocation, output, ingredients);
            this.power = power;
            this.id = id;
            this.tier = tier;
            PoweredTierRecipe.updateMaxTier(id, tier);
        }

        @Override
        public int powerUsage() {
            return this.power;
        }

        @Override
        public boolean enabled(EntityPlayer player) {
            RecipeGroupTracker tracker = PoweredTierRecipe.getTrackerForPlayer(player, this.id);
            if (tracker.currentTier == maxTierMap.get(this.id)) {
                return tracker.currentTier == this.tier;
            }
            return tracker.currentTier == this.tier;
        }

        @Override
        public void onCraft(EntityPlayer player) {
            RecipeGroupTracker tracker = PoweredTierRecipe.getTrackerForPlayer(player, this.id);
            tracker.increaseTier(player);
        }

        @Override
        public int getTier() {
            return this.tier;
        }

        @Override
        public String getTierGroup() {
            return this.id;
        }
    }
}

