/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.ftba.util.recipes;

import javax.annotation.Nullable;
import me.modmuss50.ftba.api.IPoweredRecipe;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class PoweredRecipes {
    private static NonNullList<Ingredient> buildInput(Object[] input) {
        NonNullList list = NonNullList.func_191196_a();
        for (Object obj : input) {
            if (obj instanceof Ingredient) {
                list.add((Object)((Ingredient)obj));
                continue;
            }
            Ingredient ingredient = CraftingHelper.getIngredient((Object)obj);
            if (ingredient == null) {
                ingredient = Ingredient.field_193370_a;
            }
            list.add((Object)ingredient);
        }
        return list;
    }

    public static class PoweredParentRecipe
    implements IPoweredRecipe {
        IRecipe parentRecipe;
        int power;

        public PoweredParentRecipe(IRecipe parentRecipe, int power) {
            this.parentRecipe = parentRecipe;
            this.power = power;
        }

        @Override
        public int powerUsage() {
            return this.power;
        }

        public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
            return this.parentRecipe.func_77569_a(inv, worldIn);
        }

        public ItemStack func_77572_b(InventoryCrafting inv) {
            return this.parentRecipe.func_77572_b(inv);
        }

        public boolean func_194133_a(int width, int height) {
            return this.parentRecipe.func_194133_a(width, height);
        }

        public ItemStack func_77571_b() {
            return this.parentRecipe.func_77571_b();
        }

        public IRecipe setRegistryName(ResourceLocation name) {
            return (IRecipe)this.parentRecipe.setRegistryName(name);
        }

        @Nullable
        public ResourceLocation getRegistryName() {
            return this.parentRecipe.getRegistryName();
        }

        public Class<IRecipe> getRegistryType() {
            return this.parentRecipe.getRegistryType();
        }

        public IRecipe getParentRecipe() {
            return this.parentRecipe;
        }
    }

    public class PoweredShapedRecipe
    extends ShapedRecipes
    implements IPoweredRecipe {
        public int power;

        public PoweredShapedRecipe(ResourceLocation resourceLocation, ItemStack output, int power, Object ... ingredients) {
            this(resourceLocation, output, power, CraftingHelper.parseShaped((Object[])ingredients), ingredients);
            this.power = power;
        }

        private PoweredShapedRecipe(ResourceLocation resourceLocation, ItemStack output, int power, CraftingHelper.ShapedPrimer primer, Object ... ingredients) {
            super(resourceLocation.toString(), primer.width, primer.height, primer.input, output);
            this.power = power;
        }

        @Override
        public int powerUsage() {
            return this.power;
        }
    }

    public class PoweredShapedOreRecipe
    extends ShapedOreRecipe
    implements IPoweredRecipe {
        public int power;

        public PoweredShapedOreRecipe(ResourceLocation resourceLocation, ItemStack output, int power, Object ... ingredients) {
            super(resourceLocation, output, ingredients);
            this.power = power;
        }

        @Override
        public int powerUsage() {
            return this.power;
        }
    }

    public class PoweredShapelessOreRecipe
    extends ShapelessOreRecipe
    implements IPoweredRecipe {
        public int power;

        public PoweredShapelessOreRecipe(ResourceLocation resourceLocation, ItemStack output, int power, Object ... ingredients) {
            super(resourceLocation, output, ingredients);
            this.power = power;
        }

        @Override
        public int powerUsage() {
            return this.power;
        }
    }

    public static class PoweredShapelessRecipe
    extends ShapelessRecipes
    implements IPoweredRecipe {
        public int power;

        public PoweredShapelessRecipe(ResourceLocation resourceLocation, ItemStack output, int power, Object ... ingredients) {
            super(resourceLocation.toString(), output, PoweredRecipes.buildInput(ingredients));
            this.power = power;
        }

        @Override
        public int powerUsage() {
            return this.power;
        }
    }
}

