/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.ftba.util;

import me.modmuss50.ftba.packets.PacketSendTimerData;
import me.modmuss50.ftba.util.TimerSaveDataFormat;
import net.minecraft.entity.player.EntityPlayerMP;
import reborncore.common.network.INetworkPacket;
import reborncore.common.network.NetworkManager;

public class TimerServerHandler {
    static long startSystemTime;
    static long countedTime;
    static boolean active;
    static long stoppedTime;

    public static long getTimeDifference() {
        return System.currentTimeMillis() - startSystemTime + countedTime;
    }

    public static String getNiceTimeFromLong(long time) {
        int hour = (int)(time / 3600000L);
        int min = (int)((time -= (long)(hour * 3600000)) / 60000L);
        int sec = (int)((time -= (long)(min * 60000)) / 1000L);
        time -= (long)(sec * 1000);
        return String.format("%02d:%02d:%02d", hour, min, sec);
    }

    public static void startTimer(long startTime) {
        countedTime = startTime;
        startSystemTime = System.currentTimeMillis();
        active = true;
    }

    public static void stop() {
        active = false;
        stoppedTime = TimerServerHandler.getTimeDifference();
    }

    public static void reset() {
        startSystemTime = System.currentTimeMillis();
        countedTime = 0L;
        active = false;
        stoppedTime = 0L;
    }

    public static void load(TimerSaveDataFormat format) {
        TimerServerHandler.reset();
        active = format.active;
        if (format.active) {
            TimerServerHandler.startTimer(format.time);
        } else {
            countedTime = format.time;
            stoppedTime = format.time;
        }
    }

    public static TimerSaveDataFormat save() {
        TimerSaveDataFormat saveDataFormat = new TimerSaveDataFormat();
        saveDataFormat.time = !active ? stoppedTime : TimerServerHandler.getTimeDifference();
        saveDataFormat.active = active;
        return saveDataFormat;
    }

    public static long getStoppedTime() {
        return stoppedTime;
    }

    public static boolean isActive() {
        return active;
    }

    public static long getCountedTime() {
        return countedTime;
    }

    public static void syncWithAll() {
        NetworkManager.sendToAll((INetworkPacket)TimerServerHandler.getNetworkPacket());
    }

    public static void syncWith(EntityPlayerMP playerMP) {
        NetworkManager.sendToPlayer((INetworkPacket)TimerServerHandler.getNetworkPacket(), (EntityPlayerMP)playerMP);
    }

    private static INetworkPacket getNetworkPacket() {
        long time = TimerServerHandler.getTimeDifference();
        if (!active) {
            time = stoppedTime;
        }
        return new PacketSendTimerData(time, active);
    }

    public static void main(String[] args) {
        System.out.println(TimerServerHandler.getNiceTimeFromLong(6022949L));
    }
}

