/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.ftba.packets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.modmuss50.ftba.FTBAchievements;
import me.modmuss50.ftba.api.IPoweredRecipe;
import me.modmuss50.ftba.modCompat.jei.JEICompact;
import me.modmuss50.ftba.util.recipes.PoweredCraftingManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import reborncore.common.network.ExtendedPacketBuffer;
import reborncore.common.network.INetworkPacket;
import reborncore.common.network.NetworkManager;

public class PacketSendJEIRecipeData
implements INetworkPacket<PacketSendJEIRecipeData> {
    List<ResourceLocation> hiddenRecipes;
    List<ResourceLocation> visibleRecipes;

    public PacketSendJEIRecipeData(List<ResourceLocation> hiddenRecipes, List<ResourceLocation> visibleRecipes) {
        this.hiddenRecipes = hiddenRecipes;
        this.visibleRecipes = visibleRecipes;
    }

    public PacketSendJEIRecipeData() {
    }

    public void writeData(ExtendedPacketBuffer extendedPacketBuffer) throws IOException {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.listToNBT(this.hiddenRecipes, tagCompound);
        extendedPacketBuffer.func_150786_a(tagCompound);
        tagCompound = new NBTTagCompound();
        this.listToNBT(this.visibleRecipes, tagCompound);
        extendedPacketBuffer.func_150786_a(tagCompound);
    }

    public void listToNBT(List<ResourceLocation> list, NBTTagCompound compound) {
        compound.func_74768_a("size", list.size());
        NBTTagCompound nbtList = new NBTTagCompound();
        for (int i = 0; i < list.size(); ++i) {
            nbtList.func_74778_a(i + "", list.get(i).toString());
        }
        compound.func_74782_a("data", (NBTBase)nbtList);
    }

    public List<ResourceLocation> listFromNBT(NBTTagCompound compound) {
        int size = compound.func_74762_e("size");
        NBTTagCompound data = compound.func_74775_l("data");
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (int i = 0; i < size; ++i) {
            list.add(new ResourceLocation(data.func_74779_i(i + "")));
        }
        return list;
    }

    public void readData(ExtendedPacketBuffer extendedPacketBuffer) throws IOException {
        NBTTagCompound hiddenTag = extendedPacketBuffer.func_150793_b();
        NBTTagCompound visibleTag = extendedPacketBuffer.func_150793_b();
        this.hiddenRecipes = this.listFromNBT(hiddenTag);
        this.visibleRecipes = this.listFromNBT(visibleTag);
    }

    public void processData(PacketSendJEIRecipeData packetSendJEIRecipeData, MessageContext messageContext) {
        FTBAchievements.proxy.clientSideTask(() -> {
            IPoweredRecipe recipe;
            for (ResourceLocation resourceLocation : this.hiddenRecipes) {
                recipe = PoweredCraftingManager.getRecipe(resourceLocation);
                JEICompact.recipeRegistry.hideRecipe(JEICompact.wrapperMap.get(recipe));
            }
            for (ResourceLocation resourceLocation : this.visibleRecipes) {
                recipe = PoweredCraftingManager.getRecipe(resourceLocation);
                JEICompact.recipeRegistry.unhideRecipe(JEICompact.wrapperMap.get(recipe));
            }
        });
    }

    public static PacketSendJEIRecipeData buildPacket(EntityPlayer player) {
        ArrayList<ResourceLocation> enabledRecipes = new ArrayList<ResourceLocation>();
        ArrayList<ResourceLocation> disabledRecipes = new ArrayList<ResourceLocation>();
        for (IPoweredRecipe recipe : PoweredCraftingManager.getAllRecipes()) {
            if (recipe.enabled(player)) {
                enabledRecipes.add(PoweredCraftingManager.getRecipeName(recipe));
                continue;
            }
            disabledRecipes.add(PoweredCraftingManager.getRecipeName(recipe));
        }
        return new PacketSendJEIRecipeData(disabledRecipes, enabledRecipes);
    }

    public static void sendJEIPacket(EntityPlayerMP player) {
        PacketSendJEIRecipeData packet = PacketSendJEIRecipeData.buildPacket((EntityPlayer)player);
        NetworkManager.sendToPlayer((INetworkPacket)packet, (EntityPlayerMP)player);
    }
}

