/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.ftba.modCompat.jei;

import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import me.modmuss50.ftba.api.IPoweredRecipe;
import me.modmuss50.ftba.client.hud.ClientHudRenderer;
import me.modmuss50.ftba.util.recipes.ITieredRecipe;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.crafting.IRecipe;
import org.apache.commons.lang3.Validate;
import reborncore.common.RebornCoreConfig;

public class PoweredRecipeWrapper
implements IRecipeWrapper {
    IRecipeWrapper parentRecipeWrapper;
    IPoweredRecipe recipe;
    private static final char[] magnitude = new char[]{'k', 'M', 'G', 'T'};

    public PoweredRecipeWrapper(IRecipeWrapper parentRecipeWrapper, IRecipe recipe) {
        this.parentRecipeWrapper = parentRecipeWrapper;
        Validate.isTrue((boolean)(recipe instanceof IPoweredRecipe));
        this.recipe = (IPoweredRecipe)recipe;
    }

    public void getIngredients(IIngredients iIngredients) {
        this.parentRecipeWrapper.getIngredients(iIngredients);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.parentRecipeWrapper.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        if (ClientHudRenderer.clientTick < 40) {
            minecraft.field_71466_p.func_78276_b(PoweredRecipeWrapper.getRoundedString(this.recipe.powerUsage(), "EU", true), 57, 43, 0x444444);
        } else {
            minecraft.field_71466_p.func_78276_b(PoweredRecipeWrapper.getRoundedString(this.recipe.powerUsage() * RebornCoreConfig.euPerFU, "RF", true), 57, 43, 0x444444);
        }
        if (ClientHudRenderer.clientTick >= 80) {
            ClientHudRenderer.clientTick = 0;
        }
        if (this.recipe instanceof ITieredRecipe) {
            minecraft.field_71466_p.func_78276_b("Tier " + (((ITieredRecipe)((Object)this.recipe)).getTier() + 1), 57, 5, 0x444444);
        }
    }

    public static String getRoundedString(int euValue, String units, boolean doFormat) {
        String ret = "";
        int value = 0;
        int i = 0;
        boolean showMagnitude = true;
        if (euValue < 0) {
            ret = "-";
            euValue = -euValue;
        }
        if (euValue < 1000) {
            doFormat = false;
            value = euValue;
            showMagnitude = false;
        } else if (euValue >= 1000) {
            i = 0;
            while (true) {
                if (euValue < 10000 && euValue % 1000 >= 100) {
                    value = euValue / 1000 + euValue % 1000 / 100;
                    break;
                }
                if ((euValue /= 1000) < 1000) {
                    value = euValue;
                    break;
                }
                ++i;
            }
        }
        ret = doFormat ? ret + NumberFormat.getIntegerInstance(Locale.forLanguageTag(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a())).format(value) : ret + value;
        if (showMagnitude) {
            ret = ret + magnitude[i];
        }
        if (units != "") {
            ret = ret + " " + units;
        }
        return ret;
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return this.parentRecipeWrapper.getTooltipStrings(mouseX, mouseY);
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return this.parentRecipeWrapper.handleClick(minecraft, mouseX, mouseY, mouseButton);
    }
}

